/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.items;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModKeybind;
import com.github.L_Ender.cataclysm.items.KeybindUsingArmor;
import com.github.L_Ender.cataclysm.message.MessageArmorKey;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class Cursium_Armor
extends ArmorItem
implements KeybindUsingArmor {
    public Cursium_Armor(Holder<ArmorMaterial> material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (CMConfig.Armor_Infinity_Durability) {
            super.setDamage(stack, 0);
        } else {
            super.setDamage(stack, damage);
        }
    }

    public boolean isValidRepairItem(ItemStack p_41134_, ItemStack p_41135_) {
        return p_41135_.is((Item)ModItems.IGNITIUM_INGOT.get());
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        super.inventoryTick(stack, level, entity, i, held);
        if (entity instanceof Player) {
            Player living = (Player)entity;
            if (living.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.CURSIUM_HELMET.get() && level.isClientSide && ModKeybind.HELMET_KEY_ABILITY.isDown()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageArmorKey(EquipmentSlot.HEAD.ordinal(), living.getId(), 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onKeyPacket(living, stack, 5);
            }
            if (living.getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.CURSIUM_BOOTS.get() && level.isClientSide && ModKeybind.BOOTS_KEY_ABILITY.isDown()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageArmorKey(EquipmentSlot.HEAD.ordinal(), living.getId(), 7), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onKeyPacket(living, stack, 7);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        if (this.type == ArmorItem.Type.HELMET) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_helmet.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_helmet.desc2", (Object[])new Object[]{ModKeybind.HELMET_KEY_ABILITY.getTranslatedKeyMessage()}).withStyle(ChatFormatting.DARK_GREEN));
        }
        if (this.type == ArmorItem.Type.CHESTPLATE) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_chestplate.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_chestplate.desc2").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_chestplate.desc3").withStyle(ChatFormatting.DARK_GREEN));
        }
        if (this.type == ArmorItem.Type.LEGGINGS) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_leggings.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_leggings.desc2").withStyle(ChatFormatting.DARK_GREEN));
        }
        if (this.type == ArmorItem.Type.BOOTS) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_boots.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_boots.desc2", (Object[])new Object[]{ModKeybind.BOOTS_KEY_ABILITY.getTranslatedKeyMessage()}).withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    @Override
    public void onKeyPacket(Player player, ItemStack itemStack, int Type2) {
        if (Type2 == 5 && player != null && !player.getCooldowns().isOnCooldown((Item)ModItems.CURSIUM_HELMET.get())) {
            boolean flag = false;
            List list = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(24.0));
            for (Entity entity : list) {
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    flag = true;
                    living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 160));
                }
                if (!flag) continue;
                player.getCooldowns().addCooldown((Item)ModItems.CURSIUM_HELMET.get(), 200);
            }
        }
        if (Type2 == 7 && player != null && player.onGround() && !player.getCooldowns().isOnCooldown((Item)ModItems.CURSIUM_BOOTS.get())) {
            float speed = -1.8f;
            float dodgeYaw = (float)Math.toRadians(player.getYRot() + 90.0f);
            Vec3 m = player.getDeltaMovement().add((double)speed * Math.cos(dodgeYaw), 0.0, (double)speed * Math.sin(dodgeYaw));
            player.setDeltaMovement(m.x, 0.4, m.z);
            player.getCooldowns().addCooldown((Item)ModItems.CURSIUM_BOOTS.get(), 200);
        }
    }

    public ResourceLocation getArmorTexture(@Nonnull ItemStack stack, @Nonnull Entity entity, @Nonnull EquipmentSlot slot, @Nonnull ArmorMaterial.Layer layer, boolean isInnerModel) {
        return ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)("textures/armor/cursium_armor" + (slot == EquipmentSlot.LEGS ? "_legs.png" : ".png")));
    }
}

