/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.projectile;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.NewNetherite_Monstrosity.Netherite_Monstrosity_Entity;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.NewNetherite_Monstrosity.Netherite_Monstrosity_Part;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class Lava_Bomb_Entity
extends ThrowableProjectile {
    public double prevDeltaMovementX;
    public double prevDeltaMovementY;
    public double prevDeltaMovementZ;

    public Lava_Bomb_Entity(EntityType<Lava_Bomb_Entity> type, Level world) {
        super(type, world);
    }

    public Lava_Bomb_Entity(EntityType<Lava_Bomb_Entity> type, Level world, LivingEntity thrower) {
        super(type, thrower, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326229_) {
    }

    protected void onHit(HitResult ray) {
        HitResult.Type raytraceresult$type = ray.getType();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)ray);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)ray);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity shooter = this.getOwner();
        if (!(this.level().isClientSide || result.getEntity() instanceof Lava_Bomb_Entity || result.getEntity() instanceof Netherite_Monstrosity_Part || result.getEntity() instanceof Netherite_Monstrosity_Entity)) {
            this.playSound(SoundEvents.GENERIC_BURN, 1.5f, 0.75f);
            this.level().explode(shooter, this.getX(), this.getY(), this.getZ(), (float)CMConfig.Lavabombradius, Level.ExplosionInteraction.NONE);
            this.doTerrainEffects();
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide()) {
            this.playSound(SoundEvents.GENERIC_BURN, 1.5f, 0.75f);
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)CMConfig.Lavabombradius, Level.ExplosionInteraction.NONE);
            this.doTerrainEffects();
            this.discard();
        }
    }

    private void doTerrainEffects() {
        boolean range = false;
        int ix = Mth.floor((double)this.xOld);
        int iy = Mth.floor((double)this.yOld);
        int iz = Mth.floor((double)this.zOld);
        for (int x = 0; x <= 0; ++x) {
            for (int y = 0; y <= 0; ++y) {
                for (int z = 0; z <= 0; ++z) {
                    BlockPos pos = new BlockPos(ix + x, iy + y, iz + z);
                    this.doTerrainEffect(pos);
                }
            }
        }
    }

    private void doTerrainEffect(BlockPos pos) {
        BlockState state = this.level().getBlockState(pos);
        if (state == Blocks.WATER.defaultBlockState()) {
            this.level().setBlockAndUpdate(pos, Blocks.STONE.defaultBlockState());
        }
        if (this.level().isEmptyBlock(pos) && Blocks.LAVA.defaultBlockState().canSurvive((LevelReader)this.level(), pos)) {
            this.level().setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
        }
    }

    public void tick() {
        super.tick();
        this.prevDeltaMovementX = this.getDeltaMovement().x;
        this.prevDeltaMovementY = this.getDeltaMovement().y;
        this.prevDeltaMovementZ = this.getDeltaMovement().z;
        this.setYRot(-((float)Mth.atan2((double)this.getDeltaMovement().x, (double)this.getDeltaMovement().z)) * 57.295776f);
        this.makeTrail();
    }

    public void makeTrail() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 5; ++i) {
                double dx = this.getX() + (double)(1.5f * (this.random.nextFloat() - 0.5f));
                double dy = this.getY() + (double)(1.5f * (this.random.nextFloat() - 0.5f));
                double dz = this.getZ() + (double)(1.5f * (this.random.nextFloat() - 0.5f));
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, dx, dy, dz, -this.getDeltaMovement().x(), -this.getDeltaMovement().y(), -this.getDeltaMovement().z());
            }
        }
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    protected double getDefaultGravity() {
        return 0.025f;
    }
}

