/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.render.entity;

import com.github.L_Ender.cataclysm.client.model.entity.Tidal_Hook_Model;
import com.github.L_Ender.cataclysm.entity.projectile.Tidal_Hook_Entity;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class Tidal_Hook_Renderer
extends EntityRenderer<Tidal_Hook_Entity> {
    private final Tidal_Hook_Model model = new Tidal_Hook_Model();
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"textures/entity/tidal_hook.png");
    private static final ResourceLocation CHAIN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"textures/entity/tidal_hook_chain.png");
    private static final RenderType CHAIN_LAYER = RenderType.entitySmoothCutout((ResourceLocation)CHAIN_TEXTURE);

    public Tidal_Hook_Renderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(Tidal_Hook_Entity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource provider, int light) {
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)tickDelta, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)tickDelta, (float)entity.xRotO, (float)entity.getXRot()) + 90.0f));
        VertexConsumer vertexConsumer = provider.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        this.model.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
        matrices.pushPose();
        Entity fromEntity = entity.getOwner();
        float x = (float)Mth.lerp((double)tickDelta, (double)entity.xo, (double)entity.getX());
        float y = (float)Mth.lerp((double)tickDelta, (double)entity.yo, (double)entity.getY());
        float z = (float)Mth.lerp((double)tickDelta, (double)entity.zo, (double)entity.getZ());
        if (fromEntity != null) {
            Vec3 distVec;
            Vec3 from = distVec = this.getPositionOfPriorMob(fromEntity, tickDelta).subtract((double)x, (double)y, (double)z);
            Tidal_Hook_Renderer.renderChainCube(from, tickDelta, entity.tickCount, matrices, provider, light);
        }
        matrices.popPose();
    }

    private Vec3 getPositionOfPriorMob(Entity mob, float partialTicks) {
        double d4 = Mth.lerp((double)partialTicks, (double)mob.xo, (double)mob.getX());
        double d5 = Mth.lerp((double)partialTicks, (double)mob.yo, (double)mob.getY());
        double d6 = Mth.lerp((double)partialTicks, (double)mob.zo, (double)mob.getZ());
        float f3 = 0.0f;
        if (mob instanceof Player) {
            Player player = (Player)mob;
            float f = player.getAttackAnim(partialTicks);
            float f1 = Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI));
            float f2 = Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
            int i = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemstack = player.getMainHandItem();
            if (!itemstack.is((Item)ModItems.TIDAL_CLAWS.get())) {
                i = -i;
            }
            double d0 = Mth.sin((float)f2);
            double d1 = Mth.cos((float)f2);
            double d2 = (double)i * 0.35;
            if ((this.entityRenderDispatcher.options == null || this.entityRenderDispatcher.options.getCameraType().isFirstPerson()) && player == Minecraft.getInstance().player) {
                double d7 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
                Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.6f, -1.0f);
                vec3 = vec3.scale(d7);
                vec3 = vec3.yRot(f1 * 0.25f);
                vec3 = vec3.xRot(-f1 * 0.35f);
                d4 = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) + vec3.x;
                d5 = Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY()) + vec3.y;
                d6 = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) + vec3.z;
                f3 = player.getEyeHeight() * 0.5f;
            } else {
                d4 = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) - d1 * d2 - d0 * 0.2;
                d5 = player.yo + (double)player.getEyeHeight() + (player.getY() - player.yo) * (double)partialTicks - 0.45;
                d6 = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) - d0 * d2 + d1 * 0.2;
                f3 = player.isCrouching() ? -0.1875f : 0.0f;
            }
        }
        return new Vec3(d4, d5 + (double)f3, d6);
    }

    public static void renderChainCube(Vec3 from, float tickDelta, int age, PoseStack stack, MultiBufferSource provider, int light) {
        float lengthXY = Mth.sqrt((float)((float)(from.x * from.x + from.z * from.z)));
        float squaredLength = (float)(from.x * from.x + from.y * from.y + from.z * from.z);
        float length = Mth.sqrt((float)squaredLength);
        stack.pushPose();
        stack.mulPose(Axis.YP.rotation((float)(-Math.atan2(from.z, from.x)) - 1.5707964f));
        stack.mulPose(Axis.XP.rotation((float)(-Math.atan2(lengthXY, from.y)) - 1.5707964f));
        stack.mulPose(Axis.ZP.rotationDegrees(25.0f));
        stack.pushPose();
        stack.translate(0.015, -0.2, 0.0);
        VertexConsumer vertexConsumer = provider.getBuffer(CHAIN_LAYER);
        float vertX1 = 0.0f;
        float vertY1 = 0.25f;
        float vertX2 = Mth.sin((float)((float)Math.PI * 2)) * 0.125f;
        float vertY2 = Mth.cos((float)((float)Math.PI * 2)) * 0.125f;
        float minU = 0.0f;
        float maxU = 0.1875f;
        float minV = 0.0f - ((float)age + tickDelta) * 0.01f;
        float maxV = Mth.sqrt((float)squaredLength) / 8.0f - ((float)age + tickDelta) * 0.01f;
        PoseStack.Pose entry = stack.last();
        vertexConsumer.addVertex(entry, vertX1, vertY1, 0.0f).setColor(0, 0, 0, 255).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(entry, vertX1, vertY1, length).setColor(255, 255, 255, 255).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(entry, vertX2, vertY2, length).setColor(255, 255, 255, 255).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(entry, vertX2, vertY2, 0.0f).setColor(0, 0, 0, 255).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, -1.0f, 0.0f);
        stack.popPose();
        stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        stack.translate(-0.015, -0.2, 0.0);
        entry = stack.last();
        vertexConsumer.addVertex(entry, vertX1, vertY1, 0.0f).setColor(0, 0, 0, 255).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(entry, vertX1, vertY1, length).setColor(255, 255, 255, 255).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(entry, vertX2, vertY2, length).setColor(255, 255, 255, 255).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(entry, vertX2, vertY2, 0.0f).setColor(0, 0, 0, 255).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, -1.0f, 0.0f);
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(Tidal_Hook_Entity entity) {
        return TEXTURE;
    }
}

