/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.client.render.CMRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class AbstractTrailParticle
extends Particle {
    private Vec3[] trailPositions = new Vec3[64];
    private int trailPointer = -1;
    public float r;
    public float g;
    public float b;
    protected float trailA = 1.0f;

    public AbstractTrailParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd, float r, float g, float b) {
        super(world, x, y, z);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void tick() {
        this.tickTrail();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xd *= 0.99;
        this.yd *= 0.99;
        this.zd *= 0.99;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            this.yd -= (double)this.gravity;
        }
    }

    public void tickTrail() {
        Vec3 currentPosition = new Vec3(this.x, this.y, this.z);
        if (this.trailPointer == -1) {
            for (int i = 0; i < this.trailPositions.length; ++i) {
                this.trailPositions[i] = currentPosition;
            }
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = currentPosition;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTick) {
        if (this.trailPointer > -1) {
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
            VertexConsumer vertexconsumer = this.getVetrexConsumer(multibuffersource$buffersource);
            Vec3 cameraPos = camera.getPosition();
            float x = (float)Mth.lerp((double)partialTick, (double)this.xo, (double)this.x);
            float y = (float)Mth.lerp((double)partialTick, (double)this.yo, (double)this.y);
            float z = (float)Mth.lerp((double)partialTick, (double)this.zo, (double)this.z);
            PoseStack posestack = new PoseStack();
            posestack.pushPose();
            posestack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
            Vec3 drawFrom = new Vec3((double)x, (double)y, (double)z);
            float zRot = this.getTrailRot(camera);
            Vec3 topAngleVec = new Vec3(0.0, (double)(this.getTrailHeight() / 2.0f), 0.0).zRot(zRot);
            Vec3 bottomAngleVec = new Vec3(0.0, (double)(this.getTrailHeight() / -2.0f), 0.0).zRot(zRot);
            int j = this.getLightColor(partialTick);
            for (int samples = 0; samples < this.sampleCount(); ++samples) {
                Vec3 sample = this.getTrailPosition(samples * this.sampleStep(), partialTick);
                float u1 = (float)samples / (float)this.sampleCount();
                float u2 = u1 + 1.0f / (float)this.sampleCount();
                Vec3 draw1 = drawFrom;
                Vec3 draw2 = sample;
                PoseStack.Pose posestack$pose = posestack.last();
                Matrix4f matrix4f = posestack$pose.pose();
                vertexconsumer.addVertex(matrix4f, (float)draw1.x + (float)bottomAngleVec.x, (float)draw1.y + (float)bottomAngleVec.y, (float)draw1.z + (float)bottomAngleVec.z).setColor(this.r, this.g, this.b, this.trailA).setUv(u1, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(j).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
                vertexconsumer.addVertex(matrix4f, (float)draw2.x + (float)bottomAngleVec.x, (float)draw2.y + (float)bottomAngleVec.y, (float)draw2.z + (float)bottomAngleVec.z).setColor(this.r, this.g, this.b, this.trailA).setUv(u2, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(j).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
                vertexconsumer.addVertex(matrix4f, (float)draw2.x + (float)topAngleVec.x, (float)draw2.y + (float)topAngleVec.y, (float)draw2.z + (float)topAngleVec.z).setColor(this.r, this.g, this.b, this.trailA).setUv(u2, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(j).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
                vertexconsumer.addVertex(matrix4f, (float)draw1.x + (float)topAngleVec.x, (float)draw1.y + (float)topAngleVec.y, (float)draw1.z + (float)topAngleVec.z).setColor(this.r, this.g, this.b, this.trailA).setUv(u1, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(j).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
                drawFrom = sample;
            }
            multibuffersource$buffersource.endBatch();
            posestack.popPose();
        }
    }

    protected VertexConsumer getVetrexConsumer(MultiBufferSource.BufferSource multibuffersource$buffersource) {
        return multibuffersource$buffersource.getBuffer(CMRenderTypes.NEW_TRAIL_EFFECT.apply(this.getTrailTexture()));
    }

    public float getTrailRot(Camera camera) {
        return (float)(-Math.PI) / 180 * camera.getXRot();
    }

    public abstract float getTrailHeight();

    public abstract ResourceLocation getTrailTexture();

    public int sampleCount() {
        return 20;
    }

    public int sampleStep() {
        return 1;
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.removed) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].subtract(d0);
        return d0.add(d1.scale((double)partialTick));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }
}

