/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ModTags;
import mob_grinding_utils.components.FluidContents;
import mob_grinding_utils.components.MGUComponents;
import mob_grinding_utils.inventory.server.ContainerXPSolidifier;
import mob_grinding_utils.recipe.SolidifyRecipe;
import mob_grinding_utils.tile.BEGuiClickable;
import mob_grinding_utils.util.CapHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TileEntityXPSolidifier
extends BlockEntity
implements MenuProvider,
BEGuiClickable {
    public FluidTank tank = new FluidTank(16000);
    private int prevFluidLevel = 0;
    public int moulding_progress = 0;
    public int MAX_MOULDING_TIME = 100;
    public boolean isOn = false;
    private RecipeHolder<SolidifyRecipe> currentRecipe = null;
    public ItemStackHandler inputSlots = new ItemStackHandler(2);
    public ItemStackHandler outputSlot = new ItemStackHandler(1);
    public boolean active;
    public int animationTicks;
    public int prevAnimationTicks;
    public OutputDirection outputDirection = OutputDirection.NONE;

    public TileEntityXPSolidifier(BlockPos pos, BlockState state) {
        super(ModBlocks.XPSOLIDIFIER.getTileEntityType(), pos, state);
    }

    @Override
    public void buttonClicked(int buttonID) {
        switch (buttonID) {
            case 0: {
                this.toggleOutput();
                break;
            }
            case 1: {
                this.toggleOnOff();
            }
        }
        this.updateBlock();
    }

    public FluidTank getTank(@Nullable Direction side) {
        return this.tank;
    }

    public IItemHandler getOutput(@Nullable Direction side) {
        return this.outputSlot;
    }

    public OutputDirection toggleOutput() {
        switch (this.outputDirection.ordinal()) {
            case 4: {
                this.outputDirection = OutputDirection.NONE;
                break;
            }
            case 3: {
                this.outputDirection = OutputDirection.WEST;
                break;
            }
            case 2: {
                this.outputDirection = OutputDirection.SOUTH;
                break;
            }
            case 1: {
                this.outputDirection = OutputDirection.EAST;
                break;
            }
            case 0: {
                this.outputDirection = OutputDirection.NORTH;
            }
        }
        this.setChanged();
        return this.outputDirection;
    }

    public void toggleOnOff() {
        this.isOn = !this.isOn;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityXPSolidifier) {
            TileEntityXPSolidifier tile = (TileEntityXPSolidifier)t;
            if (tile.isOn) {
                if (level.isClientSide && tile.active) {
                    tile.prevAnimationTicks = tile.animationTicks;
                    if (tile.animationTicks < tile.MAX_MOULDING_TIME) {
                        tile.animationTicks += 1 + tile.getModifierAmount();
                    }
                    if (tile.animationTicks >= tile.MAX_MOULDING_TIME) {
                        tile.animationTicks -= tile.MAX_MOULDING_TIME;
                        tile.prevAnimationTicks -= tile.MAX_MOULDING_TIME;
                    }
                }
                if (level.isClientSide && !tile.active) {
                    tile.animationTicks = 0;
                    tile.prevAnimationTicks = 0;
                }
                if (tile.currentRecipe != null) {
                    if (!((SolidifyRecipe)tile.currentRecipe.value()).matches(tile.inputSlots.getStackInSlot(0))) {
                        tile.currentRecipe = null;
                    }
                } else if (!tile.inputSlots.getStackInSlot(0).isEmpty()) {
                    tile.currentRecipe = TileEntityXPSolidifier.getRecipeForMould(tile.inputSlots.getStackInSlot(0));
                }
                if (tile.hasfluid() && tile.canOperate()) {
                    tile.setActive(true);
                    tile.setProgress(tile.getProgress() + 1 + tile.getModifierAmount());
                    if (tile.getProgress() >= tile.MAX_MOULDING_TIME) {
                        tile.setActive(false);
                        tile.outputSlot.setStackInSlot(0, ((SolidifyRecipe)tile.currentRecipe.value()).result());
                        tile.tank.drain(((SolidifyRecipe)tile.currentRecipe.value()).fluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                        return;
                    }
                } else if (tile.getProgress() > 0) {
                    tile.setProgress(0);
                    tile.setActive(false);
                }
                if (tile.outputDirection != OutputDirection.NONE && tile.getOutputFacing() != null) {
                    BlockEntity otherTile = level.getBlockEntity(worldPosition.relative(tile.getOutputFacing()));
                    Optional<IItemHandler> handlerOptional = CapHelper.getItemHandler(level, worldPosition.relative(tile.getOutputFacing()), tile.getOutputFacing().getOpposite());
                    if (otherTile != null && handlerOptional.isPresent()) {
                        handlerOptional.ifPresent(handler -> {
                            if (!tile.outputSlot.getStackInSlot(0).isEmpty()) {
                                ItemStack stack = tile.outputSlot.getStackInSlot(0).copy();
                                stack.setCount(1);
                                ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                                if (stack1.isEmpty()) {
                                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)tile.outputSlot.extractItem(0, 1, false), (boolean)false);
                                    tile.setChanged();
                                }
                            }
                        });
                    } else if (otherTile instanceof Container) {
                        Container iinventory = (Container)otherTile;
                        if (tile.isInventoryFull(iinventory, tile.getOutputFacing())) {
                            return;
                        }
                        if (!tile.outputSlot.getStackInSlot(0).isEmpty()) {
                            ItemStack stack = tile.outputSlot.getStackInSlot(0).copy();
                            ItemStack stack1 = TileEntityXPSolidifier.putStackInInventoryAllSlots(iinventory, tile.outputSlot.extractItem(0, 1, false), tile.getOutputFacing().getOpposite());
                            if (stack1.isEmpty() || stack1.getCount() == 0) {
                                iinventory.setChanged();
                            } else {
                                tile.outputSlot.setStackInSlot(0, stack);
                            }
                        }
                    }
                }
            } else {
                if (level.isClientSide) {
                    tile.animationTicks = 0;
                    tile.prevAnimationTicks = 0;
                }
                if (tile.getProgress() > 0) {
                    tile.setActive(false);
                    tile.setProgress(0);
                }
            }
            if (tile.prevFluidLevel != tile.tank.getFluidAmount()) {
                tile.updateBlock();
                tile.prevFluidLevel = tile.tank.getFluidAmount();
            }
        }
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    private Direction getOutputFacing() {
        switch (this.outputDirection.ordinal()) {
            case 4: {
                return Direction.WEST;
            }
            case 3: {
                return Direction.SOUTH;
            }
            case 2: {
                return Direction.EAST;
            }
            case 1: {
                return Direction.NORTH;
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCachedOutPutRenderStack() {
        if (this.hasMould() && this.inputSlots.getStackInSlot(0).getItem() == ModItems.SOLID_XP_MOULD_BABY.get()) {
            return new ItemStack((ItemLike)ModItems.SOLID_XP_BABY.get(), 1);
        }
        return ItemStack.EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int count) {
        return this.getProgress() * count / this.MAX_MOULDING_TIME;
    }

    private boolean hasfluid() {
        return this.currentRecipe != null && !this.tank.getFluid().isEmpty() && this.tank.getFluid().getAmount() >= ((SolidifyRecipe)this.currentRecipe.value()).fluidAmount() && this.tank.getFluidInTank(0).getFluid().is(ModTags.Fluids.EXPERIENCE);
    }

    private boolean canOperate() {
        return this.hasMould() && this.isOutputEmpty();
    }

    private boolean hasMould() {
        return this.currentRecipe != null && ((SolidifyRecipe)this.currentRecipe.value()).matches(this.inputSlots.getStackInSlot(0));
    }

    @Nullable
    public static RecipeHolder<SolidifyRecipe> getRecipeForMould(ItemStack stack) {
        return MobGrindingUtils.SOLIDIFIER_RECIPES.stream().filter(recipe -> ((SolidifyRecipe)recipe.value()).matches(stack)).findFirst().orElse(null);
    }

    private boolean isOutputEmpty() {
        return this.outputSlot.getStackInSlot(0).isEmpty();
    }

    private boolean hasUpgrade() {
        return !this.inputSlots.getStackInSlot(1).isEmpty() && this.inputSlots.getStackInSlot(1).getItem() == ModItems.XP_SOLIDIFIER_UPGRADE.get();
    }

    public int getModifierAmount() {
        return this.hasUpgrade() ? this.inputSlots.getStackInSlot(1).getCount() : 0;
    }

    private void setProgress(int counter) {
        this.moulding_progress = counter;
    }

    public int getProgress() {
        return this.moulding_progress;
    }

    private boolean isInventoryFull(Container inventoryIn, Direction side) {
        if (inventoryIn instanceof WorldlyContainer) {
            int[] aint;
            WorldlyContainer isidedinventory = (WorldlyContainer)inventoryIn;
            for (int k : aint = isidedinventory.getSlotsForFace(side)) {
                ItemStack itemstack1 = isidedinventory.getItem(k);
                if (!itemstack1.isEmpty() && itemstack1.getCount() == itemstack1.getMaxStackSize()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.getContainerSize();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.getItem(j);
                if (!itemstack.isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack putStackInInventoryAllSlots(Container inventory, ItemStack stack, @Nullable Direction facing) {
        if (inventory instanceof WorldlyContainer) {
            WorldlyContainer isidedinventory = (WorldlyContainer)inventory;
            if (facing != null && !(inventory instanceof TileEntityXPSolidifier) && inventory.canPlaceItem(0, stack.copy())) {
                int[] aint = isidedinventory.getSlotsForFace(facing);
                int k = 0;
                while (k < aint.length) {
                    if (stack.isEmpty()) return stack;
                    stack = TileEntityXPSolidifier.insertStack(inventory, stack, aint[k], facing);
                    ++k;
                }
                return stack;
            }
        }
        int i = inventory.getContainerSize();
        int j = 0;
        while (j < i) {
            if (stack.isEmpty()) return stack;
            stack = TileEntityXPSolidifier.insertStack(inventory, stack, j, facing);
            ++j;
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(Container inventoryIn, ItemStack stack, int index, Direction side) {
        return inventoryIn.canPlaceItem(index, stack) && (!(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).canPlaceItemThroughFace(index, stack, side));
    }

    private static ItemStack insertStack(Container inventory, ItemStack stack, int index, Direction side) {
        ItemStack itemstack = inventory.getItem(index);
        if (TileEntityXPSolidifier.canInsertItemInSlot(inventory, stack, index, side)) {
            if (itemstack.isEmpty()) {
                inventory.setItem(index, stack);
                stack = ItemStack.EMPTY;
            } else if (TileEntityXPSolidifier.canCombine(itemstack, stack)) {
                int i = stack.getMaxStackSize() - itemstack.getCount();
                int j = Math.min(stack.getCount(), i);
                stack.shrink(j);
                itemstack.grow(j);
            }
        }
        return stack;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() != stack2.getItem() ? false : (stack1.getDamageValue() != stack2.getDamageValue() ? false : (stack1.getCount() > stack1.getMaxStackSize() ? false : ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2)));
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.tank.readFromNBT(registries, nbt);
        this.inputSlots.deserializeNBT(registries, nbt.getCompound("inputSlots"));
        this.outputSlot.deserializeNBT(registries, nbt.getCompound("outputSlot"));
        this.outputDirection = OutputDirection.fromString(nbt.getString("outputDirection"));
        this.isOn = nbt.getBoolean("isOn");
        this.active = nbt.getBoolean("active");
        this.moulding_progress = nbt.getInt("moulding_progress");
        if (nbt.contains("currentRecipe")) {
            ResourceLocation id = ResourceLocation.tryParse((String)nbt.getString("currentRecipe"));
            MobGrindingUtils.SOLIDIFIER_RECIPES.stream().filter(recipe -> recipe.id().equals((Object)id)).findFirst().ifPresent(recipe -> {
                this.currentRecipe = recipe;
            });
        }
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.tank.writeToNBT(registries, nbt);
        nbt.put("inputSlots", (Tag)this.inputSlots.serializeNBT(registries));
        nbt.put("outputSlot", (Tag)this.outputSlot.serializeNBT(registries));
        nbt.putString("outputDirection", this.outputDirection.getSerializedName());
        nbt.putBoolean("isOn", this.isOn);
        nbt.putBoolean("active", this.active);
        nbt.putInt("moulding_progress", this.moulding_progress);
        if (this.currentRecipe != null) {
            nbt.putString("currentRecipe", this.currentRecipe.id().toString());
        }
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, (HolderLookup.Provider)this.level.registryAccess());
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, @Nonnull HolderLookup.Provider registries) {
        super.onDataPacket(net, packet, registries);
        this.loadAdditional(packet.getTag(), registries);
        this.onContentsChanged();
    }

    public void updateBlock() {
        this.getLevel().sendBlockUpdated(this.worldPosition, this.getLevel().getBlockState(this.worldPosition), this.getLevel().getBlockState(this.worldPosition), 3);
    }

    public void onContentsChanged() {
        if (this.level != null && this.level.isClientSide) {
            BlockState state = this.level.getBlockState(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), state, state, 8);
            this.setChanged();
        }
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().getAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)"block.mob_grinding_utils.xpsolidifier");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInventory, Player player) {
        return new ContainerXPSolidifier(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    protected void applyImplicitComponents(@Nonnull BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.tank.setFluid(((FluidContents)componentInput.getOrDefault(MGUComponents.FLUID, (Object)FluidContents.EMPTY)).get());
    }

    protected void collectImplicitComponents(@Nonnull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MGUComponents.FLUID, (Object)FluidContents.of(this.tank.getFluid()));
    }

    public static enum OutputDirection implements StringRepresentable
    {
        NONE("none"),
        NORTH("north"),
        EAST("east"),
        SOUTH("south"),
        WEST("west");

        final String name;

        private OutputDirection(String nameIn) {
            this.name = nameIn;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static OutputDirection fromString(String string) {
            for (OutputDirection direction : OutputDirection.values()) {
                if (!direction.name.equals(string)) continue;
                return direction;
            }
            return NONE;
        }
    }
}

