/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockAbsorptionHopper
extends BaseEntityBlock {
    public static final VoxelShape HOPPER_AABB = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final MapCodec<BlockAbsorptionHopper> CODEC = BlockAbsorptionHopper.simpleCodec(BlockAbsorptionHopper::new);

    public BlockAbsorptionHopper(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityAbsorptionHopper(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? null : TileEntityAbsorptionHopper::serverTick;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return HOPPER_AABB;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return HOPPER_AABB;
    }

    @Nonnull
    public InteractionResult useWithoutItem(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult hitResult) {
        BlockEntity tile;
        if (!world.isClientSide && (tile = world.getBlockEntity(pos)) instanceof TileEntityAbsorptionHopper) {
            TileEntityAbsorptionHopper vacuum = (TileEntityAbsorptionHopper)tile;
            if (!player.isShiftKeyDown()) {
                world.sendBlockUpdated(pos, state, state, 3);
                player.openMenu((MenuProvider)vacuum, pos);
            } else {
                vacuum.toggleMode(hitResult.getDirection());
                world.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 0.6f);
                world.sendBlockUpdated(pos, state, state, 3);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        TileEntityAbsorptionHopper tile;
        if (!world.isClientSide && (tile = (TileEntityAbsorptionHopper)world.getBlockEntity(pos)) != null) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)tile);
            world.removeBlockEntity(pos);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }
}

