/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.compat;

import java.util.function.Function;
import mcjty.incontrol.InControl;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCities;
import mcjty.lostcities.api.ILostCityInformation;
import mcjty.lostcities.api.ILostSphere;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModList;

public class LostCitySupport {
    private static boolean registered = false;
    private static ILostCities lostCities;

    public static void register() {
        if (ModList.get().isLoaded("lostcities")) {
            LostCitySupport.registerInternal();
        }
    }

    private static void registerInternal() {
        if (registered) {
            return;
        }
        registered = true;
        InterModComms.sendTo((String)"lostcities", (String)"getLostCities", GetLostCities::new);
        InControl.setup.getLogger().info("Enabling support for Lost Cities");
    }

    private static <T> Level getWorld(IEventQuery<T> query, T event) {
        Level w;
        LevelAccessor world = query.getWorld(event);
        if (world.isClientSide()) {
            return null;
        }
        if (world instanceof Level) {
            w = (Level)world;
        } else if (world instanceof ServerLevelAccessor) {
            w = ((ServerLevelAccessor)world).getLevel();
        } else {
            throw new IllegalStateException("Bad world!");
        }
        return w;
    }

    public static <T> boolean isCity(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.getX() >> 4, pos.getZ() >> 4);
            return chunkInfo.isCity();
        }
        return false;
    }

    public static <T> boolean isStreet(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.getX() >> 4, pos.getZ() >> 4);
            return chunkInfo.isCity() && chunkInfo.getBuildingType() == null;
        }
        return false;
    }

    public static <T> boolean inSphere(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostSphere sphere = info.getSphere(pos.getX(), pos.getZ());
            return sphere != null;
        }
        return false;
    }

    public static <T> boolean isBuilding(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.getX() >> 4, pos.getZ() >> 4);
            return chunkInfo.isCity() && chunkInfo.getBuildingType() != null;
        }
        return false;
    }

    public static <T> boolean isMultiBuilding(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return false;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.getX() >> 4, pos.getZ() >> 4);
            if (!chunkInfo.isCity()) {
                return false;
            }
            ILostChunkInfo.MultiBuildingInfo mi = chunkInfo.getMultiBuildingInfo();
            return mi != null;
        }
        return false;
    }

    public static <T> String getBuildingName(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return null;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.getX() >> 4, pos.getZ() >> 4);
            return chunkInfo.getBuildingType();
        }
        return null;
    }

    public static <T> String getMultiBuildingName(IEventQuery<T> query, T event) {
        Level w = LostCitySupport.getWorld(query, event);
        if (w == null) {
            return null;
        }
        ILostCityInformation info = lostCities.getLostInfo(w);
        if (info != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = info.getChunkInfo(pos.getX() >> 4, pos.getZ() >> 4);
            ILostChunkInfo.MultiBuildingInfo mi = chunkInfo.getMultiBuildingInfo();
            return mi != null ? mi.buildingType().toString() : null;
        }
        return null;
    }

    public static class GetLostCities
    implements Function<ILostCities, Void> {
        @Override
        public Void apply(ILostCities lc) {
            lostCities = lc;
            return null;
        }
    }
}

