/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsjewelry.client.ClientEvents;
import io.redspace.ironsjewelry.core.BonusType;
import io.redspace.ironsjewelry.core.IBonusParameterType;
import io.redspace.ironsjewelry.core.Utils;
import io.redspace.ironsjewelry.core.bonuses.AttributeBonusType;
import io.redspace.ironsjewelry.core.bonuses.PiglinNeutralBonusType;
import io.redspace.ironsjewelry.core.data.AttributeInstance;
import io.redspace.ironsjewelry.core.data.Bonus;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.registry.BonusTypeRegistry;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CurioBaseItem
extends Item
implements ICurioItem {
    String slotIdentifier = "";

    public CurioBaseItem(Item.Properties properties, String slot) {
        super(properties);
        this.slotIdentifier = slot;
    }

    public boolean isEquippedBy(@Nullable LivingEntity entity) {
        return entity != null && CuriosApi.getCuriosInventory((LivingEntity)entity).map(inv -> inv.findFirstCurio((Item)this).isPresent()).orElse(false) != false;
    }

    @NotNull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo((SoundEvent)SoundEvents.ARMOR_EQUIP_CHAIN.value(), 1.0f, 1.0f);
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext tooltipContext, ItemStack stack) {
        JewelryData jewelryData = JewelryData.get(stack);
        if (!jewelryData.isValid()) {
            return List.of();
        }
        ArrayList<Component> shiftTooltip = new ArrayList<Component>();
        if (ClientEvents.isIsShiftKeyDown()) {
            shiftTooltip.add((Component)Component.translatable((String)"tooltip.irons_jewelry.hold_shift", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.shift").withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GRAY));
            shiftTooltip.addAll(CurioBaseItem.getShiftDescription((PatternDefinition)jewelryData.pattern().value(), jewelryData.parts(), Optional.empty()));
        } else {
            shiftTooltip.add((Component)Component.translatable((String)"tooltip.irons_jewelry.hold_shift", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.shift").withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        }
        List attrTooltip = super.getAttributesTooltip(tooltips, tooltipContext, stack);
        boolean needHeader = attrTooltip.isEmpty();
        List<BonusInstance> bonuses = jewelryData.getBonuses();
        if (needHeader && !bonuses.isEmpty()) {
            attrTooltip.add(Component.empty());
            attrTooltip.add(Component.translatable((String)("curios.modifiers." + this.slotIdentifier)).withStyle(ChatFormatting.GOLD));
        }
        bonuses.forEach(bonus -> attrTooltip.addAll(bonus.getTooltipDescription()));
        shiftTooltip.addAll(attrTooltip);
        return shiftTooltip;
    }

    public Component getName(ItemStack itemStack) {
        if (!itemStack.has(DataComponents.ITEM_NAME)) {
            itemStack.set(DataComponents.ITEM_NAME, (Object)JewelryData.get(itemStack).getItemName());
        }
        return Optional.ofNullable((Component)itemStack.get(DataComponents.ITEM_NAME)).orElse(super.getName(itemStack));
    }

    public static List<Component> getShiftDescription(PatternDefinition pattern, Map<Holder<PartDefinition>, Holder<MaterialDefinition>> parts, Optional<List<Integer>> materialCost) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < pattern.partTemplate().size(); ++i) {
            MutableComponent materialComponent;
            PartIngredient partIngredient = pattern.partTemplate().get(i);
            Holder<PartDefinition> currentPart = partIngredient.part();
            MutableComponent partComponent = Component.translatable((String)((PartDefinition)currentPart.value()).descriptionId());
            Optional<Object> bonusComponent = Optional.empty();
            Optional<Object> qualityComponent = Optional.empty();
            int i2 = i;
            Optional<MutableComponent> costComponent = materialCost.map(list -> {
                int count = list.size() > i2 && parts.containsKey(currentPart) && ((PartDefinition)currentPart.value()).canUseMaterial(((MaterialDefinition)((Holder)parts.get(currentPart)).value()).materialType()) ? (Integer)list.get(i2) : 0;
                String cost = String.format("(%s/%s)", count, partIngredient.materialCost());
                return Optional.of(Component.literal((String)"  * ").append((Component)Component.literal((String)cost).withStyle(count >= partIngredient.materialCost() ? ChatFormatting.GREEN : ChatFormatting.RED)).withStyle(ChatFormatting.DARK_GRAY));
            }).orElse(Optional.empty());
            if (!parts.containsKey(currentPart)) {
                materialComponent = Component.translatable((String)"tooltip.irons_jewelry.empty").withStyle(ChatFormatting.RED);
            } else {
                Optional<String> string;
                Tuple tuple2;
                IBonusParameterType<?> type;
                Optional<?> value;
                Holder<MaterialDefinition> mat = parts.get(currentPart);
                materialComponent = Component.translatable((String)((MaterialDefinition)mat.value()).descriptionId()).withStyle(ChatFormatting.DARK_AQUA);
                Optional<Tuple> bonusContribution = pattern.bonuses().stream().filter(tuple -> !((Bonus)tuple.getB()).parameterValue().containsKey(((Bonus)tuple.getB()).bonusType().getParameterType()) && ((PartIngredient)tuple.getA()).part().equals((Object)currentPart)).findFirst();
                Optional<Holder> qualityContribution = pattern.partForQuality().filter(partThatDrivesQuality -> partThatDrivesQuality.equals((Object)currentPart));
                if (bonusContribution.isPresent() && (value = (type = ((Bonus)(tuple2 = bonusContribution.get()).getB()).bonusType().getParameterType()).resolve(((MaterialDefinition)mat.value()).bonusParameters())).isPresent() && (string = type.getValueDescriptionId(value.get())).isPresent()) {
                    bonusComponent = Optional.of(Component.literal((String)"  * ").append((Component)Component.translatable((String)string.get()).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.DARK_GRAY));
                }
                if (qualityContribution.isPresent()) {
                    double quality = ((MaterialDefinition)parts.get(qualityContribution.get()).value()).quality();
                    qualityComponent = Optional.of(Component.literal((String)"  * ").append((Component)Component.translatable((String)"tooltip.irons_jewelry.quality_multiplier", (Object[])new Object[]{quality}).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.DARK_GRAY));
                }
            }
            components.add((Component)Component.literal((String)"> ").append((Component)Component.translatable((String)"tooltip.irons_jewelry.part_to_material", (Object[])new Object[]{partComponent, materialComponent})).withStyle(ChatFormatting.GRAY));
            costComponent.ifPresent(components::add);
            bonusComponent.ifPresent(components::add);
            qualityComponent.ifPresent(components::add);
        }
        return components;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        Player player;
        return wearer instanceof Player && Utils.getEquippedBonuses(player = (Player)wearer).stream().map(BonusInstance::bonusType).anyMatch(bonus -> bonus instanceof PiglinNeutralBonusType);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        JewelryData.ifPresent(stack, data -> data.forBonuses(BonusTypeRegistry.EFFECT_IMMUNITY_BONUS.get(), Holder.class, (bonus, param) -> slotContext.entity().removeEffect(param)));
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        JewelryData data = (JewelryData)stack.get(ComponentRegistry.JEWELRY_COMPONENT);
        if (data != null && slotContext.identifier().equals(this.slotIdentifier)) {
            List<BonusInstance> bonuses = data.getBonuses();
            HashMap collapsedModifiers = new HashMap();
            for (BonusInstance instance : bonuses) {
                BonusType bonusType = instance.bonusType();
                if (!(bonusType instanceof AttributeBonusType)) continue;
                AttributeBonusType attributeBonus = (AttributeBonusType)bonusType;
                attributeBonus.getParameterType().resolve(instance.parameter()).ifPresent(attributeInstance -> {
                    AttributeModifier modifier;
                    AttributeModifier.Operation operation;
                    Map byOperation = collapsedModifiers.computeIfAbsent(attributeInstance.attribute(), x -> new HashMap());
                    if (byOperation.containsKey(operation = (modifier = attributeBonus.modifier((AttributeInstance)attributeInstance, slotContext, instance.quality())).operation())) {
                        AttributeModifier oldModifier = (AttributeModifier)byOperation.get(operation);
                        AttributeModifier jointModifier = new AttributeModifier(oldModifier.id(), oldModifier.amount() + modifier.amount(), operation);
                        byOperation.put(operation, jointModifier);
                    } else {
                        byOperation.put(operation, modifier);
                    }
                });
            }
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Map.Entry entry : collapsedModifiers.entrySet()) {
                builder.putAll((Object)((Holder)entry.getKey()), ((Map)entry.getValue()).values());
            }
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, id, stack);
    }
}

