/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.event;

import io.redspace.ironsjewelry.core.BonusType;
import io.redspace.ironsjewelry.core.Utils;
import io.redspace.ironsjewelry.core.bonuses.EffectOnHitBonusType;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.PlayerData;
import io.redspace.ironsjewelry.core.parameters.ActionParameter;
import io.redspace.ironsjewelry.network.packets.SyncPlayerDataPacket;
import io.redspace.ironsjewelry.registry.BonusTypeRegistry;
import io.redspace.ironsjewelry.registry.DataAttachmentRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class ServerEvents {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPlayerDataPacket((PlayerData)serverPlayer.getData(DataAttachmentRegistry.PLAYER_DATA)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(LivingShieldBlockEvent event) {
        LivingEntity livingEntity;
        if (event.getBlocked() && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            livingEntity = event.getDamageSource().getEntity();
            if (livingEntity instanceof LivingEntity) {
                LivingEntity livingAttacker = livingEntity;
                List<ItemStack> items = Utils.getEquippedJewelry((Player)player);
                for (ItemStack stack : items) {
                    JewelryData.ifPresent(stack, jewelryData -> jewelryData.forBonuses(BonusTypeRegistry.ON_SHIELD_BLOCK_BONUS.get(), ActionParameter.ActionRunnable.class, (bonus, action) -> action.action().handleAction(player.serverLevel(), (BonusInstance)bonus, action.targetSelf(), bonus.cooldown(), player, (Entity)livingAttacker)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((PlayerData)serverPlayer.getData(DataAttachmentRegistry.PLAYER_DATA)).tickCooldowns(1);
        }
    }

    @SubscribeEvent
    public static void onLivingDamaged(LivingIncomingDamageEvent event) {
        List<BonusInstance> bonuses;
        ServerPlayer player;
        DamageSource damageSource = event.getSource();
        Entity attacker = event.getSource().getEntity();
        LivingEntity victim = event.getEntity();
        if (attacker instanceof ServerPlayer) {
            player = (ServerPlayer)attacker;
            bonuses = Utils.getEquippedBonuses((Player)player);
            for (BonusInstance instance : bonuses) {
                if (instance.bonusType().equals(BonusTypeRegistry.ON_PROJECTILE_HIT_BONUS.get())) {
                    if (!(damageSource.getDirectEntity() instanceof Projectile)) continue;
                    BonusTypeRegistry.ON_PROJECTILE_HIT_BONUS.get().getParameterType().resolve(instance).ifPresent(action -> action.action().handleAction(player.serverLevel(), instance, action.targetSelf(), instance.cooldown(), player, (Entity)victim));
                    continue;
                }
                if (!instance.bonusType().equals(BonusTypeRegistry.ON_ATTACK_BONUS.get()) || !damageSource.isDirect()) continue;
                BonusTypeRegistry.ON_ATTACK_BONUS.get().getParameterType().resolve(instance).ifPresent(action -> action.action().handleAction(player.serverLevel(), instance, action.targetSelf(), instance.cooldown(), player, (Entity)victim));
            }
        }
        if (victim instanceof ServerPlayer) {
            player = (ServerPlayer)victim;
            bonuses = Utils.getEquippedBonuses((Player)player);
            for (BonusInstance instance : bonuses) {
                BonusType bonusType = instance.bonusType();
                if (bonusType instanceof EffectOnHitBonusType) {
                    EffectOnHitBonusType effectOnHitBonus = (EffectOnHitBonusType)bonusType;
                    effectOnHitBonus.getParameterType().resolve(instance.parameter()).ifPresent(effect -> player.addEffect(new MobEffectInstance(effect, effectOnHitBonus.durationInTicks((Holder<MobEffect>)effect, instance.quality()))));
                    continue;
                }
                if (!instance.bonusType().equals(BonusTypeRegistry.ON_TAKE_DAMAGE_BONUS.get()) || attacker == null) continue;
                BonusTypeRegistry.ON_TAKE_DAMAGE_BONUS.get().getParameterType().resolve(instance).ifPresent(effect -> effect.action().handleAction(player.serverLevel(), instance, effect.targetSelf(), instance.cooldown(), player, attacker));
            }
        }
    }

    @SubscribeEvent
    public static void onEffectApplication(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Utils.getEquippedJewelry(player).forEach(stack -> JewelryData.ifPresent(stack, data -> data.forBonuses(BonusTypeRegistry.EFFECT_IMMUNITY_BONUS.get(), Holder.class, (bonus, param) -> {
                if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().equals(param)) {
                    event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
                }
            })));
        }
    }
}

