/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.BonusType;
import io.redspace.ironsjewelry.core.IBonusParameterType;
import io.redspace.ironsjewelry.core.data.Bonus;
import io.redspace.ironsjewelry.core.data.JewelryType;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Tuple;

public record PatternDefinition(String descriptionId, JewelryType jewelryType, List<PartIngredient> partTemplate, Optional<Holder<PartDefinition>> partForQuality, boolean unlockedByDefault, double qualityMultiplier) {
    public static final Codec<PatternDefinition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("descriptionId").forGetter(PatternDefinition::descriptionId), (App)IronsJewelryRegistries.JEWELRY_TYPE_REGISTRY.byNameCodec().fieldOf("type").forGetter(PatternDefinition::jewelryType), (App)Codec.list(PartIngredient.CODEC).fieldOf("parts").forGetter(PatternDefinition::partTemplate), (App)IronsJewelryRegistries.Codecs.PART_REGISTRY_CODEC.optionalFieldOf("partForQuality").forGetter(PatternDefinition::partForQuality), (App)Codec.BOOL.optionalFieldOf("unlockedByDefault", (Object)true).forGetter(PatternDefinition::unlockedByDefault), (App)Codec.DOUBLE.optionalFieldOf("qualityMultiplier", (Object)1.0).forGetter(PatternDefinition::qualityMultiplier)).apply((Applicative)builder, PatternDefinition::new));

    public PatternDefinition(String descriptionId, JewelryType jewelryType, List<PartIngredient> partTemplate, Optional<Holder<PartDefinition>> partForQuality, boolean unlockedByDefault, double qualityMultiplier) {
        this.descriptionId = descriptionId;
        this.jewelryType = jewelryType;
        this.partTemplate = partTemplate.stream().sorted(Comparator.comparingInt(PartIngredient::drawOrder)).toList();
        this.partForQuality = partForQuality;
        this.unlockedByDefault = unlockedByDefault;
        this.qualityMultiplier = qualityMultiplier;
    }

    public List<Tuple<PartIngredient, Bonus>> bonuses() {
        return this.partTemplate.stream().flatMap(part -> part.bonuses().stream().map(bonus -> new Tuple(part, bonus))).toList();
    }

    public List<Component> getFullPatternTooltip() {
        Style titleStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE});
        Style headerStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE});
        ChatFormatting infoStyle = ChatFormatting.GRAY;
        MutableComponent title = Component.translatable((String)this.descriptionId()).withStyle(titleStyle);
        MutableComponent partHeader = Component.translatable((String)"tooltip.irons_jewelry.parts_header").withStyle(headerStyle);
        List<MutableComponent> parts = this.partTemplate.stream().map(part -> Component.translatable((String)((PartDefinition)part.part().value()).descriptionId()).withStyle(infoStyle)).toList();
        MutableComponent bonusHeader = Component.translatable((String)(this.bonuses().size() > 1 ? "tooltip.irons_jewelry.bonus_header_plural" : "tooltip.irons_jewelry.bonus_header")).withStyle(headerStyle);
        List<MutableComponent> bonuses = this.bonuses().stream().map(tuple -> {
            MutableComponent component = null;
            if (!((Bonus)tuple.getB()).parameterValue().containsKey(((Bonus)tuple.getB()).bonusType().getParameterType())) {
                component = Component.translatable((String)"tooltip.irons_jewelry.bonus_with_source", (Object[])new Object[]{Component.translatable((String)((Bonus)tuple.getB()).bonusType().getDescriptionId()), Component.translatable((String)((PartDefinition)((PartIngredient)tuple.getA()).part().value()).descriptionId())});
            } else {
                Optional<String> string;
                Map<IBonusParameterType<?>, Object> entries = ((Bonus)tuple.getB()).parameterValue();
                BonusType bonus = ((Bonus)tuple.getB()).bonusType();
                IBonusParameterType<?> type = bonus.getParameterType();
                Optional<?> value = type.resolve(entries);
                if (value.isPresent() && (string = type.getValueDescriptionId(value.get())).isPresent()) {
                    component = Component.translatable((String)"tooltip.irons_jewelry.bonus_with_direct_source", (Object[])new Object[]{Component.translatable((String)bonus.getDescriptionId()), Component.translatable((String)string.get())});
                }
            }
            if (component == null) {
                component = Component.translatable((String)((Bonus)tuple.getB()).bonusType().getDescriptionId());
            }
            return component.withStyle(infoStyle);
        }).toList();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)title);
        tooltip.add((Component)partHeader);
        tooltip.addAll(parts);
        if (!bonuses.isEmpty()) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)bonusHeader);
            tooltip.addAll(bonuses);
        }
        return tooltip;
    }
}

