/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.IAction;
import io.redspace.ironsjewelry.core.Utils;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public record KnockbackAction(QualityScalar strength) implements IAction
{
    public static final MapCodec<KnockbackAction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)QualityScalar.CODEC.fieldOf("strength").forGetter(KnockbackAction::strength)).apply((Applicative)builder, KnockbackAction::new));

    @Override
    public void apply(ServerLevel serverLevel, double quality, boolean applyToSelf, ServerPlayer wearer, Entity entity) {
        double d;
        ServerPlayer target;
        float maxStrength;
        double strength = this.strength.sample(quality);
        if (!applyToSelf && strength < 0.0 && strength < (double)(maxStrength = -wearer.distanceTo(entity) * 0.5714f)) {
            strength = maxStrength;
        }
        Vec3 direction = entity.getBoundingBox().getCenter().subtract(wearer.getBoundingBox().getCenter());
        direction = direction.normalize().scale(strength).scale(applyToSelf ? -1.0 : 1.0);
        Object object = target = applyToSelf ? wearer : entity;
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            d = Mth.clamp((double)(1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)), (double)0.5, (double)1.0);
        } else {
            d = 1.0;
        }
        double resistance = d;
        target.setDeltaMovement(target.getDeltaMovement().add(direction.add(0.0, 0.3, 0.0).scale(resistance)));
        target.hurtMarked = true;
    }

    @Override
    public Component formatTooltip(BonusInstance bonusInstance, boolean applyToSelf) {
        MutableComponent target = applyToSelf ? Component.translatable((String)"tooltip.irons_jewelry.self").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"tooltip.irons_jewelry.attacker").withStyle(ChatFormatting.RED);
        String strengthText = Utils.stringTruncation(Math.abs(this.strength().sample(bonusInstance.quality())), 1);
        boolean push = applyToSelf && this.strength.baseAmount() > 0.0 || !applyToSelf && this.strength.baseAmount() > 0.0;
        return Component.translatable((String)(push ? "action.irons_jewelry.knockback.push" : "action.irons_jewelry.knockback.pull"), (Object[])new Object[]{target, strengthText});
    }

    @Override
    public MapCodec<? extends IAction> codec() {
        return CODEC;
    }
}

