/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.core.IAction;
import io.redspace.ironsjewelry.core.Utils;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record ApplyEffectAction(QualityScalar duration, QualityScalar amplifier, Holder<MobEffect> effect) implements IAction
{
    public static final MapCodec<ApplyEffectAction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)QualityScalar.CODEC.fieldOf("duration").forGetter(ApplyEffectAction::duration), (App)QualityScalar.CODEC.fieldOf("amplifier").forGetter(ApplyEffectAction::amplifier), (App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(ApplyEffectAction::effect)).apply((Applicative)builder, ApplyEffectAction::new));

    @Override
    public void apply(ServerLevel serverLevel, double quality, boolean applyToSelf, ServerPlayer wearer, Entity entity) {
        MobEffectInstance mobEffectInstance = new MobEffectInstance(this.effect, this.ticks(quality), this.amplifier(quality));
        if (applyToSelf) {
            wearer.addEffect(mobEffectInstance);
        } else if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(mobEffectInstance);
        }
    }

    private int ticks(double quality) {
        return (int)this.duration.sample(quality);
    }

    private int amplifier(double quality) {
        return (int)this.amplifier.sample(quality);
    }

    @Override
    public Component formatTooltip(BonusInstance bonusInstance, boolean applyToSelf) {
        ChatFormatting color;
        int amp = this.amplifier(bonusInstance.quality());
        int ticks = this.ticks(bonusInstance.quality());
        MutableComponent effectComponent = Component.translatable((String)((MobEffect)this.effect.value()).getDescriptionId());
        ChatFormatting chatFormatting = color = applyToSelf ? ChatFormatting.GREEN : ChatFormatting.RED;
        if (amp > 0) {
            effectComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{effectComponent, Component.translatable((String)("potion.potency." + amp))}).withStyle(color);
        }
        MutableComponent timeComponenet = Component.empty();
        if (!((MobEffect)this.effect.value()).isInstantenous()) {
            timeComponenet = Component.literal((String)String.format(" (%s)", Utils.digitalTimeFromTicks(ticks, true))).withStyle(color);
        }
        return Component.translatable((String)(applyToSelf ? "action.irons_jewelry.apply_effect.self" : "action.irons_jewelry.apply_effect.entity"), (Object[])new Object[]{effectComponent, timeComponenet});
    }

    @Override
    public MapCodec<? extends IAction> codec() {
        return CODEC;
    }
}

