/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.redspace.ironsjewelry.core.CooldownHandler;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.PlayerData;
import io.redspace.ironsjewelry.core.data.QualityScalar;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public interface IAction {
    public static final Codec<IAction> CODEC = IronsJewelryRegistries.ACTION_REGISTRY.byNameCodec().dispatch(IAction::codec, Function.identity());

    public void apply(ServerLevel var1, double var2, boolean var4, ServerPlayer var5, Entity var6);

    default public void handleAction(ServerLevel serverLevel, BonusInstance bonusInstance, boolean applyToSelf, Optional<QualityScalar> cooldown, ServerPlayer wearer, Entity entity) {
        PlayerData playerData = PlayerData.get((Player)wearer);
        int cooldownTicks = cooldown.map(scalar -> CooldownHandler.INSTANCE.getCooldown((LivingEntity)wearer, (QualityScalar)scalar, bonusInstance.quality())).orElse(0);
        if (cooldownTicks <= 0 || !playerData.isOnCooldown(bonusInstance.bonusType())) {
            this.apply(serverLevel, bonusInstance.quality(), applyToSelf, wearer, entity);
            if (cooldownTicks > 0) {
                playerData.addCooldown(bonusInstance.bonusType(), cooldownTicks);
            }
        }
    }

    public Component formatTooltip(BonusInstance var1, boolean var2);

    public MapCodec<? extends IAction> codec();
}

