/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.core;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;

@EventBusSubscriber
public class DamageHelper {
    private static final HashMap<UUID, Integer> knockbackImmunes = new HashMap();

    public static void ignoreNextKnockback(LivingEntity livingEntity) {
        if (livingEntity.getServer() != null) {
            int tickCount = livingEntity.getServer().getTickCount();
            knockbackImmunes.entrySet().stream().filter(entry -> tickCount - (Integer)entry.getValue() >= 10).toList().forEach(entry -> knockbackImmunes.remove(entry.getKey()));
            knockbackImmunes.put(livingEntity.getUUID(), tickCount);
        }
    }

    @SubscribeEvent
    public static void cancelKnockback(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getServer() != null && knockbackImmunes.containsKey(event.getEntity().getUUID())) {
            if (entity.getServer().getTickCount() - knockbackImmunes.get(entity.getUUID()) <= 1) {
                event.setCanceled(true);
            }
            knockbackImmunes.remove(entity.getUUID());
        }
    }
}

