/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.item.PatternRecipeItem;
import io.redspace.ironsjewelry.registry.ItemRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GenerateSiteData {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.irons_spellbooks.generate_recipe_data.failed"));
    private static final String RECIPE_DATA_TEMPLATE = "- id: \"%s\"\n  name: \"%s\"\n  path: \"%s\"\n  group: \"%s\"\n  craftingType: \"%s\"\n  item0Id: \"%s\"\n  item0: \"%s\"\n  item0Path: \"%s\"\n  item1Id: \"%s\"\n  item1: \"%s\"\n  item1Path: \"%s\"\n  item2Id: \"%s\"\n  item2: \"%s\"\n  item2Path: \"%s\"\n  item3Id: \"%s\"\n  item3: \"%s\"\n  item3Path: \"%s\"\n  item4Id: \"%s\"\n  item4: \"%s\"\n  item4Path: \"%s\"\n  item5Id: \"%s\"\n  item5: \"%s\"\n  item5Path: \"%s\"\n  item6Id: \"%s\"\n  item6: \"%s\"\n  item6Path: \"%s\"\n  item7Id: \"%s\"\n  item7: \"%s\"\n  item7Path: \"%s\"\n  item8Id: \"%s\"\n  item8: \"%s\"\n  item8Path: \"%s\"\n  tooltip: \"%s\"\n  description: \"\"\n\n";
    private static final String SPELL_DATA_TEMPLATE = "- name: \"%s\"\n  school: \"%s\"\n  icon: \"%s\"\n  level: \"%d to %d\"\n  mana: \"%d to %d\"\n  cooldown: \"%ds\"\n  cast_type: \"%s\"\n  rarity: \"%s to %s\"\n  description: \"%s\"\n  u1: \"%s\"\n  u2: \"%s\"\n  u3: \"%s\"\n  u4: \"%s\"\n\n";
    static ServerLevel level;

    protected static int generateSiteData(CommandSourceStack source) {
        GenerateSiteData.generateRecipeData(source);
        return 1;
    }

    public static List<Item> getVisibleItems() {
        return BuiltInRegistries.ITEM.stream().filter(item -> CreativeModeTabs.allTabs().stream().anyMatch(tab -> tab.contains(new ItemStack((ItemLike)item)))).toList();
    }

    private static void generateRecipeData(CommandSourceStack source) {
        try {
            StringBuilder itemBuilder = new StringBuilder();
            StringBuilder armorBuilder = new StringBuilder();
            StringBuilder spellbookBuilder = new StringBuilder();
            StringBuilder curioBuilder = new StringBuilder();
            StringBuilder blockBuilder = new StringBuilder();
            level = source.getLevel();
            HashSet<Item> itemsTracked = new HashSet<Item>();
            GenerateSiteData.handleArtisanScrollEntry(itemBuilder, itemsTracked, source);
            GenerateSiteData.getVisibleItems().stream().sorted(Comparator.comparing(Item::getDescriptionId)).forEach(item -> {
                ResourceLocation itemResource = BuiltInRegistries.ITEM.getKey(item);
                String tooltip = GenerateSiteData.getTooltip(source.getPlayer(), new ItemStack((ItemLike)item));
                if (itemResource.getNamespace().equals("irons_jewelry") && !itemsTracked.contains(item)) {
                    Recipe recipe = GenerateSiteData.getRecipeFor(source, item);
                    String name = item.getName(ItemStack.EMPTY).getString();
                    if (recipe != null) {
                        GenerateSiteData.appendToBuilder(itemBuilder, recipe, GenerateSiteData.getRecipeData(recipe), GenerateSiteData.handleGenericItemGrouping(item), tooltip);
                    } else {
                        GenerateSiteData.appendToBuilder3(itemBuilder, name, itemResource, GenerateSiteData.handleGenericItemGrouping(item), tooltip);
                    }
                    itemsTracked.add((Item)item);
                }
            });
            BufferedWriter file = new BufferedWriter(new FileWriter("site_data/item_data.yml"));
            file.write(GenerateSiteData.postProcess(itemBuilder));
            file.close();
        }
        catch (Exception e) {
            IronsJewelry.LOGGER.debug(e.getMessage());
        }
    }

    private static String handleGenericItemGrouping(Item item) {
        if (item instanceof BlockItem) {
            return "Blocks";
        }
        if (new ItemStack((ItemLike)item).is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:gems")))) {
            return "Gems";
        }
        return "All";
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @NotNull
    private static ArrayList<RecipeIngredientData> getRecipeData(Recipe<?> recipe) {
        ResourceLocation resultItemResourceLocation = BuiltInRegistries.ITEM.getKey((Object)recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem());
        ArrayList<RecipeIngredientData> recipeData = new ArrayList<RecipeIngredientData>(10);
        recipeData.add(new RecipeIngredientData(resultItemResourceLocation.toString(), recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem().getName(ItemStack.EMPTY).getString(), String.format("/img/items/%s.png", resultItemResourceLocation.getPath()), recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem()));
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            if (shapedRecipe.pattern.width() < 3) {
                NonNullList ingredients = recipe.getIngredients();
                int i = 0;
                while (i < ingredients.size()) {
                    GenerateSiteData.handleIngredient((Ingredient)ingredients.get(i), recipeData, recipe);
                    if ((i + 1) % shapedRecipe.pattern.width() == 0) {
                        recipeData.add(RecipeIngredientData.EMPTY);
                    }
                    ++i;
                }
                return recipeData;
            }
        }
        recipe.getIngredients().forEach(ingredient -> GenerateSiteData.handleIngredient(ingredient, recipeData, recipe));
        return recipeData;
    }

    @Nullable
    private static Recipe getRecipeFor(CommandSourceStack sourceStack, Item item) {
        for (RecipeHolder recipe : sourceStack.getRecipeManager().getRecipes()) {
            if (!recipe.value().getResultItem((HolderLookup.Provider)level.registryAccess()).is(item)) continue;
            return recipe.value();
        }
        return null;
    }

    private static void handleArtisanScrollEntry(StringBuilder curioBuilder, Set<Item> itemsTracked, CommandSourceStack source) {
        PatternRecipeItem item = (PatternRecipeItem)((Object)ItemRegistry.RECIPE.get());
        itemsTracked.add(item);
        ResourceLocation itemResource = BuiltInRegistries.ITEM.getKey((Object)item);
        String name = item.getName(ItemStack.EMPTY).getString();
        GenerateSiteData.appendToBuilder3(curioBuilder, name, itemResource, "All", "Artisan Scrolls can be found, looted, or traded for, and can be consumed to learn a new jewelry pattern.");
    }

    private static String postProcess(StringBuilder sb) {
        return sb.toString();
    }

    private static String getTooltip(ServerPlayer player, ItemStack itemStack) {
        return Arrays.stream(itemStack.getTooltipLines(Item.TooltipContext.EMPTY, (Player)player, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().skip(1L).map(Component::getString).filter(x -> x.trim().length() > 0).collect(Collectors.joining(", ")).replace(":,", ": ").replace("  ", " ").split(",")).filter(item -> !item.contains("Slot")).collect(Collectors.joining(",")).trim().replace(":", ":<br>");
    }

    private static void appendToBuilder(StringBuilder sb, Recipe recipe, List<RecipeIngredientData> recipeIngredientData, String group, String tooltip) {
        sb.append(String.format(RECIPE_DATA_TEMPLATE, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)0).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)0).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)0).path, group, recipe.getType(), GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)1).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)1).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)1).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)2).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)2).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)2).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)3).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)3).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)3).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)4).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)4).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)4).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)5).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)5).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)5).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)6).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)6).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)6).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)7).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)7).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)7).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)8).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)8).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)8).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)9).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)9).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)9).path, tooltip));
    }

    private static void appendToBuilder2(StringBuilder sb, String name, ResourceLocation itemResource, String tooltip) {
        sb.append(String.format(RECIPE_DATA_TEMPLATE, itemResource.toString(), name, String.format("/img/items/%s.png", itemResource.getPath()), "", "none", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", tooltip));
    }

    private static void appendToBuilder3(StringBuilder sb, String name, ResourceLocation itemResource, String group, String tooltip) {
        sb.append(String.format(RECIPE_DATA_TEMPLATE, itemResource.toString(), name, String.format("/img/items/%s.png", itemResource.getPath()), group, "none", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", tooltip));
    }

    private static void handleIngredient(Ingredient ingredient, ArrayList<RecipeIngredientData> recipeData, Recipe recipe) {
        Arrays.stream(ingredient.getItems()).findFirst().ifPresentOrElse(itemStack -> {
            ResourceLocation itemResource = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
            String path = "";
            path = itemResource.toString().contains("irons_jewelry") ? String.format("/img/items/%s.png", itemResource.getPath()) : String.format("/img/items/minecraft/%s.png", itemResource.getPath());
            recipeData.add(new RecipeIngredientData(itemResource.toString(), itemStack.getItem().getName(ItemStack.EMPTY).getString(), path, recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem()));
        }, () -> recipeData.add(RecipeIngredientData.EMPTY));
    }

    private static RecipeIngredientData getRecipeDataAtIndex(List<RecipeIngredientData> recipeIngredientData, int index) {
        if (index < recipeIngredientData.size()) {
            return recipeIngredientData.get(index);
        }
        return RecipeIngredientData.EMPTY;
    }

    private static List<String> processUniqueInfo(AbstractSpell spell) {
        ArrayList<String> text = new ArrayList<String>();
        List uniqueInfoMin = spell.getUniqueInfo(spell.getMinLevel(), null);
        List uniqueInfoMax = spell.getUniqueInfo(spell.getMaxLevel(), null);
        for (int i = 0; i < uniqueInfoMax.size(); ++i) {
            String[] splitMin = ((MutableComponent)uniqueInfoMin.get(i)).getString().split(" ");
            String[] splitMax = ((MutableComponent)uniqueInfoMax.get(i)).getString().split(" ");
            int k = -1;
            for (int j = 0; j < splitMin.length; ++j) {
                if (!splitMin[j].matches("\\d\\.?\\d*(s|m|%)*")) continue;
                k = j;
                break;
            }
            if (k >= 0 && !splitMin[k].equals(splitMax[k])) {
                text.add(String.format(((MutableComponent)uniqueInfoMin.get(i)).getString().replaceFirst(splitMin[k], "%s"), String.format("%s-%s", splitMin[k], splitMax[k])));
                continue;
            }
            text.add(((MutableComponent)uniqueInfoMin.get(i)).getString());
        }
        return text;
    }

    public static String handleCapitalization(String input) {
        return Arrays.stream(input.toLowerCase().split("[ |_]")).map(word -> {
            if (word.equals("spell")) {
                return "";
            }
            String first = word.substring(0, 1);
            String rest = word.substring(1);
            return first.toUpperCase() + rest;
        }).collect(Collectors.joining(" ")).trim();
    }

    private record RecipeIngredientData(String id, String name, String path, Item item) {
        public static RecipeIngredientData EMPTY = new RecipeIngredientData("", "", "", null);
    }

    private static enum CraftingType {
        CRAFTING_TABLE,
        SMITHING_TABLE,
        NOT_CRAFTABLE;

    }
}

