/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.block.jewelcrafting_station;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.block.jewelcrafting_station.JewelcraftingStationMenu;
import io.redspace.ironsjewelry.core.MinecraftInstanceHelper;
import io.redspace.ironsjewelry.core.Utils;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.core.data.PlayerData;
import io.redspace.ironsjewelry.event.SetupJewelcraftingResultEvent;
import io.redspace.ironsjewelry.item.CurioBaseItem;
import io.redspace.ironsjewelry.network.packets.SetJewelcraftingStationPattern;
import io.redspace.ironsjewelry.network.packets.SyncJewelcraftingSlotStates;
import io.redspace.ironsjewelry.registry.AssetHandlerRegistry;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class JewelcraftingStationScreen
extends AbstractContainerScreen<JewelcraftingStationMenu>
implements ContainerListener {
    boolean tooltipDirty = true;
    public final List<Component> INFO_PAGE_CACHE = new ArrayList<Component>();
    public static final ResourceLocation BACKGROUND_TEXTURE = IronsJewelry.id("textures/gui/jewelcrafting_station.png");
    private static final ResourceLocation SCROLLER_SPRITE = IronsJewelry.id("jewelcrafting_station/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = IronsJewelry.id("jewelcrafting_station/scroller_disabled");
    private static final ResourceLocation RECIPE_SPRITE_SELECTED = IronsJewelry.id("jewelcrafting_station/recipe_selected");
    private static final ResourceLocation RECIPE_SPRITE_HOVERING = IronsJewelry.id("jewelcrafting_station/recipe_highlighted");
    private static final ResourceLocation RECIPE_SPRITE = IronsJewelry.id("jewelcrafting_station/recipe");
    private static final ResourceLocation INPUT_SLOT = IronsJewelry.id("jewelcrafting_station/input_slot");
    private static final ResourceLocation LORE_PAGE = IronsJewelry.id("jewelcrafting_station/lore_page");
    private static final int MAX_PATTERNS = 8;
    public int scrollOff;
    public int selectedPattern;
    public List<Holder<PatternDefinition>> availablePatterns;
    private List<PatternButton> patternButtons;
    private static final int SCROLL_BAR_X_OFFSET = 24;
    private static final int SCROLL_BAR_Y_OFFSET = 14;
    private static final int SCROLL_BAR_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 27;
    private static final int SCROLL_BAR_CHANNEL_LENGTH = 144;
    private boolean isDragging;

    public void handleSlotSync(SyncJewelcraftingSlotStates packet) {
        this.tooltipDirty = true;
        ((JewelcraftingStationMenu)this.menu).handleClientSideSlotSync(packet.slotStates());
    }

    public void slotChanged(AbstractContainerMenu pContainerToSend, int pDataSlotIndex, ItemStack pStack) {
        if (pDataSlotIndex <= 10) {
            this.tooltipDirty = true;
        }
    }

    public void dataChanged(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
    }

    public void removed() {
        super.removed();
        ((JewelcraftingStationMenu)this.menu).removeSlotListener(this);
    }

    private static TextureAtlasSprite getMenuSprite(Holder<PartDefinition> partDefinition, boolean bright) {
        return AssetHandlerRegistry.JEWELRY_HANDLER.get().getSprite(AssetHandlerRegistry.JEWELRY_HANDLER.get().getMenuSpriteLocation(partDefinition, bright));
    }

    public JewelcraftingStationScreen(JewelcraftingStationMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 206;
        this.inventoryLabelX += ((JewelcraftingStationMenu)this.menu).SCROLL_AREA_OFFSET;
        this.inventoryLabelY += 2;
        this.titleLabelY -= 2;
        this.selectedPattern = -1;
        this.scrollOff = 0;
        if (Minecraft.getInstance().player != null) {
            Registry<PatternDefinition> registry = IronsJewelryRegistries.patternRegistry(pPlayerInventory.player.registryAccess());
            this.availablePatterns = Stream.concat(registry.stream().filter(PatternDefinition::unlockedByDefault).map(arg_0 -> registry.wrapAsHolder(arg_0)), PlayerData.get(pPlayerInventory.player).getLearnedPatterns().stream()).distinct().sorted(Comparator.comparingDouble(patternholder -> ((PatternDefinition)patternholder.value()).qualityMultiplier())).toList();
        }
    }

    private void positionPatternButtons() {
        int x = this.leftPos + 5;
        int y = this.topPos + 14;
        for (int i = 0; i < this.patternButtons.size(); ++i) {
            this.patternButtons.get(i).setPosition(x, y + (-this.scrollOff + i) * 18);
            this.patternButtons.get((int)i).active = i - this.scrollOff >= 0 && i - this.scrollOff < 8;
        }
    }

    protected void init() {
        super.init();
        this.leftPos -= 15;
        this.patternButtons = new ArrayList<PatternButton>();
        for (int i = 0; i < this.availablePatterns.size(); ++i) {
            int index = i;
            this.patternButtons.add((PatternButton)this.addWidget((GuiEventListener)new PatternButton(this.availablePatterns.get(i), 0, 0, 18, 18, button -> {
                this.selectedPattern = index;
                PacketDistributor.sendToServer((CustomPacketPayload)new SetJewelcraftingStationPattern(((JewelcraftingStationMenu)this.menu).containerId, this.availablePatterns.get(this.selectedPattern)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            })));
        }
        this.positionPatternButtons();
        ((JewelcraftingStationMenu)this.menu).addSlotListener(this);
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(pGuiGraphics, mouseX, mouseY);
        if (((JewelcraftingStationMenu)this.menu).getCarried().isEmpty()) {
            if (this.hoveredSlot == null) {
                for (PatternButton button : this.patternButtons) {
                    if (!button.active || !this.isHovering(mouseX, mouseY, button.getX(), button.getY(), button.getWidth(), button.getHeight())) continue;
                    pGuiGraphics.renderTooltip(this.font, Utils.rasterizeComponentList(((PatternDefinition)button.patternDefinition.value()).getFullPatternTooltip()), mouseX, mouseY);
                    break;
                }
            } else if (Minecraft.getInstance().level != null && !this.hoveredSlot.hasItem() && ((JewelcraftingStationMenu)this.menu).isWorkspaceSlot(this.hoveredSlot)) {
                PatternDefinition pattern;
                int i = this.hoveredSlot.getSlotIndex();
                if (this.selectedPattern >= 0 && i < (pattern = (PatternDefinition)this.availablePatterns.get(this.selectedPattern).value()).partTemplate().size()) {
                    PartIngredient part = pattern.partTemplate().get(i);
                    ArrayList<Component> tooltip = new ArrayList<Component>();
                    tooltip.add((Component)Component.translatable((String)((PartDefinition)part.part().value()).descriptionId()).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                    tooltip.add((Component)Component.literal((String)String.format(" (0/%s)", part.materialCost())).withStyle(ChatFormatting.RED));
                    tooltip.add((Component)Component.translatable((String)"tooltip.irons_jewelry.applicable_materials").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                    IronsJewelryRegistries.materialRegistry(Minecraft.getInstance().level.registryAccess()).stream().filter(materialDefinition -> !materialDefinition.ingredient().hasNoItems() && ((PartDefinition)part.part().value()).canUseMaterial(materialDefinition.materialType())).forEach(material -> tooltip.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)material.descriptionId())).withStyle(ChatFormatting.GRAY)));
                    pGuiGraphics.renderTooltip(this.font, Utils.rasterizeComponentList(tooltip), mouseX, mouseY);
                }
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        JewelcraftingStationMenu.JewelcraftingInputSlot slot;
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderItemPreview(guiGraphics, pPartialTick, pMouseX, pMouseY);
        for (int i = 0; i < ((JewelcraftingStationMenu)this.menu).workspaceSlots.size() && (slot = ((JewelcraftingStationMenu)this.menu).workspaceSlots.get(i)).isActive(); ++i) {
            PatternDefinition pattern;
            List<PartIngredient> parts;
            guiGraphics.blitSprite(INPUT_SLOT, this.leftPos + slot.x - 3, this.topPos + slot.y - 3, 200, 22, 22);
            if (slot.hasItem() || this.selectedPattern < 0 || i >= (parts = (pattern = (PatternDefinition)this.availablePatterns.get(this.selectedPattern).value()).partTemplate()).size()) continue;
            guiGraphics.blit(this.leftPos + slot.x, this.topPos + slot.y, 200, 16, 16, JewelcraftingStationScreen.getMenuSprite(parts.get(i).part(), false));
        }
    }

    private void renderItemPreview(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        List<Object> tooltip = new ArrayList();
        if (this.selectedPattern >= 0) {
            Holder<PatternDefinition> holder = this.availablePatterns.get(this.selectedPattern);
            PatternDefinition pattern = (PatternDefinition)holder.value();
            HashMap<Holder<PartDefinition>, Holder<MaterialDefinition>> parts = new HashMap<Holder<PartDefinition>, Holder<MaterialDefinition>>();
            List<PartIngredient> requiredIngredients = pattern.partTemplate();
            for (int i = 0; i < requiredIngredients.size(); ++i) {
                PartIngredient ingredient = requiredIngredients.get(i);
                ItemStack input = ((JewelcraftingStationMenu)this.menu).workspaceSlots.get(i).getItem();
                Optional<Holder<MaterialDefinition>> material = Utils.getMaterialForIngredient(Minecraft.getInstance().player.level.registryAccess(), input);
                if (!material.isPresent() || !((PartDefinition)ingredient.part().value()).canUseMaterial(((MaterialDefinition)material.get().value()).materialType())) continue;
                parts.put(ingredient.part(), material.get());
            }
            tooltip = CurioBaseItem.getShiftDescription(pattern, parts, Optional.of(((JewelcraftingStationMenu)this.menu).workspaceSlots.stream().map(slot -> slot.getItem().getCount()).toList()));
            tooltip.add(0, Component.translatable((String)pattern.descriptionId()).withStyle(ChatFormatting.UNDERLINE));
            int baseLines = tooltip.size();
            float scale = 3.0f;
            Objects.requireNonNull(this.font);
            int additionalLines = (int)(16.0f * scale / 9.0f) + 1;
            int topBuffer = 4;
            for (int i = 0; i < additionalLines; ++i) {
                tooltip.add(Component.empty());
            }
            this.renderTooltipInternal(guiGraphics, this.font, tooltip, this.leftPos + this.imageWidth + 4, this.topPos + topBuffer);
            if (!parts.isEmpty()) {
                JewelryData jewelryData = JewelryData.renderable(holder, parts);
                ItemStack stack = new ItemStack(pattern.jewelryType().item());
                stack.set(ComponentRegistry.JEWELRY_COMPONENT, (Object)jewelryData);
                SetupJewelcraftingResultEvent event = new SetupJewelcraftingResultEvent(holder, MinecraftInstanceHelper.getPlayer(), stack);
                stack = ((SetupJewelcraftingResultEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled() ? ItemStack.EMPTY : event.getResult();
                PoseStack pose = guiGraphics.pose();
                int width = 0;
                for (Component component : tooltip) {
                    int i = this.font.width(component.getString());
                    if (i <= width) continue;
                    width = i;
                }
                pose.pushPose();
                float f = (float)(this.leftPos + this.imageWidth) + (float)width / 2.0f;
                float f2 = (float)this.topPos + 8.0f * scale;
                Objects.requireNonNull(this.font);
                pose.translate(f, f2 + (float)((baseLines + 1) * 9) + (float)topBuffer + 4.0f, 100.0f);
                pose.scale(16.0f * scale, -16.0f * scale, 16.0f * scale);
                pose.mulPose(Axis.YP.rotationDegrees(((float)Minecraft.getInstance().player.tickCount + pPartialTick) * 1.25f));
                Lighting.setupForFlatItems();
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GUI, 240, OverlayTexture.NO_OVERLAY, pose, (MultiBufferSource)guiGraphics.bufferSource(), null, 0);
                guiGraphics.flush();
                pose.popPose();
            }
        }
        if (this.tooltipDirty) {
            this.INFO_PAGE_CACHE.clear();
            this.INFO_PAGE_CACHE.addAll(tooltip);
            this.tooltipDirty = false;
        }
    }

    private void renderTooltipInternal(GuiGraphics guiGraphics, Font pFont, List<Component> components, int x, int y) {
        if (!components.isEmpty()) {
            int bgstart;
            int i = 0;
            int j = components.size() == 1 ? -2 : 0;
            List<ClientTooltipComponent> pComponents = components.stream().map(c -> ClientTooltipComponent.create((FormattedCharSequence)c.getVisualOrderText())).toList();
            for (ClientTooltipComponent clienttooltipcomponent : pComponents) {
                int k = clienttooltipcomponent.getWidth(pFont);
                if (k > i) {
                    i = k;
                }
                j += clienttooltipcomponent.getHeight();
            }
            int i2 = i;
            int j2 = j;
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            int bgend = bgstart = -1272574196;
            int borderstart = 1356909215;
            int borderend = 1352700274;
            guiGraphics.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)i2, (int)j2, (int)0, (int)bgstart, (int)bgend, (int)borderstart, (int)borderend));
            int k1 = y;
            for (int l1 = 0; l1 < pComponents.size(); ++l1) {
                ClientTooltipComponent clienttooltipcomponent1 = pComponents.get(l1);
                clienttooltipcomponent1.renderText(this.font, x, k1, poseStack.last().pose(), guiGraphics.bufferSource());
                k1 += clienttooltipcomponent1.getHeight() + (l1 == 0 ? 2 : 0);
            }
            k1 = y;
            for (int k2 = 0; k2 < pComponents.size(); ++k2) {
                ClientTooltipComponent clienttooltipcomponent2 = pComponents.get(k2);
                clienttooltipcomponent2.renderImage(this.font, x, k1, guiGraphics);
                k1 += clienttooltipcomponent2.getHeight() + (k2 == 0 ? 2 : 0);
            }
            poseStack.popPose();
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderSidebar(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private boolean isHovering(int mouseX, int mouseY, int xmin, int ymin, int width, int height) {
        return mouseX > xmin && mouseX < xmin + width && mouseY > ymin && mouseY < ymin + height;
    }

    private int getMaterialCount(int index, Holder<PartDefinition> forPart) {
        JewelcraftingStationMenu.JewelcraftingInputSlot slot;
        if (index >= 0 && index < ((JewelcraftingStationMenu)this.menu).workspaceSlots.size() && (slot = ((JewelcraftingStationMenu)this.menu).workspaceSlots.get(index)).isActive()) {
            ItemStack stack = slot.getItem();
            Optional<Holder<MaterialDefinition>> material = Utils.getMaterialForIngredient(Minecraft.getInstance().level.registryAccess(), stack);
            if (material.isPresent() && ((PartDefinition)forPart.value()).canUseMaterial(((MaterialDefinition)material.get().value()).materialType())) {
                return stack.getCount();
            }
        }
        return 0;
    }

    private void renderSidebar(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int i;
        int barX = this.leftPos + 24;
        int y = this.topPos + 14;
        for (i = this.scrollOff; i < this.patternButtons.size() && i < 8 + this.scrollOff; ++i) {
            PatternButton button = this.patternButtons.get(i);
            button.renderWidget(guiGraphics, this.isHovering(mouseX, mouseY, button.getX(), button.getY(), button.getWidth(), button.getHeight()), i == this.selectedPattern);
        }
        i = this.availablePatterns.size() + 1 - 8;
        if (i > 1) {
            int i1 = this.getCurrentScrollBarYOffset(i);
            guiGraphics.blitSprite(SCROLLER_SPRITE, barX, y + i1, 0, 6, 27);
        } else {
            guiGraphics.blitSprite(SCROLLER_DISABLED_SPRITE, barX, y, 0, 6, 27);
        }
    }

    private int getCurrentScrollBarYOffset(int patternsPastMaxPatterns) {
        int j = 144 - (27 + (patternsPastMaxPatterns - 1) * 139 / patternsPastMaxPatterns);
        int k = 1 + j / patternsPastMaxPatterns + 144 / patternsPastMaxPatterns;
        int l = 117;
        int i1 = Math.min(l, this.scrollOff * k);
        if (this.scrollOff == patternsPastMaxPatterns - 1) {
            i1 = l;
        }
        return i1;
    }

    private boolean canScroll(int count) {
        return count > 8;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        int i = this.availablePatterns.size();
        if (this.canScroll(i)) {
            int j = i - 8;
            this.scrollOff = Mth.clamp((int)((int)((double)this.scrollOff - pScrollY)), (int)0, (int)j);
            this.positionPatternButtons();
        }
        return true;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int i = this.availablePatterns.size();
        if (this.isDragging) {
            int j = this.topPos + 18;
            int k = j + 139;
            int l = i - 8;
            float f = ((float)pMouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOff = Mth.clamp((int)((int)f), (int)0, (int)l);
            this.positionPatternButtons();
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        this.isDragging = this.canScroll(this.availablePatterns.size()) && this.isHovering((int)pMouseX, (int)pMouseY, this.leftPos + 24, this.topPos + 14 + this.getCurrentScrollBarYOffset(this.availablePatterns.size() + 1 - 8), 6, 27);
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    protected void handleSlotStateChanged(int pSlotId, int pContainerId, boolean pNewState) {
        super.handleSlotStateChanged(pSlotId, pContainerId, pNewState);
    }

    static class PatternButton
    extends Button {
        Holder<PatternDefinition> patternDefinition;

        public PatternButton(Holder<PatternDefinition> patternDefinition, int pX, int pY, int pWidth, int pHeight, Button.OnPress pOnPress) {
            super(pX, pY, pWidth, pHeight, (Component)Component.empty(), pOnPress, DEFAULT_NARRATION);
            this.patternDefinition = patternDefinition;
        }

        public void renderWidget(GuiGraphics guiGraphics, boolean isHovering, boolean selected) {
            ResourceLocation sprite = isHovering ? RECIPE_SPRITE_HOVERING : (selected ? RECIPE_SPRITE_SELECTED : RECIPE_SPRITE);
            guiGraphics.blitSprite(sprite, this.getX(), this.getY(), this.width, this.height);
            List<PartIngredient> parts = ((PatternDefinition)this.patternDefinition.value()).partTemplate();
            for (PartIngredient part : parts) {
                guiGraphics.blit(this.getX() + 1, this.getY() + 1, 0, 16, 16, JewelcraftingStationScreen.getMenuSprite(part.part(), selected || isHovering));
            }
        }
    }
}

