/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.block.jewelcrafting_station;

import io.redspace.ironsjewelry.core.Utils;
import io.redspace.ironsjewelry.core.data.JewelryData;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.core.data.PlayerData;
import io.redspace.ironsjewelry.event.SetupJewelcraftingResultEvent;
import io.redspace.ironsjewelry.network.packets.SyncJewelcraftingSlotStates;
import io.redspace.ironsjewelry.registry.BlockRegistry;
import io.redspace.ironsjewelry.registry.ComponentRegistry;
import io.redspace.ironsjewelry.registry.MenuRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class JewelcraftingStationMenu
extends AbstractContainerMenu {
    private final SimpleContainer workspaceContainer = new SimpleContainer(10){

        public void setChanged() {
            super.setChanged();
            JewelcraftingStationMenu.this.setupResult();
            JewelcraftingStationMenu.this.slotsChanged((Container)this);
        }
    };
    public final List<JewelcraftingInputSlot> workspaceSlots = new ArrayList<JewelcraftingInputSlot>();
    private final SimpleContainer resultContainer = new SimpleContainer(1);
    public final Slot resultSlot;
    int SCROLL_AREA_OFFSET = 30;
    private final ContainerLevelAccess access;
    private final Player player;
    @Nullable
    private Holder<PatternDefinition> currentPattern;

    public void broadcastChanges() {
        super.broadcastChanges();
    }

    public JewelcraftingStationMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.NULL);
    }

    public JewelcraftingStationMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super((MenuType)MenuRegistry.JEWELCRAFTING_MENU.get(), pContainerId);
        this.access = pAccess;
        this.player = pPlayerInventory.player;
        for (int i = 0; i < 10; ++i) {
            this.workspaceSlots.add((JewelcraftingInputSlot)this.addSlot(new JewelcraftingInputSlot((Container)this.workspaceContainer, i, -20, -20)));
        }
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 0, 173, 33){

            public boolean mayPlace(ItemStack pStack) {
                return false;
            }

            public void onTake(Player pPlayer, ItemStack pStack) {
                super.onTake(pPlayer, pStack);
                for (JewelcraftingInputSlot slot : JewelcraftingStationMenu.this.workspaceSlots) {
                    if (!slot.isActive()) break;
                    slot.remove(slot.currentCost);
                }
                pPlayer.level.playLocalSound(pPlayer.blockPosition(), SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS, 1.0f, pPlayer.getRandom().nextFloat() * 0.1f + 0.9f, false);
                JewelcraftingStationMenu.this.setupResult();
            }
        });
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)pPlayerInventory, i1 + k * 9 + 9, this.SCROLL_AREA_OFFSET + 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)pPlayerInventory, l, this.SCROLL_AREA_OFFSET + 8 + l * 18, 142));
        }
    }

    public boolean isWorkspaceSlot(Slot slot) {
        return slot.index < 10 && slot.container.equals((Object)this.workspaceContainer);
    }

    private void setupResult() {
        ItemStack result = ItemStack.EMPTY;
        if (this.currentPattern != null) {
            SetupJewelcraftingResultEvent event;
            PatternDefinition currentPattern = (PatternDefinition)this.currentPattern.value();
            HashMap<Holder<PartDefinition>, Holder<MaterialDefinition>> parts = new HashMap<Holder<PartDefinition>, Holder<MaterialDefinition>>();
            List<PartIngredient> requiredIngredients = currentPattern.partTemplate();
            for (int i = 0; i < requiredIngredients.size(); ++i) {
                PartIngredient ingredient = requiredIngredients.get(i);
                ItemStack input = this.workspaceSlots.get(i).getItem();
                Optional<Holder<MaterialDefinition>> material = Utils.getMaterialForIngredient(this.player.registryAccess(), input);
                if (!material.isPresent() || input.getCount() < ingredient.materialCost() || !((PartDefinition)ingredient.part().value()).canUseMaterial(((MaterialDefinition)material.get().value()).materialType())) continue;
                parts.put(ingredient.part(), material.get());
                this.workspaceSlots.get((int)i).currentCost = ingredient.materialCost();
            }
            JewelryData jewelryData = new JewelryData(this.currentPattern, parts);
            if (jewelryData.isValid()) {
                result = new ItemStack(currentPattern.jewelryType().item());
                result.set(ComponentRegistry.JEWELRY_COMPONENT, (Object)jewelryData);
            }
            result = ((SetupJewelcraftingResultEvent)NeoForge.EVENT_BUS.post((Event)(event = new SetupJewelcraftingResultEvent(this.currentPattern, this.player, result)))).isCanceled() || !event.getResult().isEmpty() && !JewelryData.get(event.getResult()).isValid() ? ItemStack.EMPTY : event.getResult();
        }
        this.resultSlot.set(result);
    }

    public ItemStack quickMoveStack(Player pPlayer, int index) {
        ItemStack tryingToMoveCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            boolean flag;
            ItemStack baseItemTryingToMove = slot.getItem();
            tryingToMoveCopy = baseItemTryingToMove.copy();
            int result = 10;
            int invBegin = result + 1;
            int hotbarBegin = invBegin + 27;
            int playerEnd = hotbarBegin + 9;
            if (index > result ? !(flag = this.moveItemStackTo(baseItemTryingToMove, 0, result, false)) && (index >= hotbarBegin ? !this.moveItemStackTo(baseItemTryingToMove, invBegin, hotbarBegin, false) : !this.moveItemStackTo(baseItemTryingToMove, hotbarBegin, playerEnd, false)) : !this.moveItemStackTo(baseItemTryingToMove, invBegin, playerEnd, false)) {
                return ItemStack.EMPTY;
            }
            if (baseItemTryingToMove.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (baseItemTryingToMove.getCount() == tryingToMoveCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, baseItemTryingToMove);
            if (index == 0) {
                pPlayer.drop(baseItemTryingToMove, false);
            }
        }
        return tryingToMoveCopy;
    }

    public boolean stillValid(Player pPlayer) {
        return JewelcraftingStationMenu.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)BlockRegistry.JEWELCRAFTING_STATION_BLOCK.value()));
    }

    private boolean validateAvailablePattern(Holder<PatternDefinition> patternDefinition) {
        ServerPlayer serverPlayer;
        Player player;
        return ((PatternDefinition)patternDefinition.value()).unlockedByDefault() || (player = this.player) instanceof ServerPlayer && PlayerData.get((Player)(serverPlayer = (ServerPlayer)player)).isLearned(patternDefinition);
    }

    public boolean handleSetPattern(Holder<PatternDefinition> patternDefinition) {
        Player player;
        this.clearContainer(this.player, (Container)this.workspaceContainer);
        this.workspaceSlots.forEach(slot -> slot.setup(-20, -20, false));
        if (this.validateAvailablePattern(patternDefinition)) {
            this.currentPattern = patternDefinition;
            int ingredientCount = Math.min(10, ((PatternDefinition)this.currentPattern.value()).partTemplate().size());
            int centerX = 108;
            int centerY = 43;
            if (ingredientCount == 1) {
                this.workspaceSlots.get(0).setup(centerX - 8, centerY - 8, true);
            } else {
                int maxPerRow = ingredientCount == 10 ? 4 : 3;
                int rows = (ingredientCount - 1) / maxPerRow + 1;
                int verticalSpacing = 8;
                int horizontalSpacing = 14;
                int spriteWidth = 16;
                int totalHeight = rows * spriteWidth + (rows - 1) * verticalSpacing;
                for (int i = 0; i < rows; ++i) {
                    int boxesInThisRow = Math.min(maxPerRow, ingredientCount - i * maxPerRow);
                    int rowWidth = boxesInThisRow * spriteWidth + horizontalSpacing * (boxesInThisRow - 1);
                    for (int j = 0; j < boxesInThisRow; ++j) {
                        int x = centerX - rowWidth / 2 + (spriteWidth + horizontalSpacing) * j;
                        int y = centerY - totalHeight / 2 + (spriteWidth + verticalSpacing) * i;
                        this.workspaceSlots.get(i * maxPerRow + j).setup(x, y, true);
                    }
                }
            }
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncJewelcraftingSlotStates(this.workspaceSlots.stream().map(slot -> new SyncJewelcraftingSlotStates.SlotState(slot.x, slot.y, slot.active)).toList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return true;
    }

    public void handleClientSideSlotSync(List<SyncJewelcraftingSlotStates.SlotState> states) {
        for (int i = 0; i < states.size(); ++i) {
            if (i >= 10) continue;
            SyncJewelcraftingSlotStates.SlotState s = states.get(i);
            this.workspaceSlots.get(i).setup(s.x(), s.y(), s.enabled());
        }
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((p_39371_, p_39372_) -> this.clearContainer(pPlayer, (Container)this.workspaceContainer));
    }

    public static class JewelcraftingInputSlot
    extends Slot {
        public boolean active;
        public int currentCost;

        public JewelcraftingInputSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        void setup(int x, int y, boolean active) {
            this.x = x;
            this.y = y;
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean mayPlace(ItemStack pStack) {
            return this.isActive();
        }
    }
}

