/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.particle;

import com.corosus.watut.particle.ParticleRotating;
import com.corosus.watut.spritesets.SpriteSetPlayer;
import net.minecraft.client.multiplayer.ClientLevel;

public class ParticleStaticLoD
extends ParticleRotating {
    private final SpriteSetPlayer sprites;

    public ParticleStaticLoD(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSetPlayer pSprites) {
        this(pLevel, pX, pY, pZ, pSprites, 1.0f);
    }

    public ParticleStaticLoD(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSetPlayer pSprites, float brightness) {
        super(pLevel, pX, pY, pZ);
        this.sprites = pSprites;
        this.lifetime = Integer.MAX_VALUE;
        this.gravity = 0.0f;
        this.setSize(0.2f, 0.2f);
        this.quadSize = 0.5f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.setParticleFromDistanceToCamera(0.0f);
        this.setColor(this.getColorRed() * brightness, this.getColorGreen() * brightness, this.getColorBlue() * brightness);
    }

    public void setSize(float pWidth, float pHeight) {
        super.setSize(pWidth, pHeight);
    }

    @Override
    public void tick() {
        super.tick();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    public void setParticleFromDistanceToCamera(float distanceToCamera) {
        float step = 3.0f;
        int i = (int)Math.max(0.0f, Math.min((float)(this.sprites.getFrames() - 1), (distanceToCamera - step) / step + 1.0f));
        this.setSprite(this.sprites.getList().get(i));
    }
}

