/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.particle;

import com.corosus.watut.particle.ParticleRotating;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ParticleDynamic
extends ParticleRotating {
    public ParticleRenderType particleRenderType;

    @Override
    public ParticleRenderType getRenderType() {
        return this.particleRenderType;
    }

    public ParticleDynamic(ClientLevel pLevel, double pX, double pY, double pZ, ParticleRenderType particleRenderType) {
        this(pLevel, pX, pY, pZ, particleRenderType, 1.0f);
    }

    public ParticleDynamic(ClientLevel pLevel, double pX, double pY, double pZ, ParticleRenderType particleRenderType, float brightness) {
        super(pLevel, pX, pY, pZ);
        this.particleRenderType = particleRenderType;
        this.lifetime = Integer.MAX_VALUE;
        this.gravity = 0.0f;
        this.setSize(0.2f, 0.2f);
        this.quadSize = 0.5f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.setColor(this.getColorRed() * brightness, this.getColorGreen() * brightness, this.getColorBlue() * brightness);
    }

    public void setSize(float pWidth, float pHeight) {
        super.setSize(pWidth, pHeight);
    }

    @Override
    public void tick() {
        super.tick();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    @Override
    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        Quaternionf quaternion;
        Vec3 vec3 = pRenderInfo.getPosition();
        float f = (float)(Mth.lerp((double)pPartialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float f1 = (float)(Mth.lerp((double)pPartialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float f2 = (float)(Mth.lerp((double)pPartialTicks, (double)this.zo, (double)this.z) - vec3.z());
        if (this.useCustomRotation) {
            quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
            quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)this.prevRotationYaw, (float)this.rotationYaw)));
            quaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)this.prevRotationPitch, (float)this.rotationPitch)));
            quaternion.mul((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)this.prevRotationRoll, (float)this.rotationRoll)));
        } else if (this.roll == 0.0f) {
            quaternion = pRenderInfo.rotation();
        } else {
            quaternion = new Quaternionf((Quaternionfc)pRenderInfo.rotation());
            quaternion.rotateZ(Mth.lerp((float)pPartialTicks, (float)this.oRoll, (float)this.roll));
        }
        float aspectRatio = 1.7777778f;
        float height = 1.0f / aspectRatio;
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, height, 0.0f), new Vector3f(-1.0f, -height, 0.0f), new Vector3f(1.0f, -height, 0.0f), new Vector3f(1.0f, height, 0.0f)};
        float f3 = this.getQuadSize(pPartialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f3 * 7.0f);
            vector3f.add(f, f1, f2);
        }
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        int j = this.getLightColor(pPartialTicks);
        pBuffer.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        pBuffer.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        pBuffer.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        pBuffer.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
    }
}

