/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.network;

import com.corosus.coroutil.config.ConfigCoroUtil;
import com.corosus.coroutil.util.CULog;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.network.PacketBase;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PacketNBTFromServer(CompoundTag nbt) implements PacketBase
{
    public static final CustomPacketPayload.Type<PacketNBTFromServer> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"watut", (String)"nbt_client"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketNBTFromServer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, PacketNBTFromServer::nbt, PacketNBTFromServer::new);

    public PacketNBTFromServer(FriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.nbt);
    }

    public void handle(Player player) {
        block2: {
            try {
                UUID uuid = UUID.fromString(this.nbt.getString(WatutNetworking.NBTDataPlayerUUID));
                WatutMod.getPlayerStatusManagerClient().receiveAny(uuid, this.nbt);
            }
            catch (Exception ex) {
                CULog.dbg((String)"WATUT ERROR: packet with invalid uuid sent from server");
                CULog.dbg((String)("full nbt data: " + String.valueOf(this.nbt)));
                if (!ConfigCoroUtil.useLoggingDebug) break block2;
                ex.printStackTrace();
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

