/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.config.ConfigCommon;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerStatusManagerServer
extends PlayerStatusManager {
    @Override
    public void tickPlayer(Player player) {
        this.getStatus(player).setTicksToMarkPlayerIdleSyncedForClient(ConfigCommon.ticksToMarkPlayerIdle);
        super.tickPlayer(player);
    }

    public void receiveAny(Player player, CompoundTag data) {
        data.putString(WatutNetworking.NBTDataPlayerUUID, player.getUUID().toString());
        if (data.contains(WatutNetworking.NBTDataPlayerGuiStatus)) {
            PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.getInt(WatutNetworking.NBTDataPlayerGuiStatus));
            this.getStatus(player).setPlayerGuiState(playerGuiState);
        }
        if (data.contains(WatutNetworking.NBTDataPlayerChatStatus)) {
            PlayerStatus.PlayerChatState state = PlayerStatus.PlayerChatState.get(data.getInt(WatutNetworking.NBTDataPlayerChatStatus));
            this.getStatus(player).setPlayerChatState(state);
        }
        if (data.contains(WatutNetworking.NBTDataPlayerIdleTicks)) {
            this.handleIdleState(player, data.getInt(WatutNetworking.NBTDataPlayerIdleTicks));
            data.putInt(WatutNetworking.NBTDataPlayerTicksToGoIdle, ConfigCommon.ticksToMarkPlayerIdle);
        }
        if (data.contains(WatutNetworking.NBTDataPlayerMouseX)) {
            float x = data.getFloat(WatutNetworking.NBTDataPlayerMouseX);
            float y = data.getFloat(WatutNetworking.NBTDataPlayerMouseY);
            boolean pressed = data.getBoolean(WatutNetworking.NBTDataPlayerMousePressed);
            this.setMouse(player.getUUID(), x, y, pressed);
        }
        if (data.contains(WatutNetworking.NBTDataPlayerScreenRenderCalls)) {
            // empty if block
        }
        this.getStatus(player).getNbtCache().merge(data);
        if (data.contains(WatutNetworking.NBTDataPlayerGuiStatus) || data.contains(WatutNetworking.NBTDataPlayerIdleTicks) || data.contains(WatutNetworking.NBTDataPlayerScreenRenderCalls)) {
            WatutNetworking.instance().serverSendToClientAll(data);
        } else {
            WatutNetworking.instance().serverSendToClientNear(data, player.position(), this.nearbyPlayerDataSendDist, player.level());
        }
    }

    public void handleIdleState(Player player, int idleTicks) {
        PlayerStatus status = this.getStatus(player);
        if (WatutMod.instance().getPlayerList().getPlayerCount() > 1 || this.singleplayerTesting) {
            if (idleTicks > ConfigCommon.ticksToMarkPlayerIdle) {
                if (!status.isIdle()) {
                    this.broadcast(player.getDisplayName().getString() + " has gone idle");
                }
            } else if (status.isIdle()) {
                this.broadcast(player.getDisplayName().getString() + " is no longer idle");
            }
        }
        status.setTicksSinceLastAction(idleTicks);
    }

    public void broadcast(String msg) {
        if (ConfigCommon.announceIdleStatesInChat) {
            WatutMod.instance().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)msg), false);
        }
    }

    @Override
    public void playerLoggedIn(Player player) {
        super.playerLoggedIn(player);
        WatutMod.dbg("player logged in");
        if (player instanceof ServerPlayer) {
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("sending update all packet for " + ((UUID)entry.getKey()).toString() + " to " + player.getDisplayName().getString() + " with status " + String.valueOf((Object)PlayerStatus.PlayerGuiState.get(((PlayerStatus)entry.getValue()).getNbtCache().getInt(WatutNetworking.NBTDataPlayerGuiStatus))));
                WatutNetworking.instance().serverSendToClientPlayer(((PlayerStatus)entry.getValue()).getNbtCache(), player);
            }
        }
    }
}

