/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.util.concurrent.atomic.LongAccumulator;

final class MaxScoreAccumulator {
    static final int DEFAULT_INTERVAL = 1023;
    final LongAccumulator acc = new LongAccumulator(MaxScoreAccumulator::maxEncode, Long.MIN_VALUE);
    long modInterval = 1023L;

    MaxScoreAccumulator() {
    }

    private static long maxEncode(long v1, long v2) {
        float score2;
        float score1 = Float.intBitsToFloat((int)(v1 >> 32));
        int cmp = Float.compare(score1, score2 = Float.intBitsToFloat((int)(v2 >> 32)));
        if (cmp == 0) {
            return (int)v1 < (int)v2 ? v1 : v2;
        }
        if (cmp > 0) {
            return v1;
        }
        return v2;
    }

    void accumulate(int docId, float score) {
        assert (docId >= 0 && score >= 0.0f);
        long encode = (long)Float.floatToIntBits(score) << 32 | (long)docId;
        this.acc.accumulate(encode);
    }

    public static float toScore(long value) {
        return Float.intBitsToFloat((int)(value >> 32));
    }

    public static int docId(long value) {
        return (int)value;
    }

    long getRaw() {
        return this.acc.get();
    }
}

