/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.document;

import java.io.IOException;
import java.util.Objects;
import java.util.function.LongPredicate;
import org.apache.lucene.ars_nouveau.index.DocValues;
import org.apache.lucene.ars_nouveau.index.DocValuesSkipper;
import org.apache.lucene.ars_nouveau.index.LeafReader;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.NumericDocValues;
import org.apache.lucene.ars_nouveau.index.SortedNumericDocValues;
import org.apache.lucene.ars_nouveau.search.ConstantScoreScorer;
import org.apache.lucene.ars_nouveau.search.ConstantScoreWeight;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.DocValuesRangeIterator;
import org.apache.lucene.ars_nouveau.search.FieldExistsQuery;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.MatchNoDocsQuery;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.ScorerSupplier;
import org.apache.lucene.ars_nouveau.search.Sort;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;
import org.apache.lucene.ars_nouveau.search.Weight;

final class SortedNumericDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;

    SortedNumericDocValuesRangeQuery(String field, long lowerValue, long upperValue) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SortedNumericDocValuesRangeQuery that = (SortedNumericDocValuesRangeQuery)obj;
        return Objects.equals(this.field, that.field) && this.lowerValue == that.lowerValue && this.upperValue == that.upperValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.lowerValue, this.upperValue);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new FieldExistsQuery(this.field);
        }
        if (this.lowerValue > this.upperValue) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedNumericDocValuesRangeQuery.this.field);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                TwoPhaseIterator iterator;
                SortedNumericDocValues values;
                NumericDocValues singleton;
                if (context.reader().getFieldInfos().fieldInfo(SortedNumericDocValuesRangeQuery.this.field) == null) {
                    return null;
                }
                DocValuesSkipper skipper = context.reader().getDocValuesSkipper(SortedNumericDocValuesRangeQuery.this.field);
                if (skipper != null) {
                    if (skipper.minValue() > SortedNumericDocValuesRangeQuery.this.upperValue || skipper.maxValue() < SortedNumericDocValuesRangeQuery.this.lowerValue) {
                        return null;
                    }
                    if (skipper.docCount() == context.reader().maxDoc() && skipper.minValue() >= SortedNumericDocValuesRangeQuery.this.lowerValue && skipper.maxValue() <= SortedNumericDocValuesRangeQuery.this.upperValue) {
                        ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, DocIdSetIterator.all(skipper.docCount()));
                        return new Weight.DefaultScorerSupplier(scorer);
                    }
                }
                if ((singleton = DocValues.unwrapSingleton(values = DocValues.getSortedNumeric(context.reader(), SortedNumericDocValuesRangeQuery.this.field))) != null) {
                    DocIdSetIterator psIterator;
                    if (skipper != null && (psIterator = SortedNumericDocValuesRangeQuery.this.getDocIdSetIteratorOrNullForPrimarySort(context.reader(), singleton, skipper)) != null) {
                        return new Weight.DefaultScorerSupplier(new ConstantScoreScorer(this.score(), scoreMode, psIterator));
                    }
                    iterator = new TwoPhaseIterator(singleton){

                        @Override
                        public boolean matches() throws IOException {
                            long value = singleton.longValue();
                            return value >= SortedNumericDocValuesRangeQuery.this.lowerValue && value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                        }

                        @Override
                        public float matchCost() {
                            return 2.0f;
                        }
                    };
                } else {
                    iterator = new TwoPhaseIterator(values){

                        @Override
                        public boolean matches() throws IOException {
                            int count = values.docValueCount();
                            for (int i = 0; i < count; ++i) {
                                long value = values.nextValue();
                                if (value < SortedNumericDocValuesRangeQuery.this.lowerValue) continue;
                                return value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                            }
                            return false;
                        }

                        @Override
                        public float matchCost() {
                            return 2.0f;
                        }
                    };
                }
                if (skipper != null) {
                    iterator = new DocValuesRangeIterator(iterator, skipper, SortedNumericDocValuesRangeQuery.this.lowerValue, SortedNumericDocValuesRangeQuery.this.upperValue, false);
                }
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, iterator);
                return new Weight.DefaultScorerSupplier(scorer);
            }
        };
    }

    private DocIdSetIterator getDocIdSetIteratorOrNullForPrimarySort(LeafReader reader, NumericDocValues numericDocValues, DocValuesSkipper skipper) throws IOException {
        int maxDocID;
        int minDocID;
        if (skipper.docCount() != reader.maxDoc()) {
            return null;
        }
        Sort indexSort = reader.getMetaData().sort();
        if (indexSort == null || indexSort.getSort().length == 0 || !indexSort.getSort()[0].getField().equals(this.field)) {
            return null;
        }
        if (indexSort.getSort()[0].getReverse()) {
            if (skipper.maxValue() <= this.upperValue) {
                minDocID = 0;
            } else {
                skipper.advance(Long.MIN_VALUE, this.upperValue);
                minDocID = SortedNumericDocValuesRangeQuery.nextDoc(skipper.minDocID(0), numericDocValues, l -> l <= this.upperValue);
            }
            if (skipper.minValue() >= this.lowerValue) {
                maxDocID = skipper.docCount();
            } else {
                skipper.advance(Long.MIN_VALUE, this.lowerValue);
                maxDocID = SortedNumericDocValuesRangeQuery.nextDoc(skipper.minDocID(0), numericDocValues, l -> l < this.lowerValue);
            }
        } else {
            if (skipper.minValue() >= this.lowerValue) {
                minDocID = 0;
            } else {
                skipper.advance(this.lowerValue, Long.MAX_VALUE);
                minDocID = SortedNumericDocValuesRangeQuery.nextDoc(skipper.minDocID(0), numericDocValues, l -> l >= this.lowerValue);
            }
            if (skipper.maxValue() <= this.upperValue) {
                maxDocID = skipper.docCount();
            } else {
                skipper.advance(this.upperValue, Long.MAX_VALUE);
                maxDocID = SortedNumericDocValuesRangeQuery.nextDoc(skipper.minDocID(0), numericDocValues, l -> l > this.upperValue);
            }
        }
        return minDocID == maxDocID ? DocIdSetIterator.empty() : DocIdSetIterator.range(minDocID, maxDocID);
    }

    private static int nextDoc(int startDoc, NumericDocValues docValues, LongPredicate predicate) throws IOException {
        int doc = docValues.docID();
        if (startDoc > doc) {
            doc = docValues.advance(startDoc);
        }
        while (doc < Integer.MAX_VALUE && !predicate.test(docValues.longValue())) {
            doc = docValues.nextDoc();
        }
        return doc;
    }
}

