/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.pt;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.pt.PortugueseStemmer;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.KeywordAttribute;

public final class PortugueseStemFilter
extends TokenFilter {
    private final PortugueseStemmer stemmer = new PortugueseStemmer();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public PortugueseStemFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int len = this.termAtt.length();
                int newlen = this.stemmer.stem(this.termAtt.resizeBuffer(len + 1), len);
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

