/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.hollingsworth.arsnouveau.common.items.AlakarkinosCharm;
import com.hollingsworth.arsnouveau.common.items.AlchemistsCrown;
import com.hollingsworth.arsnouveau.common.items.AnnotatedCodex;
import com.hollingsworth.arsnouveau.common.items.BlankParchmentItem;
import com.hollingsworth.arsnouveau.common.items.CasterTome;
import com.hollingsworth.arsnouveau.common.items.Debug;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.DowsingRod;
import com.hollingsworth.arsnouveau.common.items.EarthEssence;
import com.hollingsworth.arsnouveau.common.items.EnchantersMirror;
import com.hollingsworth.arsnouveau.common.items.EnchantersShield;
import com.hollingsworth.arsnouveau.common.items.EnchantersSword;
import com.hollingsworth.arsnouveau.common.items.ExperienceGem;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.FireEssence;
import com.hollingsworth.arsnouveau.common.items.FlaskCannon;
import com.hollingsworth.arsnouveau.common.items.FormSpellArrow;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.JarOfLight;
import com.hollingsworth.arsnouveau.common.items.ManipulationEssence;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import com.hollingsworth.arsnouveau.common.items.Present;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.items.RunicChalk;
import com.hollingsworth.arsnouveau.common.items.ScryCaster;
import com.hollingsworth.arsnouveau.common.items.ScryerScroll;
import com.hollingsworth.arsnouveau.common.items.SpellArrow;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellBow;
import com.hollingsworth.arsnouveau.common.items.SpellCrossbow;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.items.StableWarpScroll;
import com.hollingsworth.arsnouveau.common.items.StarbuncleShades;
import com.hollingsworth.arsnouveau.common.items.StarbuncleShard;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.items.Wand;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.items.WixieHat;
import com.hollingsworth.arsnouveau.common.items.WornNotebook;
import com.hollingsworth.arsnouveau.common.items.curios.AbstractManaCurio;
import com.hollingsworth.arsnouveau.common.items.curios.BeltOfLevitation;
import com.hollingsworth.arsnouveau.common.items.curios.BeltOfUnstableGifts;
import com.hollingsworth.arsnouveau.common.items.curios.DiscountRing;
import com.hollingsworth.arsnouveau.common.items.curios.JumpingRing;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.items.curios.SummoningFocus;
import com.hollingsworth.arsnouveau.common.items.data.PresentData;
import com.hollingsworth.arsnouveau.common.items.data.ScryCasterData;
import com.hollingsworth.arsnouveau.common.items.data.ScryPosData;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.AllowItemScroll;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.DenyItemScroll;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.MimicItemScroll;
import com.hollingsworth.arsnouveau.common.items.summon_charms.AmethystGolemCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.BookwyrmCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.DrygmyCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.StarbuncleCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.WhirlisprigCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.WixieCharm;
import com.hollingsworth.arsnouveau.common.perk.EmptyPerk;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.JukeboxRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

public class ItemsRegistry {
    public static Style LORE_STYLE = Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true));
    public static PerkItem BLANK_THREAD;
    public static FoodProperties SOURCE_BERRY_FOOD;
    public static FoodProperties SOURCE_PIE_FOOD;
    public static FoodProperties SOURCE_ROLL_FOOD;
    public static FoodProperties MENDOSTEEN_FOOD;
    public static FoodProperties BLASTING_FOOD;
    public static FoodProperties BASTION_FOOD;
    public static FoodProperties FROSTAYA_FOOD;
    public static final DeferredRegister<Item> ITEMS;
    public static final ItemRegistryWrapper<RunicChalk> RUNIC_CHALK;
    public static final ItemRegistryWrapper<SpellBook> NOVICE_SPELLBOOK;
    public static final ItemRegistryWrapper<SpellBook> APPRENTICE_SPELLBOOK;
    public static final ItemRegistryWrapper<SpellBook> ARCHMAGE_SPELLBOOK;
    public static final ItemRegistryWrapper<SpellBook> CREATIVE_SPELLBOOK;
    public static final ItemRegistryWrapper<ModItem> BLANK_GLYPH;
    public static final ItemRegistryWrapper<ModItem> MAGE_BLOOM;
    public static final ItemRegistryWrapper<ModItem> MAGE_FIBER;
    public static final ItemRegistryWrapper<ModItem> MUNDANE_BELT;
    public static final ItemRegistryWrapper<JarOfLight> JAR_OF_LIGHT;
    public static final ItemRegistryWrapper<BeltOfLevitation> BELT_OF_LEVITATION;
    public static final ItemRegistryWrapper<WornNotebook> WORN_NOTEBOOK;
    public static final ItemRegistryWrapper<ModItem> RING_OF_POTENTIAL;
    public static final ItemRegistryWrapper<DiscountRing> RING_OF_LESSER_DISCOUNT;
    public static final ItemRegistryWrapper<DiscountRing> RING_OF_GREATER_DISCOUNT;
    public static final ItemRegistryWrapper<BeltOfUnstableGifts> BELT_OF_UNSTABLE_GIFTS;
    public static final ItemRegistryWrapper<WarpScroll> WARP_SCROLL;
    public static final ItemRegistryWrapper<SpellParchment> SPELL_PARCHMENT;
    public static final ItemRegistryWrapper<BookwyrmCharm> BOOKWYRM_CHARM;
    public static final ItemRegistryWrapper<DominionWand> DOMINION_ROD;
    public static final ItemRegistryWrapper<AbstractManaCurio> AMULET_OF_MANA_BOOST;
    public static final ItemRegistryWrapper<AbstractManaCurio> AMULET_OF_MANA_REGEN;
    public static final ItemRegistryWrapper<ModItem> DULL_TRINKET;
    public static final ItemRegistryWrapper<StarbuncleCharm> STARBUNCLE_CHARM;
    public static final ItemRegistryWrapper<Debug> debug;
    public static final ItemRegistryWrapper<StarbuncleShard> STARBUNCLE_SHARD;
    public static final ItemRegistryWrapper<StarbuncleShades> STARBUNCLE_SHADES;
    public static final ItemRegistryWrapper<WhirlisprigCharm> WHIRLISPRIG_CHARM;
    public static final ItemRegistryWrapper<ModItem> WHIRLISPRIG_SHARDS;
    public static final ItemRegistryWrapper<ModItem> SOURCE_GEM;
    public static final ItemRegistryWrapper<AllowItemScroll> ALLOW_ITEM_SCROLL;
    public static final ItemRegistryWrapper<DenyItemScroll> DENY_ITEM_SCROLL;
    public static final ItemRegistryWrapper<MimicItemScroll> MIMIC_ITEM_SCROLL;
    public static final ItemRegistryWrapper<BlankParchmentItem> BLANK_PARCHMENT;
    public static final ItemRegistryWrapper<Wand> WAND;
    public static final ItemRegistryWrapper<VoidJar> VOID_JAR;
    public static final ItemRegistryWrapper<WixieCharm> WIXIE_CHARM;
    public static final ItemRegistryWrapper<ModItem> WIXIE_SHARD;
    public static final ItemRegistryWrapper<SpellBow> SPELL_BOW;
    public static final ItemRegistryWrapper<SpellArrow> AMPLIFY_ARROW;
    public static final ItemRegistryWrapper<FormSpellArrow> SPLIT_ARROW;
    public static final ItemRegistryWrapper<FormSpellArrow> PIERCE_ARROW;
    public static final ItemRegistryWrapper<ModItem> WILDEN_HORN;
    public static final ItemRegistryWrapper<ModItem> WILDEN_SPIKE;
    public static final ItemRegistryWrapper<ModItem> WILDEN_WING;
    public static final ItemRegistryWrapper<PotionFlask> POTION_FLASK;
    public static ItemRegistryWrapper<PotionFlask> POTION_FLASK_AMPLIFY;
    public static ItemRegistryWrapper<PotionFlask> POTION_FLASK_EXTEND_TIME;
    public static ItemRegistryWrapper<ExperienceGem> EXPERIENCE_GEM;
    public static ItemRegistryWrapper<ExperienceGem> GREATER_EXPERIENCE_GEM;
    public static final ItemRegistryWrapper<EnchantersSword> ENCHANTERS_SWORD;
    public static final ItemRegistryWrapper<EnchantersShield> ENCHANTERS_SHIELD;
    public static final ItemRegistryWrapper<CasterTome> CASTER_TOME;
    public static final ItemRegistryWrapper<DrygmyCharm> DRYGMY_CHARM;
    public static final ItemRegistryWrapper<ModItem> DRYGMY_SHARD;
    public static final ItemRegistryWrapper<ModItem> WILDEN_TRIBUTE;
    public static final ItemRegistryWrapper<SummoningFocus> SUMMONING_FOCUS;
    public static final ItemRegistryWrapper<ShapersFocus> SHAPERS_FOCUS;
    public static final ItemRegistryWrapper<ModItem> SOURCE_BERRY_PIE;
    public static final ItemRegistryWrapper<ModItem> SOURCE_BERRY_ROLL;
    public static final ItemRegistryWrapper<EnchantersMirror> ENCHANTERS_MIRROR;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> SORCERER_BOOTS;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> SORCERER_LEGGINGS;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> SORCERER_ROBES;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> SORCERER_HOOD;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> ARCANIST_BOOTS;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> ARCANIST_LEGGINGS;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> ARCANIST_ROBES;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> ARCANIST_HOOD;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> BATTLEMAGE_BOOTS;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> BATTLEMAGE_LEGGINGS;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> BATTLEMAGE_ROBES;
    public static final ItemRegistryWrapper<AnimatedMagicArmor> BATTLEMAGE_HOOD;
    public static final ItemRegistryWrapper<DowsingRod> DOWSING_ROD;
    public static final ItemRegistryWrapper<ModItem> ABJURATION_ESSENCE;
    public static final ItemRegistryWrapper<ModItem> CONJURATION_ESSENCE;
    public static final ItemRegistryWrapper<ModItem> AIR_ESSENCE;
    public static final ItemRegistryWrapper<EarthEssence> EARTH_ESSENCE;
    public static final ItemRegistryWrapper<FireEssence> FIRE_ESSENCE;
    public static final ItemRegistryWrapper<ManipulationEssence> MANIPULATION_ESSENCE;
    public static final ItemRegistryWrapper<ModItem> WATER_ESSENCE;
    public static final ItemRegistryWrapper<AmethystGolemCharm> AMETHYST_GOLEM_CHARM;
    public static final ItemRegistryWrapper<AnnotatedCodex> ANNOTATED_CODEX;
    public static final ItemRegistryWrapper<ScryerScroll> SCRYER_SCROLL;
    public static final ItemRegistryWrapper<ModItem> WIXIE_HAT;
    public static final ItemRegistryWrapper<ModItem> ALCHEMISTS_CROWN;
    public static final ItemRegistryWrapper<ModItem> SPLASH_LAUNCHER;
    public static final ItemRegistryWrapper<ModItem> LINGERING_LAUNCHER;
    public static final ItemRegistryWrapper<Item> FIREL_DISC;
    public static final ItemRegistryWrapper<Item> SOUND_OF_GLASS;
    public static final ItemRegistryWrapper<Item> WILD_HUNT;
    public static final ItemRegistryWrapper<Present> STARBY_GIFY;
    public static final ItemRegistryWrapper<SpellCrossbow> SPELL_CROSSBOW;
    public static final ItemRegistryWrapper<StableWarpScroll> STABLE_WARP_SCROLL;
    public static final ItemRegistryWrapper<ScryCaster> SCRY_CASTER;
    public static final ItemRegistryWrapper<JumpingRing> JUMP_RING;
    public static final ItemRegistryWrapper<AlakarkinosCharm> ALAKARKINOS_CHARM;
    public static final ItemRegistryWrapper<Item> ALAKARKINOS_SHARD;
    public static final DeferredHolder<Item, BannerPatternItem> ARS_STENCIL;

    public static <T extends Item> ItemRegistryWrapper<T> register(String name, Supplier<T> item) {
        return new ItemRegistryWrapper(ITEMS.register(name, item));
    }

    public static ItemRegistryWrapper<ModItem> register(String name) {
        return ItemsRegistry.register(name, ModItem::new);
    }

    public static void onItemRegistry(RegisterEvent.RegisterHelper<Item> helper) {
        ArsNouveauAPI api = ArsNouveauAPI.getInstance();
        for (Map.Entry<ResourceLocation, Supplier<Glyph>> glyphEntry : GlyphRegistry.getGlyphItemMap().entrySet()) {
            Glyph glyph = glyphEntry.getValue().get();
            helper.register(glyphEntry.getKey(), (Object)glyph);
            glyph.spellPart.glyphItem = glyph;
        }
        for (AbstractRitual ritual : RitualRegistry.getRitualMap().values()) {
            RitualTablet tablet = new RitualTablet(ritual);
            helper.register(ritual.getRegistryName(), (Object)tablet);
            RitualRegistry.getRitualItemMap().put(ritual.getRegistryName(), tablet);
        }
        for (AbstractFamiliarHolder holder : FamiliarRegistry.getFamiliarHolderMap().values()) {
            FamiliarScript script = new FamiliarScript(holder);
            FamiliarRegistry.getFamiliarScriptMap().put(holder.getRegistryName(), script);
            helper.register(holder.getRegistryName(), (Object)script);
        }
        for (IPerk perk : PerkRegistry.getPerkMap().values()) {
            PerkItem perkItem = new PerkItem(perk);
            PerkRegistry.getPerkItemMap().put(perk.getRegistryName(), perkItem);
            helper.register(perk.getRegistryName(), (Object)perkItem);
            if (!(perk instanceof EmptyPerk)) continue;
            BLANK_THREAD = perkItem;
        }
        ITEMS.register("drygmy_se", () -> new DeferredSpawnEggItem(ModEntities.ENTITY_DRYGMY, 10051392, 16770611, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("starbuncle_se", () -> new DeferredSpawnEggItem(ModEntities.STARBUNCLE_TYPE, 16757299, 16770611, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("whirlisprig_se", () -> new DeferredSpawnEggItem(ModEntities.WHIRLISPRIG_TYPE, 0x77FF33, 0xFFFB00, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("wilden_hunter_se", () -> new DeferredSpawnEggItem(ModEntities.WILDEN_HUNTER, 0xFDFDFD, 13281663, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("wilden_guardian_se", () -> new DeferredSpawnEggItem(ModEntities.WILDEN_GUARDIAN, 0xFFFFFF, 16752128, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("wilden_stalker_se", () -> new DeferredSpawnEggItem(ModEntities.WILDEN_STALKER, 10183948, 15669272, ItemsRegistry.defaultItemProperties()));
        ITEMS.register("alakarkinos_se", () -> new DeferredSpawnEggItem(ModEntities.ALAKARKINOS_TYPE, 0xFF3232, 0x3232FF, ItemsRegistry.defaultItemProperties()));
    }

    private static DeferredHolder<Item, BannerPatternItem> createPatternItem(String name, Rarity rarity) {
        TagKey bannerTag = TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)ArsNouveau.prefix("pattern_item/" + name));
        return ITEMS.register(name, () -> new BannerPatternItem(bannerTag, new Item.Properties().stacksTo(1).rarity(rarity)));
    }

    public static Item.Properties defaultItemProperties() {
        return new Item.Properties();
    }

    static {
        SOURCE_BERRY_FOOD = new FoodProperties.Builder().nutrition(2).saturationModifier(0.1f).effect(() -> new MobEffectInstance(ModPotions.MANA_REGEN_EFFECT, 100), 1.0f).alwaysEdible().build();
        SOURCE_PIE_FOOD = new FoodProperties.Builder().nutrition(9).saturationModifier(0.9f).effect(() -> new MobEffectInstance(ModPotions.MANA_REGEN_EFFECT, 1200, 1), 1.0f).alwaysEdible().build();
        SOURCE_ROLL_FOOD = new FoodProperties.Builder().nutrition(8).saturationModifier(0.6f).effect(() -> new MobEffectInstance(ModPotions.MANA_REGEN_EFFECT, 1200), 1.0f).alwaysEdible().build();
        MENDOSTEEN_FOOD = new FoodProperties.Builder().nutrition(4).saturationModifier(0.6f).effect(() -> new MobEffectInstance(ModPotions.RECOVERY_EFFECT, 1200), 1.0f).alwaysEdible().build();
        BLASTING_FOOD = new FoodProperties.Builder().nutrition(4).saturationModifier(0.6f).effect(() -> new MobEffectInstance(ModPotions.BLAST_EFFECT, 200), 1.0f).alwaysEdible().build();
        BASTION_FOOD = new FoodProperties.Builder().nutrition(4).saturationModifier(0.6f).effect(() -> new MobEffectInstance(ModPotions.DEFENCE_EFFECT, 1200), 1.0f).alwaysEdible().build();
        FROSTAYA_FOOD = new FoodProperties.Builder().nutrition(4).saturationModifier(0.6f).effect(() -> new MobEffectInstance(ModPotions.FREEZING_EFFECT, 600), 1.0f).alwaysEdible().build();
        ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"ars_nouveau");
        RUNIC_CHALK = ItemsRegistry.register("runic_chalk", RunicChalk::new);
        NOVICE_SPELLBOOK = ItemsRegistry.register("novice_spell_book", () -> new SpellBook(SpellTier.ONE));
        APPRENTICE_SPELLBOOK = ItemsRegistry.register("apprentice_spell_book", () -> new SpellBook(SpellTier.TWO));
        ARCHMAGE_SPELLBOOK = ItemsRegistry.register("archmage_spell_book", () -> new SpellBook(SpellTier.THREE));
        CREATIVE_SPELLBOOK = ItemsRegistry.register("creative_spell_book", () -> new SpellBook(SpellTier.CREATIVE));
        BLANK_GLYPH = ItemsRegistry.register("blank_glyph");
        MAGE_BLOOM = ItemsRegistry.register("magebloom", () -> new ModItem().withTooltip((Component)Component.translatable((String)"ars_nouveau.tooltip.magebloom")));
        MAGE_FIBER = ItemsRegistry.register("magebloom_fiber");
        MUNDANE_BELT = ItemsRegistry.register("mundane_belt", () -> new ModItem().withTooltip((Component)Component.translatable((String)"ars_nouveau.tooltip.dull")));
        JAR_OF_LIGHT = ItemsRegistry.register("jar_of_light", JarOfLight::new);
        BELT_OF_LEVITATION = ItemsRegistry.register("belt_of_levitation", BeltOfLevitation::new);
        WORN_NOTEBOOK = ItemsRegistry.register("worn_notebook", WornNotebook::new);
        RING_OF_POTENTIAL = ItemsRegistry.register("ring_of_potential", () -> new ModItem().withTooltip((Component)Component.translatable((String)"ars_nouveau.tooltip.dull")));
        RING_OF_LESSER_DISCOUNT = ItemsRegistry.register("ring_of_lesser_discount", () -> new DiscountRing(){

            @Override
            public int getManaDiscount() {
                return 10;
            }
        });
        RING_OF_GREATER_DISCOUNT = ItemsRegistry.register("ring_of_greater_discount", () -> new DiscountRing(){

            @Override
            public int getManaDiscount() {
                return 20;
            }
        });
        BELT_OF_UNSTABLE_GIFTS = ItemsRegistry.register("belt_of_unstable_gifts", BeltOfUnstableGifts::new);
        WARP_SCROLL = ItemsRegistry.register("warp_scroll", WarpScroll::new);
        SPELL_PARCHMENT = ItemsRegistry.register("spell_parchment", SpellParchment::new);
        BOOKWYRM_CHARM = ItemsRegistry.register("bookwyrm_charm", BookwyrmCharm::new);
        DOMINION_ROD = ItemsRegistry.register("dominion_wand", DominionWand::new);
        AMULET_OF_MANA_BOOST = ItemsRegistry.register("amulet_of_mana_boost", () -> new AbstractManaCurio(){

            @Override
            public int getMaxManaBoost(ItemStack i) {
                return 50;
            }
        });
        AMULET_OF_MANA_REGEN = ItemsRegistry.register("amulet_of_mana_regen", () -> new AbstractManaCurio(){

            @Override
            public int getManaRegenBonus(ItemStack i) {
                return 3;
            }
        });
        DULL_TRINKET = ItemsRegistry.register("dull_trinket", () -> new ModItem().withTooltip((Component)Component.translatable((String)"ars_nouveau.tooltip.dull")));
        STARBUNCLE_CHARM = ItemsRegistry.register("starbuncle_charm", StarbuncleCharm::new);
        debug = ItemsRegistry.register("debug", Debug::new);
        STARBUNCLE_SHARD = ItemsRegistry.register("starbuncle_shards", StarbuncleShard::new);
        STARBUNCLE_SHADES = ItemsRegistry.register("starbuncle_shades", StarbuncleShades::new);
        WHIRLISPRIG_CHARM = ItemsRegistry.register("whirlisprig_charm", WhirlisprigCharm::new);
        WHIRLISPRIG_SHARDS = ItemsRegistry.register("whirlisprig_shards", () -> new ModItem().withTooltip("tooltip.whirlisprig_shard").withTooltip((Component)Component.translatable((String)"tooltip.whirlisprig_shard2").withStyle(LORE_STYLE)));
        SOURCE_GEM = ItemsRegistry.register("source_gem", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.source_gem")));
        ALLOW_ITEM_SCROLL = ItemsRegistry.register("allow_scroll", AllowItemScroll::new);
        DENY_ITEM_SCROLL = ItemsRegistry.register("deny_scroll", DenyItemScroll::new);
        MIMIC_ITEM_SCROLL = ItemsRegistry.register("mimic_scroll", MimicItemScroll::new);
        BLANK_PARCHMENT = ItemsRegistry.register("blank_parchment", BlankParchmentItem::new);
        WAND = ItemsRegistry.register("wand", Wand::new);
        VOID_JAR = ItemsRegistry.register("void_jar", VoidJar::new);
        WIXIE_CHARM = ItemsRegistry.register("wixie_charm", WixieCharm::new);
        WIXIE_SHARD = ItemsRegistry.register("wixie_shards", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.wixie_shard")).withTooltip((Component)Component.translatable((String)"tooltip.wixie_shard2").withStyle(LORE_STYLE)));
        SPELL_BOW = ItemsRegistry.register("spell_bow", SpellBow::new);
        AMPLIFY_ARROW = ItemsRegistry.register("amplify_arrow", () -> new SpellArrow(AugmentAmplify.INSTANCE, 2));
        SPLIT_ARROW = ItemsRegistry.register("split_arrow", () -> new FormSpellArrow(AugmentSplit.INSTANCE, 2));
        PIERCE_ARROW = ItemsRegistry.register("pierce_arrow", () -> new FormSpellArrow(AugmentPierce.INSTANCE, 2));
        WILDEN_HORN = ItemsRegistry.register("wilden_horn", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.wilden_horn")));
        WILDEN_SPIKE = ItemsRegistry.register("wilden_spike", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.wilden_spike")));
        WILDEN_WING = ItemsRegistry.register("wilden_wing", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.wilden_wing")));
        POTION_FLASK = ItemsRegistry.register("potion_flask", () -> {
            PotionFlask flask = new PotionFlask(){

                @Override
                @NotNull
                public MobEffectInstance getEffectInstance(MobEffectInstance effectInstance) {
                    return effectInstance;
                }
            };
            flask.withTooltip((Component)Component.translatable((String)"tooltip.potion_flask"));
            return flask;
        });
        POTION_FLASK_AMPLIFY = ItemsRegistry.register("potion_flask_amplify", () -> {
            PotionFlask flask = new PotionFlask(){

                @Override
                @NotNull
                public MobEffectInstance getEffectInstance(MobEffectInstance effectInstance) {
                    return new MobEffectInstance(effectInstance.getEffect(), effectInstance.getDuration() / 2, Math.min((Integer)Config.ENCHANTED_FLASK_CAP.get(), effectInstance.getAmplifier() + 1));
                }
            };
            flask.withTooltip((Component)Component.translatable((String)"tooltip.potion_flask_amplify"));
            return flask;
        });
        POTION_FLASK_EXTEND_TIME = ItemsRegistry.register("potion_flask_extend_time", () -> {
            PotionFlask flask = new PotionFlask(){

                @Override
                @NotNull
                public MobEffectInstance getEffectInstance(MobEffectInstance effectInstance) {
                    return new MobEffectInstance(effectInstance.getEffect(), effectInstance.getDuration() + effectInstance.getDuration() / 2, effectInstance.getAmplifier());
                }
            };
            flask.withTooltip((Component)Component.translatable((String)"tooltip.potion_flask_extend_time"));
            return flask;
        });
        EXPERIENCE_GEM = ItemsRegistry.register("experience_gem", () -> {
            ExperienceGem gem = new ExperienceGem(){

                @Override
                public int getValue() {
                    return 3;
                }
            };
            gem.withTooltip((Component)Component.translatable((String)"ars_nouveau.tooltip.exp_gem"));
            return gem;
        });
        GREATER_EXPERIENCE_GEM = ItemsRegistry.register("greater_experience_gem", () -> {
            ExperienceGem gem = new ExperienceGem(){

                @Override
                public int getValue() {
                    return 12;
                }
            };
            gem.withTooltip((Component)Component.translatable((String)"ars_nouveau.tooltip.exp_gem"));
            return gem;
        });
        ENCHANTERS_SWORD = ItemsRegistry.register("enchanters_sword", () -> new EnchantersSword((Tier)Tiers.NETHERITE, 3, -2.4f));
        ENCHANTERS_SHIELD = ItemsRegistry.register("enchanters_shield", EnchantersShield::new);
        CASTER_TOME = ItemsRegistry.register("caster_tome", CasterTome::new);
        DRYGMY_CHARM = ItemsRegistry.register("drygmy_charm", DrygmyCharm::new);
        DRYGMY_SHARD = ItemsRegistry.register("drygmy_shard", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.drygmy_shard")).withTooltip((Component)Component.translatable((String)"tooltip.drygmy_shard2").withStyle(LORE_STYLE)));
        WILDEN_TRIBUTE = ItemsRegistry.register("wilden_tribute", () -> new ModItem(ItemsRegistry.defaultItemProperties().fireResistant()).withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.wilden_tribute").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE))).withRarity(Rarity.EPIC));
        SUMMONING_FOCUS = ItemsRegistry.register("summon_focus", SummoningFocus::new);
        SHAPERS_FOCUS = ItemsRegistry.register("shapers_focus", () -> new ShapersFocus(ItemsRegistry.defaultItemProperties().stacksTo(1)));
        SOURCE_BERRY_PIE = ItemsRegistry.register("source_berry_pie", () -> new ModItem(ItemsRegistry.defaultItemProperties().food(SOURCE_PIE_FOOD)).withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.source_food")));
        SOURCE_BERRY_ROLL = ItemsRegistry.register("source_berry_roll", () -> new ModItem(ItemsRegistry.defaultItemProperties().food(SOURCE_ROLL_FOOD)).withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.source_food")));
        ENCHANTERS_MIRROR = ItemsRegistry.register("enchanters_mirror", () -> new EnchantersMirror(ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.SPELL_CASTER, (Object)new SpellCaster())));
        SORCERER_BOOTS = ItemsRegistry.register("sorcerer_boots", () -> AnimatedMagicArmor.light(ArmorItem.Type.BOOTS));
        SORCERER_LEGGINGS = ItemsRegistry.register("sorcerer_leggings", () -> AnimatedMagicArmor.light(ArmorItem.Type.LEGGINGS));
        SORCERER_ROBES = ItemsRegistry.register("sorcerer_robes", () -> AnimatedMagicArmor.light(ArmorItem.Type.CHESTPLATE));
        SORCERER_HOOD = ItemsRegistry.register("sorcerer_hood", () -> AnimatedMagicArmor.light(ArmorItem.Type.HELMET));
        ARCANIST_BOOTS = ItemsRegistry.register("arcanist_boots", () -> AnimatedMagicArmor.medium(ArmorItem.Type.BOOTS));
        ARCANIST_LEGGINGS = ItemsRegistry.register("arcanist_leggings", () -> AnimatedMagicArmor.medium(ArmorItem.Type.LEGGINGS));
        ARCANIST_ROBES = ItemsRegistry.register("arcanist_robes", () -> AnimatedMagicArmor.medium(ArmorItem.Type.CHESTPLATE));
        ARCANIST_HOOD = ItemsRegistry.register("arcanist_hood", () -> AnimatedMagicArmor.medium(ArmorItem.Type.HELMET));
        BATTLEMAGE_BOOTS = ItemsRegistry.register("battlemage_boots", () -> AnimatedMagicArmor.heavy(ArmorItem.Type.BOOTS));
        BATTLEMAGE_LEGGINGS = ItemsRegistry.register("battlemage_leggings", () -> AnimatedMagicArmor.heavy(ArmorItem.Type.LEGGINGS));
        BATTLEMAGE_ROBES = ItemsRegistry.register("battlemage_robes", () -> AnimatedMagicArmor.heavy(ArmorItem.Type.CHESTPLATE));
        BATTLEMAGE_HOOD = ItemsRegistry.register("battlemage_hood", () -> AnimatedMagicArmor.heavy(ArmorItem.Type.HELMET));
        DOWSING_ROD = ItemsRegistry.register("dowsing_rod", DowsingRod::new);
        ABJURATION_ESSENCE = ItemsRegistry.register("abjuration_essence", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.essences")));
        CONJURATION_ESSENCE = ItemsRegistry.register("conjuration_essence", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.essences")));
        AIR_ESSENCE = ItemsRegistry.register("air_essence", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.essences")));
        EARTH_ESSENCE = ItemsRegistry.register("earth_essence", EarthEssence::new);
        FIRE_ESSENCE = ItemsRegistry.register("fire_essence", FireEssence::new);
        MANIPULATION_ESSENCE = ItemsRegistry.register("manipulation_essence", ManipulationEssence::new);
        WATER_ESSENCE = ItemsRegistry.register("water_essence", () -> new ModItem().withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.essences")));
        AMETHYST_GOLEM_CHARM = ItemsRegistry.register("amethyst_golem_charm", AmethystGolemCharm::new);
        ANNOTATED_CODEX = ItemsRegistry.register("annotated_codex", AnnotatedCodex::new);
        SCRYER_SCROLL = ItemsRegistry.register("scryer_scroll", ScryerScroll::new);
        WIXIE_HAT = ItemsRegistry.register("wixie_hat", () -> new WixieHat().withTooltip("tooltip.ars_nouveau.wixie_hat"));
        ALCHEMISTS_CROWN = ItemsRegistry.register("alchemists_crown", () -> new AlchemistsCrown(ItemsRegistry.defaultItemProperties().stacksTo(1)));
        SPLASH_LAUNCHER = ItemsRegistry.register("splash_flask_cannon", () -> new FlaskCannon.SplashLauncher(ItemsRegistry.defaultItemProperties().stacksTo(1)));
        LINGERING_LAUNCHER = ItemsRegistry.register("lingering_flask_cannon", () -> new FlaskCannon.LingeringLauncher(ItemsRegistry.defaultItemProperties().stacksTo(1)));
        FIREL_DISC = ItemsRegistry.register("music_disc_aria_biblio", () -> new Item(ItemsRegistry.defaultItemProperties().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(JukeboxRegistry.ARIA_BIBLIO)));
        SOUND_OF_GLASS = ItemsRegistry.register("music_disc_thistle_the_sound_of_glass", () -> new Item(ItemsRegistry.defaultItemProperties().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(JukeboxRegistry.SOUND_OF_GLASS)));
        WILD_HUNT = ItemsRegistry.register("music_disc_firel_the_wild_hunt", () -> new Item(ItemsRegistry.defaultItemProperties().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(JukeboxRegistry.WILD_HUNT)));
        STARBY_GIFY = ItemsRegistry.register("starby_gift", () -> new Present(ItemsRegistry.defaultItemProperties().rarity(Rarity.EPIC).component(DataComponentRegistry.PRESENT, (Object)new PresentData())));
        SPELL_CROSSBOW = ItemsRegistry.register("spell_crossbow", () -> new SpellCrossbow(ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.SPELL_CASTER, (Object)new SpellCaster())));
        STABLE_WARP_SCROLL = ItemsRegistry.register("stable_warp_scroll", () -> new StableWarpScroll(ItemsRegistry.defaultItemProperties().stacksTo(1)));
        SCRY_CASTER = ItemsRegistry.register("enchanters_eye", () -> new ScryCaster(ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.SCRY_CASTER, (Object)new ScryCasterData()).component(DataComponentRegistry.SCRY_DATA, (Object)new ScryPosData(Optional.empty()))));
        JUMP_RING = ItemsRegistry.register("jump_ring", JumpingRing::new);
        ALAKARKINOS_CHARM = ItemsRegistry.register("alakarkinos_charm", AlakarkinosCharm::new);
        ALAKARKINOS_SHARD = ItemsRegistry.register("alakarkinos_token", () -> new ModItem().withTooltip("tooltip.alakarkinos_shard1").withTooltip((Component)Component.translatable((String)"tooltip.alakarkinos_shard2").withStyle(LORE_STYLE)));
        ARS_STENCIL = ItemsRegistry.createPatternItem("ars_stencil", Rarity.UNCOMMON);
    }
}

