/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PacketWarpPosition
extends AbstractPacket {
    private final int entityID;
    double x;
    double y;
    double z;
    float xRot;
    float yRot;
    public static final CustomPacketPayload.Type<PacketWarpPosition> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("warp_position"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketWarpPosition> CODEC = StreamCodec.ofMember(PacketWarpPosition::toBytes, PacketWarpPosition::new);

    public PacketWarpPosition(Entity entity, double x, double y, double z) {
        this.entityID = entity.getId();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketWarpPosition(int id, double x, double y, double z, float xRot, float yRot) {
        this.entityID = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xRot = xRot;
        this.yRot = yRot;
    }

    public PacketWarpPosition(RegistryFriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.xRot = buf.readFloat();
        this.yRot = buf.readFloat();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.xRot);
        buf.writeFloat(this.yRot);
    }

    @Override
    public void onClientReceived(Minecraft mc, Player player) {
        ClientLevel world = mc.level;
        Entity e = world.getEntity(this.entityID);
        if (e == null) {
            return;
        }
        e.setPos(this.x, this.y, this.z);
        e.setXRot(this.xRot);
        e.setYRot(this.yRot);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

