/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateBookGUI;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import java.util.ArrayList;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class PacketUpdateCaster
extends AbstractPacket {
    Spell spellRecipe;
    int cast_slot;
    String spellName;
    boolean mainHand;
    public static final CustomPacketPayload.Type<PacketUpdateCaster> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("update_caster"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateCaster> CODEC = StreamCodec.ofMember(PacketUpdateCaster::toBytes, PacketUpdateCaster::new);

    public PacketUpdateCaster(Spell spellRecipe, int cast_slot, String spellName, boolean mainHand) {
        this.spellRecipe = spellRecipe;
        this.cast_slot = cast_slot;
        this.spellName = spellName;
        this.mainHand = mainHand;
    }

    public PacketUpdateCaster(RegistryFriendlyByteBuf buf) {
        this.spellRecipe = (Spell)ANCodecs.decode(Spell.CODEC.codec(), (Tag)buf.readNbt());
        this.cast_slot = buf.readInt();
        this.spellName = buf.readUtf(Short.MAX_VALUE);
        this.mainHand = buf.readBoolean();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeNbt(ANCodecs.encode(Spell.CODEC.codec(), this.spellRecipe));
        buf.writeInt(this.cast_slot);
        buf.writeUtf(this.spellName);
        buf.writeBoolean(this.mainHand);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        InteractionHand hand = this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack stack = player.getItemInHand(hand);
        if (!(stack.getItem() instanceof ICasterTool)) {
            return;
        }
        if (this.spellRecipe != null) {
            AbstractCaster<?> caster = SpellCasterRegistry.from(stack);
            Spell.Mutable spell = caster.getSpell(this.cast_slot).mutable().setRecipe(new ArrayList<AbstractSpellPart>(this.spellRecipe.unsafeList()));
            ((AbstractCaster)((AbstractCaster)((AbstractCaster)caster.setCurrentSlot(this.cast_slot)).setSpell(spell.immutable(), this.cast_slot)).setSpellName(this.spellName, this.cast_slot)).saveToStack(stack);
            Networking.sendToPlayerClient(new PacketUpdateBookGUI(stack), player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

