/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.DelayedSpellEvent;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PacketClientDelayEffect
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketClientDelayEffect> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("client_delay_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketClientDelayEffect> CODEC = StreamCodec.ofMember(PacketClientDelayEffect::toBytes, PacketClientDelayEffect::new);
    public Spell spell;
    public int duration;
    public int shooterID;
    @Nullable
    public BlockHitResult hitPos;
    public int hitEntityID;

    public PacketClientDelayEffect(RegistryFriendlyByteBuf buf) {
        this.duration = buf.readInt();
        this.spell = (Spell)ANCodecs.decode(Spell.CODEC.codec(), (Tag)buf.readNbt());
        this.shooterID = buf.readInt();
        this.hitEntityID = buf.readInt();
        if (this.hitEntityID == -1) {
            this.hitPos = buf.readBlockHitResult();
        }
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.duration);
        buf.writeNbt(ANCodecs.encode(Spell.CODEC.codec(), this.spell));
        buf.writeInt(this.shooterID);
        buf.writeInt(this.hitEntityID);
        if (this.hitEntityID == -1 && this.hitPos != null) {
            buf.writeBlockHitResult(this.hitPos);
        }
    }

    public PacketClientDelayEffect(int duration, @Nullable LivingEntity shooter, Spell spell, SpellContext context, @Nullable BlockHitResult hitPos, @Nullable Entity hitEntity) {
        this.duration = duration;
        this.shooterID = shooter == null ? -1 : shooter.getId();
        this.spell = spell;
        this.hitPos = hitPos;
        this.hitEntityID = hitEntity == null ? -1 : hitEntity.getId();
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Level world = ArsNouveau.proxy.getClientWorld();
        Entity hitEntity = world.getEntity(this.hitEntityID);
        Object result = this.hitEntityID == -1 ? this.hitPos : (hitEntity == null ? BlockHitResult.miss((Vec3)new Vec3(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)BlockPos.ZERO) : new EntityHitResult(hitEntity));
        LivingEntity entity = (LivingEntity)world.getEntity(this.shooterID);
        EventQueue.getClientQueue().addEvent(new DelayedSpellEvent(this.duration, (HitResult)result, world, new SpellResolver(new SpellContext(world, this.spell, entity, new LivingCaster(entity)))));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

