/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.container.StorageTerminalMenu;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ClientToServerStoragePacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<ClientToServerStoragePacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("storage_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientToServerStoragePacket> CODEC = StreamCodec.ofMember(ClientToServerStoragePacket::toBytes, ClientToServerStoragePacket::new);
    public CompoundTag tag;

    public ClientToServerStoragePacket(CompoundTag tag) {
        this.tag = tag;
    }

    public ClientToServerStoragePacket(RegistryFriendlyByteBuf pb) {
        this.tag = pb.readNbt();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf pb) {
        pb.writeNbt((Tag)this.tag);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer sender) {
        AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
        if (abstractContainerMenu instanceof StorageTerminalMenu) {
            StorageTerminalMenu terminalScreen = (StorageTerminalMenu)abstractContainerMenu;
            terminalScreen.receive(sender, (HolderLookup.Provider)minecraftServer.registryAccess(), this.tag);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

