/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event.timed;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.event.timed.IRewindable;
import com.hollingsworth.arsnouveau.common.spell.rewind.IRewindCallback;
import com.hollingsworth.arsnouveau.common.spell.rewind.RewindAttachment;
import com.hollingsworth.arsnouveau.common.spell.rewind.RewindEntityData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class RewindEvent
implements ITimedEvent {
    @Nullable
    public Entity entity;
    public boolean doneRewinding;
    public int rewindTicks;
    public int ticksToRewind;
    public boolean respectsGravity;
    @Nullable
    public SpellContext context;
    public boolean serverSide;
    public long startGameTime;

    public RewindEvent(long gameTime, int ticksToRewind, @Nullable SpellContext spellContext) {
        this.startGameTime = gameTime;
        this.ticksToRewind = ticksToRewind;
        this.context = spellContext;
    }

    public RewindEvent(@Nullable Entity entity, long gameTime, int ticksToRewind) {
        this(gameTime, ticksToRewind, null);
        this.entity = entity;
        this.respectsGravity = entity != null && !entity.isNoGravity();
    }

    public RewindEvent(@Nullable Entity entity, long gameTime, int ticksToRewind, @Nullable SpellContext context) {
        this(entity, gameTime, ticksToRewind);
        this.context = context;
    }

    @Override
    public void tick(boolean serverSide) {
        this.serverSide = serverSide;
        long eventGameTime = this.startGameTime - (long)this.rewindTicks;
        Entity entity = this.entity;
        if (entity instanceof IRewindable) {
            IRewindable rewindable = (IRewindable)entity;
            rewindable.setRewinding(true);
            if (!rewindable.getMotions().empty()) {
                RewindEntityData data = rewindable.getMotions().pop();
                data.onRewind(this);
            }
        }
        if (this.context != null) {
            RewindAttachment rewindAttachment = RewindAttachment.get(this.context);
            List<IRewindCallback> contextData = rewindAttachment.getForTime(eventGameTime);
            rewindAttachment.setLockedTime(eventGameTime);
            if (contextData != null) {
                for (IRewindCallback callback : contextData) {
                    callback.onRewind(this);
                }
            }
            rewindAttachment.setLockedTime(-1L);
        }
        ++this.rewindTicks;
        if (this.rewindTicks >= this.ticksToRewind) {
            this.stop();
        }
    }

    public void stop() {
        this.doneRewinding = true;
        Entity entity = this.entity;
        if (entity instanceof IRewindable) {
            IRewindable rewindable = (IRewindable)entity;
            rewindable.setRewinding(false);
            this.entity.setDeltaMovement(Vec3.ZERO);
            if (this.respectsGravity) {
                this.entity.setNoGravity(false);
            }
        }
    }

    @Override
    public void onServerStopping() {
        if (this.respectsGravity && this.entity != null) {
            this.entity.setNoGravity(false);
        }
    }

    @Override
    public boolean isExpired() {
        return this.doneRewinding;
    }
}

