/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.lily;

import com.hollingsworth.arsnouveau.common.entity.goal.lily.IAdorable;
import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class WagGoal<T extends Mob>
extends Goal {
    T lily;
    public LivingEntity target;
    public int wagAtTicks;

    public WagGoal(T lily) {
        this.lily = lily;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public void tick() {
        super.tick();
        if (this.wagAtTicks > 0) {
            --this.wagAtTicks;
        }
        if (this.target != null) {
            this.lily.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        }
    }

    public boolean canUse() {
        this.target = null;
        ServerLevel level = (ServerLevel)((Mob)this.lily).level;
        for (Player player : level.getPlayers(p -> true)) {
            if (!(player.distanceTo(this.lily) < 5.0f) || !((IAdorable)this.lily).isLookingAtMe(player)) continue;
            this.target = player;
            this.wagAtTicks = 100;
            ((IAdorable)this.lily).setWagging(true);
            ((IAdorable)this.lily).setWagTicks(100);
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.wagAtTicks > 0;
    }
}

