/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.entity.goal.UntamedFindItemGoal;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GiftStarbuncle
extends PathfinderMob
implements GeoEntity {
    int tamingTime;
    public static final EntityDataAccessor<Boolean> BEING_TAMED = SynchedEntityData.defineId(GiftStarbuncle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GiftStarbuncle(EntityType<GiftStarbuncle> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (this.getMainHandItem().isEmpty() && !this.level.isClientSide) {
            for (ItemEntity itementity : this.level.getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(1.0))) {
                if (!itementity.isAlive() || itementity.getItem().isEmpty() || itementity.hasPickUpDelay()) continue;
                this.pickUpItem(itementity);
                if (this.getMainHandItem().isEmpty()) continue;
                break;
            }
        }
        if (!this.isTaming()) {
            return;
        }
        ++this.tamingTime;
        if (this.tamingTime > 60 && !this.level.isClientSide) {
            ItemStack stack = new ItemStack((ItemLike)ItemsRegistry.STARBUNCLE_SHARD.get(), 1 + this.level.random.nextInt(2));
            ItemStack gift = new ItemStack((ItemLike)ItemsRegistry.STARBY_GIFY.get(), 1);
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY() + 0.5, this.getZ(), gift));
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX(), this.getY() + 0.5, this.getZ(), stack));
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.POOF_MOB.get(), (ServerLevel)this.level, this.getOnPos(), 10);
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (this.tamingTime == 60 && this.level.isClientSide) {
            for (int i = 0; i < 10; ++i) {
                double d0 = this.getX();
                double d1 = this.getY() + 0.1;
                double d2 = this.getZ();
                this.level.addParticle((ParticleOptions)ParticleTypes.END_ROD, d0, d1, d2, ((double)(this.level.random.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.level.random.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.level.random.nextFloat() * 1.0f) - 0.5) / 3.0);
            }
        }
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        if (!this.getMainHandItem().isEmpty()) {
            return;
        }
        if (!this.isTaming() && itemEntity.getItem().is(Tags.Items.NUGGETS_GOLD)) {
            this.setItemInHand(InteractionHand.MAIN_HAND, itemEntity.getItem().split(1));
            this.setTaming(true);
        }
    }

    public boolean isTaming() {
        return (Boolean)this.entityData.get(BEING_TAMED);
    }

    public void setTaming(boolean taming) {
        this.entityData.set(BEING_TAMED, (Object)taming);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new UntamedFindItemGoal((Mob)this, () -> (Boolean)this.entityData.get(BEING_TAMED) == false, i -> i.getItem().is(Tags.Items.NUGGETS_GOLD)));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 0.02f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 2.0, 1.2));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(BEING_TAMED, (Object)false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        animatableManager.add(new AnimationController((GeoAnimatable)this, "walkController", 1, this::animationPredicate));
        animatableManager.add(new AnimationController((GeoAnimatable)this, "danceController", 1, this::dancePredicate));
    }

    private PlayState animationPredicate(AnimationState<?> event) {
        if (event.isMoving() || this.level.isClientSide && PatchouliHandler.isPatchouliWorld()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return SummonUtil.canSummonTakeDamage(pSource) && super.hurt(pSource, pAmount);
    }

    private PlayState dancePredicate(AnimationState<?> event) {
        if (((Boolean)this.entityData.get(BEING_TAMED)).booleanValue()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("dance"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

