/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.NearbyPlayerCache;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.util.EasingManager;
import com.hollingsworth.arsnouveau.common.util.EasingType;
import com.hollingsworth.arsnouveau.setup.registry.DataSerializers;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityFlyingItem
extends ColoredProjectile {
    public static final EntityDataAccessor<Vec3> to = SynchedEntityData.defineId(EntityFlyingItem.class, (EntityDataSerializer)((EntityDataSerializer)DataSerializers.VEC.get()));
    public static final EntityDataAccessor<Vec3> from = SynchedEntityData.defineId(EntityFlyingItem.class, (EntityDataSerializer)((EntityDataSerializer)DataSerializers.VEC.get()));
    public static final EntityDataAccessor<Boolean> SPAWN_TOUCH = SynchedEntityData.defineId(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int age;
    int maxAge;
    public static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.defineId(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<Float> OFFSET = SynchedEntityData.defineId(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> DIDOFFSET = SynchedEntityData.defineId(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> IS_BUBBLE = SynchedEntityData.defineId(EntityFlyingItem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    boolean wentUp;

    public EntityFlyingItem(Level worldIn, Vec3 from, Vec3 to) {
        this(worldIn, from, to, 255, 25, 180);
    }

    public EntityFlyingItem(Level worldIn, Vec3 from, Vec3 to, int r, int g, int b) {
        this((EntityType<EntityFlyingItem>)((EntityType)ModEntities.ENTITY_FLYING_ITEM.get()), worldIn);
        this.entityData.set(EntityFlyingItem.to, (Object)to);
        this.entityData.set(EntityFlyingItem.from, (Object)from);
        this.maxAge = (int)Math.floor(from.subtract(to).length() * 5.0);
        this.entityData.set(RED, (Object)r);
        this.entityData.set(GREEN, (Object)g);
        this.entityData.set(BLUE, (Object)b);
        this.setPos(from);
    }

    public EntityFlyingItem(Level worldIn, BlockPos from, BlockPos to) {
        this(worldIn, new Vec3((double)from.getX() + 0.5, (double)from.getY(), (double)from.getZ() + 0.5), new Vec3((double)to.getX() + 0.5, (double)to.getY(), (double)to.getZ() + 0.5), 255, 25, 180);
    }

    public EntityFlyingItem(Level worldIn, BlockPos from, BlockPos to, int r, int g, int b) {
        this(worldIn, new Vec3((double)from.getX() + 0.5, (double)from.getY(), (double)from.getZ() + 0.5), new Vec3((double)to.getX() + 0.5, (double)to.getY(), (double)to.getZ() + 0.5), r, g, b);
    }

    public EntityFlyingItem(EntityType<EntityFlyingItem> entityAOEProjectileEntityType, Level world) {
        super(entityAOEProjectileEntityType, world);
    }

    @NotNull
    public static EntityFlyingItem spawn(ServerLevel level, Vec3 from, Vec3 to, int r, int g, int b) {
        boolean canSpawn = NearbyPlayerCache.isPlayerNearby(BlockPos.containing((Position)from), level, 64);
        EntityFlyingItem entity = new EntityFlyingItem((Level)level, from, to, r, g, b);
        if (canSpawn && level.isLoaded(BlockPos.containing((Position)to))) {
            level.addFreshEntity((Entity)entity);
        }
        return entity;
    }

    @NotNull
    public static EntityFlyingItem spawn(ServerLevel level, BlockPos from, BlockPos to, int r, int g, int b) {
        return EntityFlyingItem.spawn(from, level, from, to, r, g, b);
    }

    @NotNull
    public static EntityFlyingItem spawn(BlockPos checkCachePos, ServerLevel level, BlockPos from, BlockPos to, int r, int g, int b) {
        boolean canSpawn = NearbyPlayerCache.isPlayerNearby(checkCachePos, level, 64);
        EntityFlyingItem entity = new EntityFlyingItem((Level)level, from, to, r, g, b);
        if (canSpawn && level.isLoaded(to)) {
            level.addFreshEntity((Entity)entity);
        }
        return entity;
    }

    @NotNull
    public static EntityFlyingItem spawn(BlockPos checkCachePos, ServerLevel level, BlockPos from, BlockPos to) {
        return EntityFlyingItem.spawn(checkCachePos, level, from, to, 255, 25, 180);
    }

    @NotNull
    public static EntityFlyingItem spawn(ServerLevel level, BlockPos from, BlockPos to) {
        return EntityFlyingItem.spawn(from, level, from, to);
    }

    public EntityFlyingItem setStack(ItemStack stack) {
        this.entityData.set(HELD_ITEM, (Object)stack.copy());
        return this;
    }

    public static float lerp(double percentCompleted, double startValue, double endValue, EasingType type) {
        if (percentCompleted >= 1.0) {
            return (float)endValue;
        }
        percentCompleted = EasingManager.ease(percentCompleted, type, null);
        return (float)EntityFlyingItem.lerpInternal(percentCompleted, startValue, endValue);
    }

    public static double lerpInternal(double pct, double start, double end) {
        return start + pct * (end - start);
    }

    public double normalize(double value, double min, double max) {
        return 1.0 - (value - min) / (max - min);
    }

    public void tick() {
        super.tick();
        ++this.age;
        if (this.age > 400) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        Vec3 start = (Vec3)this.entityData.get(from);
        Vec3 end = (Vec3)this.entityData.get(to);
        if (BlockUtil.distanceFrom(end, this.position()) <= 1.0 || this.age > 1000 || BlockUtil.distanceFrom(end, this.position()) > 16.0) {
            this.remove(Entity.RemovalReason.DISCARDED);
            if (this.level.isClientSide && ((Boolean)this.entityData.get(SPAWN_TOUCH)).booleanValue()) {
                ParticleUtil.spawnTouch((ClientLevel)this.level, BlockPos.containing((double)end.x, (double)end.y, (double)end.z), new ParticleColor((Integer)this.entityData.get(RED), (Integer)this.entityData.get(GREEN), (Integer)this.entityData.get(BLUE)));
            }
            return;
        }
        double posX = this.getX();
        double posY = this.getY();
        double posZ = this.getZ();
        double time = 1.0 - this.normalize(this.age, 0.0, 80.0);
        EasingType type = EasingType.NONE;
        double startY = start.y();
        double endY = end.y() + this.getDistanceAdjustment(start, end);
        double lerpX = EntityFlyingItem.lerp(time, start.x(), end.x(), type);
        double lerpY = EntityFlyingItem.lerp(time, EntityFlyingItem.lerp(time, startY, endY, type), EntityFlyingItem.lerp(time, endY, startY, type), type);
        double lerpZ = EntityFlyingItem.lerp(time, start.z(), end.z(), type);
        Vec3 adjustedPos = new Vec3(posX, end.y(), posZ);
        if (BlockUtil.distanceFrom(end, adjustedPos) <= 0.5) {
            posY = this.getY() - 0.05;
            this.setPos(lerpX, posY, lerpZ);
        } else {
            this.setPos(lerpX, lerpY, lerpZ);
        }
        if (this.level.isClientSide && this.age > 1 && !((Boolean)this.getEntityData().get(IS_BUBBLE)).booleanValue()) {
            double deltaX = this.getX() - this.xOld;
            double deltaY = this.getY() - this.yOld;
            double deltaZ = this.getZ() - this.zOld;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
            int counter = 0;
            for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                if ((counter += this.level.random.nextInt(3)) % (((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId() == 0 ? 1 : 2 * ((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId()) != 0) continue;
                this.level.addParticle(GlowParticleData.createData(new ParticleColor((Integer)this.entityData.get(RED), (Integer)this.entityData.get(GREEN), (Integer)this.entityData.get(BLUE))), (double)((float)(this.xo + deltaX * coeff)), (double)((float)(this.yo + deltaY * coeff)), (double)((float)(this.zo + deltaZ * coeff)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)));
            }
        }
    }

    public EntityFlyingItem withNoTouch() {
        this.entityData.set(SPAWN_TOUCH, (Object)false);
        return this;
    }

    public void setDistanceAdjust(float offset) {
        this.entityData.set(OFFSET, (Object)Float.valueOf(offset));
        this.entityData.set(DIDOFFSET, (Object)true);
    }

    private double getDistanceAdjustment(Vec3 start, Vec3 end) {
        if (((Boolean)this.entityData.get(DIDOFFSET)).booleanValue()) {
            return ((Float)this.entityData.get(OFFSET)).floatValue();
        }
        double distance = BlockUtil.distanceFrom(start, end);
        if (distance <= 1.5) {
            return 2.5;
        }
        return 3.0;
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        this.entityData.set(HELD_ITEM, (Object)ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)compound.getCompound("item")));
        this.age = compound.getInt("age");
        this.entityData.set(DIDOFFSET, (Object)compound.getBoolean("didoffset"));
        this.entityData.set(OFFSET, (Object)Float.valueOf(compound.getFloat("offset")));
        this.entityData.set(from, (Object)NBTUtil.getVec(compound, "from"));
        this.entityData.set(to, (Object)NBTUtil.getVec(compound, "to"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getStack() != null) {
            Tag tag = this.getStack().save((HolderLookup.Provider)this.level.registryAccess());
            compound.put("item", tag);
        }
        compound.putInt("age", this.age);
        compound.putBoolean("didoffset", ((Boolean)this.entityData.get(DIDOFFSET)).booleanValue());
        compound.putFloat("offset", ((Float)this.entityData.get(OFFSET)).floatValue());
        if (from != null) {
            NBTUtil.storeVec(compound, "from", (Vec3)this.entityData.get(from));
        }
        if (to != null) {
            NBTUtil.storeVec(compound, "to", (Vec3)this.entityData.get(to));
        }
    }

    public ItemStack getStack() {
        return (ItemStack)this.entityData.get(HELD_ITEM);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(HELD_ITEM, (Object)ItemStack.EMPTY);
        pBuilder.define(OFFSET, (Object)Float.valueOf(0.0f));
        pBuilder.define(DIDOFFSET, (Object)false);
        pBuilder.define(to, (Object)new Vec3(0.0, 0.0, 0.0));
        pBuilder.define(from, (Object)new Vec3(0.0, 0.0, 0.0));
        pBuilder.define(SPAWN_TOUCH, (Object)true);
        pBuilder.define(IS_BUBBLE, (Object)false);
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_FLYING_ITEM.get();
    }
}

