/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.api.registry.AlakarkinosConversionRegistry;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;

public record AlakarkinosRecipe(Block input, ResourceKey<LootTable> table, int weight, Optional<AlakarkinosConversionRegistry.LootDrops> drops) implements SpecialSingleInputRecipe
{
    public AlakarkinosRecipe(Block input, ResourceKey<LootTable> table, int weight) {
        this(input, table, weight, Optional.empty());
    }

    public boolean matches(BlockState block) {
        return block.is(this.input);
    }

    public boolean matches(SingleRecipeInput p_346065_, Level p_345375_) {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.ALAKARKINOS_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.ALAKARKINOS_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<AlakarkinosRecipe> {
        public static final MapCodec<AlakarkinosRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("input").forGetter(AlakarkinosRecipe::input), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("table").forGetter(AlakarkinosRecipe::table), (App)Codec.INT.fieldOf("weight").forGetter(AlakarkinosRecipe::weight), (App)AlakarkinosConversionRegistry.LootDrops.CODEC.optionalFieldOf("drops").forGetter(AlakarkinosRecipe::drops)).apply((Applicative)instance, AlakarkinosRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlakarkinosRecipe> STREAM = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static AlakarkinosRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            return CheatSerializer.fromNetwork(CODEC, buf);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, AlakarkinosRecipe karky) {
            AlakarkinosConversionRegistry.LootDrops drops = AlakarkinosConversionRegistry.LootDrop.getLootDrops(karky.table);
            AlakarkinosRecipe recipe = new AlakarkinosRecipe(karky.input, karky.table, karky.weight, Optional.ofNullable(drops));
            CheatSerializer.toNetwork(CODEC, buf, recipe);
        }

        public MapCodec<AlakarkinosRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlakarkinosRecipe> streamCodec() {
            return STREAM;
        }
    }
}

