/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.camera;

import com.hollingsworth.arsnouveau.common.block.ScryerCrystal;
import com.hollingsworth.arsnouveau.common.entity.ScryerCamera;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketDismountCamera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityAccess;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="ars_nouveau", value={Dist.CLIENT})
public class CameraController {
    public static CameraType previousCameraType;
    public static boolean resetOverlaysAfterDismount;
    private static ClientChunkCache.Storage cameraStorage;
    private static boolean wasUpPressed;
    private static boolean wasDownPressed;
    private static boolean wasLeftPressed;
    private static boolean wasRightPressed;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        Entity cameraEntity = Minecraft.getInstance().cameraEntity;
        if (cameraEntity instanceof ScryerCamera) {
            ScryerCamera cam = (ScryerCamera)cameraEntity;
            Options options = Minecraft.getInstance().options;
            if (event instanceof ClientTickEvent.Pre) {
                wasUpPressed = options.keyUp.isDown();
                if (wasUpPressed) {
                    options.keyUp.setDown(false);
                }
                if (wasDownPressed = options.keyDown.isDown()) {
                    options.keyDown.setDown(false);
                }
                if (wasLeftPressed = options.keyLeft.isDown()) {
                    options.keyLeft.setDown(false);
                }
                if (wasRightPressed = options.keyRight.isDown()) {
                    options.keyRight.setDown(false);
                }
                if (options.keyShift.isDown()) {
                    CameraController.dismount();
                    options.keyShift.setDown(false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Entity cameraEntity = Minecraft.getInstance().cameraEntity;
        if (cameraEntity instanceof ScryerCamera) {
            ScryerCamera cam = (ScryerCamera)cameraEntity;
            Options options = Minecraft.getInstance().options;
            if (event instanceof ClientTickEvent.Post) {
                if (wasUpPressed) {
                    CameraController.moveViewUp(cam);
                    options.keyUp.setDown(true);
                }
                if (wasDownPressed) {
                    CameraController.moveViewDown(cam);
                    options.keyDown.setDown(true);
                }
                if (wasLeftPressed) {
                    CameraController.moveViewHorizontally(cam, cam.getYRot(), cam.getYRot() - (float)cam.cameraSpeed * cam.zoomAmount);
                    options.keyLeft.setDown(true);
                }
                if (wasRightPressed) {
                    CameraController.moveViewHorizontally(cam, cam.getYRot(), cam.getYRot() + (float)cam.cameraSpeed * cam.zoomAmount);
                    options.keyRight.setDown(true);
                }
                LocalPlayer player = Minecraft.getInstance().player;
                double yRotChange = player.getYRot() - player.yRotLast;
                double xRotChange = player.getXRot() - player.xRotLast;
                if (yRotChange != 0.0 || xRotChange != 0.0) {
                    player.connection.send((Packet)new ServerboundMovePlayerPacket.Rot(player.getYRot(), player.getXRot(), player.onGround()));
                }
            }
        }
    }

    private static void dismount() {
        Networking.sendToServer(new PacketDismountCamera());
    }

    public static void moveViewUp(ScryerCamera cam) {
        float next = cam.getXRot() - (float)cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next > 40.0f) {
                cam.setRotation(cam.getYRot(), next);
            }
        } else if (next > -25.0f) {
            cam.setRotation(cam.getYRot(), next);
        }
    }

    public static void moveViewDown(ScryerCamera cam) {
        float next = cam.getXRot() + (float)cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next < 90.0f) {
                cam.setRotation(cam.getYRot(), next);
            }
        } else if (next < 60.0f) {
            cam.setRotation(cam.getYRot(), next);
        }
    }

    public static void moveViewHorizontally(ScryerCamera cam, float yRot, float next) {
        BlockState state = cam.level.getBlockState(cam.blockPosition());
        if (state.hasProperty((Property)ScryerCrystal.FACING)) {
            boolean shouldSetRotation;
            float checkNext = next;
            if (checkNext < 0.0f) {
                checkNext += 360.0f;
            }
            switch ((Direction)state.getValue((Property)ScryerCrystal.FACING)) {
                case NORTH: {
                    boolean bl;
                    if (checkNext > 90.0f && checkNext < 270.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case SOUTH: {
                    boolean bl;
                    if (checkNext > 270.0f || checkNext < 90.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case EAST: {
                    boolean bl;
                    if (checkNext > 180.0f && checkNext < 360.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case WEST: {
                    boolean bl;
                    if (checkNext > 0.0f && checkNext < 180.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case DOWN: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = shouldSetRotation = false;
                }
            }
            if (shouldSetRotation) {
                cam.setYRot(next);
            }
        }
    }

    public static ClientChunkCache.Storage getCameraStorage() {
        return cameraStorage;
    }

    public static void setCameraStorage(ClientChunkCache.Storage cameraStorage) {
        if (cameraStorage != null) {
            CameraController.cameraStorage = cameraStorage;
        }
    }

    public static void setRenderPosition(Entity entity) {
        if (entity instanceof ScryerCamera) {
            SectionPos cameraPos = SectionPos.of((EntityAccess)entity);
            CameraController.cameraStorage.viewCenterX = cameraPos.x();
            CameraController.cameraStorage.viewCenterZ = cameraPos.z();
        }
    }

    static {
        resetOverlaysAfterDismount = false;
    }
}

