/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.MirrorWeave;
import com.hollingsworth.arsnouveau.common.block.tile.MirrorWeaveTile;
import com.hollingsworth.arsnouveau.common.event.timed.SkyweaveVisibilityEvent;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SkyBlockTile
extends MirrorWeaveTile
implements ITickable,
IDispellable {
    private boolean showFacade;
    private final boolean[] shouldRender = new boolean[]{true, true, true, true, true, true};
    public int previousLight;

    public SkyBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.SKYWEAVE_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        if (this.showFacade && !this.level.isClientSide) {
            if (((Integer)this.getBlockState().getValue(MirrorWeave.LIGHT_LEVEL)).intValue() != this.mimicState.getLightEmission((BlockGetter)this.level, this.worldPosition)) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(MirrorWeave.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.mimicState.getLightEmission((BlockGetter)this.level, this.worldPosition))));
            }
            return;
        }
        if (!this.level.isClientSide && this.level.isDay() && (Integer)this.getBlockState().getValue(MirrorWeave.LIGHT_LEVEL) != 15) {
            this.previousLight = (Integer)this.getBlockState().getValue(MirrorWeave.LIGHT_LEVEL);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(MirrorWeave.LIGHT_LEVEL, (Comparable)Integer.valueOf(15)));
        }
        if (!this.level.isClientSide && !this.level.isDay() && (Integer)this.getBlockState().getValue(MirrorWeave.LIGHT_LEVEL) != this.previousLight) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(MirrorWeave.LIGHT_LEVEL, (Comparable)Integer.valueOf(this.mimicState.getLightEmission((BlockGetter)this.level, this.worldPosition))));
        }
    }

    public void recalculateFaceVisibility() {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        for (Direction direction : Direction.values()) {
            this.recalculateFaceVisibility(direction);
        }
    }

    public void recalculateFaceVisibility(Direction direction) {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        if (direction == null) {
            this.recalculateFaceVisibility();
            return;
        }
        BlockPos blockingPos = this.getBlockPos().relative(direction);
        BlockState blockingState = this.level.getBlockState(blockingPos);
        if (!blockingState.canOcclude() && !blockingState.is((Block)BlockRegistry.SKY_WEAVE.get())) {
            this.shouldRender[direction.ordinal()] = true;
            return;
        }
        VoxelShape blockingShape = blockingState.getOcclusionShape((BlockGetter)this.level, blockingPos);
        this.shouldRender[direction.ordinal()] = !Shapes.blockOccudes((VoxelShape)Shapes.block(), (VoxelShape)blockingShape, (Direction)direction);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level != null && level.isClientSide) {
            this.recalculateFaceVisibility();
        }
    }

    public void setShowFacade(boolean showFacade) {
        if (this.showFacade == showFacade) {
            return;
        }
        int ticks = 1;
        for (Direction d : Direction.values()) {
            BlockPos offset = this.getBlockPos().relative(d);
            BlockEntity blockEntity = this.level.getBlockEntity(offset);
            if (!(blockEntity instanceof SkyBlockTile)) continue;
            SkyBlockTile neighbor = (SkyBlockTile)blockEntity;
            if (this.showFacade() != neighbor.showFacade()) continue;
            EventQueue.getServerInstance().addEvent(new SkyweaveVisibilityEvent(neighbor, ++ticks, showFacade));
        }
        this.showFacade = showFacade;
        this.recalculateFaceVisibility();
        this.updateBlock();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putBoolean("showFacade", this.showFacade);
        tag.putInt("previousLight", this.previousLight);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.showFacade = pTag.getBoolean("showFacade");
        this.previousLight = pTag.getInt("previousLight");
    }

    public boolean showFacade() {
        return this.showFacade;
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        this.setShowFacade(!this.showFacade());
        return true;
    }

    public boolean shouldRenderFace(@NotNull Direction direction) {
        return this.showFacade || this.shouldRender[direction.ordinal()];
    }
}

