/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.ITickableBlock;
import com.hollingsworth.arsnouveau.common.block.MirrorWeave;
import com.hollingsworth.arsnouveau.common.block.tile.SkyBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkyWeave
extends MirrorWeave
implements ITickableBlock {
    public SkyWeave(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new SkyBlockTile(p_153215_, p_153216_);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        SkyBlockTile sbt;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkyBlockTile && (sbt = (SkyBlockTile)blockEntity).showFacade()) {
            return sbt.mimicState.canOcclude() ? sbt.mimicState.getOcclusionShape(level, pos) : Shapes.empty();
        }
        return super.getOcclusionShape(state, level, pos);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        BlockState newState = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
        if (level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof SkyBlockTile) {
            SkyBlockTile tile = (SkyBlockTile)blockEntity;
            tile.recalculateFaceVisibility(direction);
        }
        return newState;
    }
}

