/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.client.gui.GlyphRecipeTooltip;
import com.hollingsworth.arsnouveau.client.gui.NoShadowTextField;
import com.hollingsworth.arsnouveau.client.gui.SchoolTooltip;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.buttons.GlyphButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.ItemButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.SelectableButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.UnlockGlyphButton;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetScribeRecipe;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import org.joml.Matrix4f;

public class GlyphUnlockMenu
extends BaseBook {
    public List<RecipeHolder<GlyphRecipe>> displayedGlyphs = new ArrayList<RecipeHolder<GlyphRecipe>>();
    public List<RecipeHolder<GlyphRecipe>> allParts = new ArrayList<RecipeHolder<GlyphRecipe>>();
    public int page = 0;
    public PageButton nextButton;
    public PageButton previousButton;
    public List<UnlockGlyphButton> glyphButtons = new ArrayList<UnlockGlyphButton>();
    public NoShadowTextField searchBar;
    public String previousString = "";
    int maxPerPage = 78;
    int tier1Row = 0;
    int tier2Row = 0;
    int tier3Row = 0;
    BlockPos scribesPos;
    Filter filterSelected = Filter.ALL;
    public RecipeHolder<GlyphRecipe> hoveredRecipe;
    public RecipeHolder<GlyphRecipe> selectedRecipe;
    String orderingTitle = "";
    List<ItemButton> itemButtons = new ArrayList<ItemButton>();
    List<SelectableButton> filterButtons = new ArrayList<SelectableButton>();
    SelectableButton all;
    SelectableButton tier1;
    SelectableButton tier2;
    SelectableButton tier3;

    public GlyphUnlockMenu(BlockPos pos) {
        this.allParts = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistry.GLYPH_TYPE.get());
        this.displayedGlyphs = new ArrayList<RecipeHolder<GlyphRecipe>>(this.allParts);
        this.scribesPos = pos;
    }

    public static void open(BlockPos scribePos) {
        Minecraft.getInstance().setScreen((Screen)new GlyphUnlockMenu(scribePos));
    }

    @Override
    public void init() {
        super.init();
        this.orderingTitle = Component.translatable((String)"ars_nouveau.all_glyphs").getString();
        this.searchBar = new NoShadowTextField(this.minecraft.font, this.bookRight - 73, this.bookTop + 2, 54, 12, null, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.search"));
        this.searchBar.setBordered(false);
        this.searchBar.setTextColor(12694931);
        this.searchBar.onClear = val -> {
            this.onSearchChanged("");
            return null;
        };
        if (this.searchBar.getValue().isEmpty()) {
            this.searchBar.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
        }
        this.searchBar.setResponder(val -> this.onSearchChanged((String)val));
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookRight - 71, this.bookBottom - 13, 50, 12, ArsNouveau.prefix("textures/gui/create_icon.png"), this::onSelectClick));
        this.nextButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookRight - 20, this.bookBottom - 10, true, this::onPageIncrease, true));
        this.previousButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookLeft - 5, this.bookBottom - 10, false, this::onPageDec, true));
        this.updateNextPageButtons();
        this.previousButton.active = false;
        this.previousButton.visible = false;
        this.layoutAllGlyphs(0);
        for (ItemButton button : this.itemButtons) {
            this.removeWidget((GuiEventListener)button);
        }
        this.itemButtons = new ArrayList<ItemButton>();
        for (int i = 0; i < 10; ++i) {
            int offset = i >= 5 ? 14 : 0;
            ItemButton cell = new ItemButton(this, this.bookLeft + 19 + 24 * i + offset, this.bookBottom - 47);
            this.addRenderableWidget((GuiEventListener)cell);
            this.itemButtons.add(cell);
        }
        this.all = (SelectableButton)new SelectableButton(this.bookRight - 8, this.bookTop + 22, 0, 0, 23, 20, 23, 20, ArsNouveau.prefix("textures/gui/filter_tab_all.png"), ArsNouveau.prefix("textures/gui/filter_tab_all_selected.png"), b -> this.setFilter(Filter.ALL, (SelectableButton)b, Component.translatable((String)"ars_nouveau.all_glyphs").getString())).withTooltip((Component)Component.translatable((String)"ars_nouveau.all_glyphs"));
        this.all.isSelected = true;
        this.tier1 = (SelectableButton)new SelectableButton(this.bookRight - 8, this.bookTop + 46, 0, 0, 23, 20, 23, 20, ArsNouveau.prefix("textures/gui/filter_tab_tier1.png"), ArsNouveau.prefix("textures/gui/filter_tab_tier1_selected.png"), b -> this.setFilter(Filter.TIER1, (SelectableButton)b, Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{1}).getString())).withTooltip((Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{1}));
        this.tier2 = (SelectableButton)new SelectableButton(this.bookRight - 8, this.bookTop + 70, 0, 0, 23, 20, 23, 20, ArsNouveau.prefix("textures/gui/filter_tab_tier2.png"), ArsNouveau.prefix("textures/gui/filter_tab_tier2_selected.png"), b -> this.setFilter(Filter.TIER2, (SelectableButton)b, Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{2}).getString())).withTooltip((Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{2}));
        this.tier3 = (SelectableButton)new SelectableButton(this.bookRight - 8, this.bookTop + 94, 0, 0, 23, 20, 23, 20, ArsNouveau.prefix("textures/gui/filter_tab_tier3.png"), ArsNouveau.prefix("textures/gui/filter_tab_tier3_selected.png"), b -> this.setFilter(Filter.TIER3, (SelectableButton)b, Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{3}).getString())).withTooltip((Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{3}));
        this.filterButtons = new ArrayList<SelectableButton>();
        this.filterButtons.add(this.all);
        this.filterButtons.add(this.tier2);
        this.filterButtons.add(this.tier1);
        this.filterButtons.add(this.tier3);
        for (SelectableButton button : this.filterButtons) {
            this.addRenderableWidget((GuiEventListener)button);
        }
        this.updateRecipeButtons();
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        SoundManager manager = Minecraft.getInstance().getSoundManager();
        if (pScrollY < 0.0 && this.nextButton.active) {
            this.onPageIncrease((Button)this.nextButton);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        } else if (pScrollY > 0.0 && this.previousButton.active) {
            this.onPageDec((Button)this.previousButton);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
        return true;
    }

    public void setFilter(Filter filter, SelectableButton button, String displayTitle) {
        this.displayedGlyphs = this.allParts;
        for (SelectableButton b : this.filterButtons) {
            b.isSelected = false;
        }
        this.filterSelected = filter;
        button.isSelected = true;
        this.orderingTitle = displayTitle;
        this.onSearchChanged(this.searchBar.value);
        this.resetPageState();
    }

    private void onSelectClick(Button button) {
        if (this.selectedRecipe != null) {
            Networking.sendToServer(new PacketSetScribeRecipe(this.scribesPos, this.selectedRecipe.id()));
            Minecraft.getInstance().setScreen(null);
        }
    }

    public void updateNextPageButtons() {
        if (this.displayedGlyphs.size() < this.maxPerPage) {
            this.nextButton.visible = false;
            this.nextButton.active = false;
        } else {
            this.nextButton.visible = true;
            this.nextButton.active = true;
        }
    }

    public void onSearchChanged(String str) {
        this.previousString = str;
        if (!str.isEmpty()) {
            this.searchBar.setSuggestion("");
            this.displayedGlyphs = new ArrayList<RecipeHolder<GlyphRecipe>>();
            for (RecipeHolder<GlyphRecipe> spellPart : this.allParts) {
                if (!((GlyphRecipe)spellPart.value()).getSpellPart().getLocaleName().toLowerCase().contains(this.searchBar.value.toLowerCase())) continue;
                this.displayedGlyphs.add(spellPart);
            }
            for (Renderable w : this.renderables) {
                AbstractSpellPart part;
                if (!(w instanceof GlyphButton)) continue;
                GlyphButton glyphButton = (GlyphButton)w;
                if (glyphButton.abstractSpellPart.getRegistryName() == null || (part = GlyphRegistry.getSpellpartMap().get(glyphButton.abstractSpellPart.getRegistryName())) == null) continue;
                glyphButton.visible = part.getLocaleName().toLowerCase().contains(this.searchBar.value.toLowerCase());
            }
        } else {
            this.searchBar.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
            this.displayedGlyphs = this.allParts;
            for (Renderable w : this.renderables) {
                if (!(w instanceof GlyphButton)) continue;
                ((GlyphButton)w).visible = true;
            }
        }
        this.displayedGlyphs = this.applyFilter(this.displayedGlyphs);
        this.resetPageState();
    }

    public void resetPageState() {
        this.updateNextPageButtons();
        this.page = 0;
        this.previousButton.active = false;
        this.previousButton.visible = false;
        this.layoutAllGlyphs(this.page);
    }

    public void layoutAllGlyphs(int page) {
        this.clearButtons(this.glyphButtons);
        this.tier1Row = -1;
        this.tier2Row = -1;
        this.tier3Row = -1;
        int PER_ROW = 6;
        int MAX_ROWS = 6;
        boolean nextPage = false;
        int xStart = nextPage ? this.bookLeft + 154 : this.bookLeft + 20;
        int adjustedRowsPlaced = 0;
        int yStart = this.bookTop + 20;
        List<Object> sorted = new ArrayList<RecipeHolder<GlyphRecipe>>(this.displayedGlyphs);
        sorted.sort(CreativeTabRegistry.COMPARE_TIER_THEN_NAME);
        sorted = sorted.subList(this.maxPerPage * page, Math.min(sorted.size(), this.maxPerPage * (page + 1)));
        int adjustedXPlaced = 0;
        this.tier1Row = 0;
        ++adjustedRowsPlaced;
        for (int i = 0; i < sorted.size(); ++i) {
            RecipeHolder holder = (RecipeHolder)sorted.get(i);
            AbstractSpellPart spellPart = ((GlyphRecipe)holder.value()).getSpellPart();
            if (adjustedXPlaced >= 6) {
                ++adjustedRowsPlaced;
                adjustedXPlaced = 0;
            }
            if (adjustedRowsPlaced > 6) {
                if (nextPage) break;
                nextPage = true;
                adjustedXPlaced = 0;
                adjustedRowsPlaced = 0;
            }
            int xOffset = 20 * (adjustedXPlaced % 6) + (nextPage ? 134 : 0);
            int yPlace = adjustedRowsPlaced * 18 + yStart;
            UnlockGlyphButton cell = new UnlockGlyphButton(xStart + xOffset, yPlace, false, (RecipeHolder<GlyphRecipe>)holder, this::onGlyphClick);
            ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)Minecraft.getInstance().player);
            if (cap != null && (cap.knowsGlyph(spellPart) || GlyphRegistry.getDefaultStartingSpells().contains(spellPart))) {
                cell.playerKnows = true;
            }
            this.addRenderableWidget((GuiEventListener)cell);
            this.glyphButtons.add(cell);
            ++adjustedXPlaced;
        }
    }

    public List<RecipeHolder<GlyphRecipe>> applyFilter(List<RecipeHolder<GlyphRecipe>> spellParts) {
        if (this.filterSelected == Filter.ALL) {
            return spellParts;
        }
        if (this.filterSelected == Filter.TIER1) {
            return spellParts.stream().filter(a -> ((GlyphRecipe)a.value()).getSpellPart().getConfigTier().value == 1).collect(Collectors.toList());
        }
        if (this.filterSelected == Filter.TIER2) {
            return spellParts.stream().filter(a -> ((GlyphRecipe)a.value()).getSpellPart().getConfigTier().value == 2).collect(Collectors.toList());
        }
        return spellParts.stream().filter(a -> ((GlyphRecipe)a.value()).getSpellPart().getConfigTier().value == 3).collect(Collectors.toList());
    }

    public void onGlyphClick(Button button) {
        for (UnlockGlyphButton button1 : this.glyphButtons) {
            button1.selected = false;
        }
        if (button instanceof UnlockGlyphButton) {
            UnlockGlyphButton unlockGlyphButton = (UnlockGlyphButton)button;
            this.selectedRecipe = unlockGlyphButton.recipe;
            unlockGlyphButton.selected = true;
            this.updateRecipeButtons();
        }
    }

    public void updateRecipeButtons() {
        if (this.selectedRecipe == null) {
            return;
        }
        for (ItemButton itemButton : this.itemButtons) {
            itemButton.visible = false;
            itemButton.ingredient = Ingredient.EMPTY;
        }
        for (int i = 0; i < ((GlyphRecipe)this.selectedRecipe.value()).inputs.size() && i <= this.itemButtons.size(); ++i) {
            this.itemButtons.get((int)i).visible = true;
            this.itemButtons.get((int)i).ingredient = ((GlyphRecipe)this.selectedRecipe.value()).inputs.get(i);
        }
    }

    public void onPageIncrease(Button button) {
        ++this.page;
        if (this.displayedGlyphs.size() < this.maxPerPage * (this.page + 1)) {
            this.nextButton.visible = false;
            this.nextButton.active = false;
        }
        this.previousButton.active = true;
        this.previousButton.visible = true;
        this.layoutAllGlyphs(this.page);
    }

    public void onPageDec(Button button) {
        --this.page;
        if (this.page == 0) {
            this.previousButton.active = false;
            this.previousButton.visible = false;
        }
        if (this.displayedGlyphs.size() > this.maxPerPage * (this.page + 1)) {
            this.nextButton.visible = true;
            this.nextButton.active = true;
        }
        this.layoutAllGlyphs(this.page);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.hoveredRecipe = null;
        Renderable renderable = this.getHoveredRenderable(mouseX, mouseY);
        if (renderable instanceof UnlockGlyphButton) {
            UnlockGlyphButton button = (UnlockGlyphButton)renderable;
            this.hoveredRecipe = button.recipe;
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(this.font, this.orderingTitle, this.tier1Row > 7 ? 154 : 20, 5 + 18 * (this.tier1Row + (this.tier1Row == 1 ? 0 : 1)), -8355712, false);
        graphics.blit(ArsNouveau.prefix("textures/gui/create_paper.png"), 216, 179, 0.0f, 0.0f, 56, 15, 56, 15);
        graphics.blit(ArsNouveau.prefix("textures/gui/search_paper.png"), 203, 0, 0.0f, 0.0f, 72, 15, 72, 15);
        graphics.drawString(this.font, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.select"), 233, 183, -8355712, false);
    }

    @Override
    public void drawTooltip(GuiGraphics stack, int mouseX, int mouseY) {
        Renderable renderable;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        super.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (this.hoveredRecipe != null) {
            MutableComponent component = Component.translatable((String)"ars_nouveau.levels_required", (Object[])new Object[]{ScribesTile.getLevelsFromExp(((GlyphRecipe)this.hoveredRecipe.value()).exp)}).withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
            tooltip.add((Component)component);
        }
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>(ClientHooks.gatherTooltipComponents((ItemStack)ItemStack.EMPTY, tooltip, (int)mouseX, (int)this.width, (int)this.height, (Font)this.font));
        if (this.hoveredRecipe != null) {
            components.add(new GlyphRecipeTooltip(((GlyphRecipe)this.hoveredRecipe.value()).inputs));
        }
        if ((renderable = this.getHoveredRenderable(mouseX, mouseY)) instanceof UnlockGlyphButton) {
            UnlockGlyphButton button = (UnlockGlyphButton)renderable;
            if (!button.spellPart.spellSchools.isEmpty()) {
                components.add(1, new SchoolTooltip.SchoolTooltipRenderer(button.spellPart));
            }
        }
        this.renderTooltipInternal(stack, components, mouseX, mouseY);
    }

    public void renderTooltipInternal(GuiGraphics graphics, List<ClientTooltipComponent> pClientTooltipComponents, int pMouseX, int pMouseY) {
        if (!pClientTooltipComponents.isEmpty()) {
            PoseStack pPoseStack = graphics.pose();
            RenderTooltipEvent.Pre preEvent = ClientHooks.onRenderTooltipPre((ItemStack)ItemStack.EMPTY, (GuiGraphics)graphics, (int)pMouseX, (int)pMouseY, (int)this.width, (int)this.height, pClientTooltipComponents, (Font)this.font, (ClientTooltipPositioner)DefaultTooltipPositioner.INSTANCE);
            if (preEvent.isCanceled()) {
                return;
            }
            int i = 0;
            int j = pClientTooltipComponents.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clienttooltipcomponent : pClientTooltipComponents) {
                int k = clienttooltipcomponent.getWidth(preEvent.getFont());
                if (k > i) {
                    i = k;
                }
                j += clienttooltipcomponent.getHeight();
            }
            int j2 = preEvent.getX() + 12;
            int k2 = preEvent.getY() - 12;
            if (j2 + i > this.width) {
                j2 -= 28 + i;
            }
            if (k2 + j + 6 > this.height) {
                k2 = this.height - j - 6;
            }
            pPoseStack.pushPose();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f matrix4f = pPoseStack.last().pose();
            RenderTooltipEvent.Color colorEvent = ClientHooks.onRenderTooltipColor((ItemStack)ItemStack.EMPTY, (GuiGraphics)graphics, (int)j2, (int)k2, (Font)preEvent.getFont(), pClientTooltipComponents);
            graphics.fillGradient(j2 - 3, k2 - 4, j2 + i + 3, k2 - 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundStart());
            graphics.fillGradient(j2 - 3, k2 + j + 3, j2 + i + 3, k2 + j + 4, 400, colorEvent.getBackgroundEnd(), colorEvent.getBackgroundEnd());
            graphics.fillGradient(j2 - 3, k2 - 3, j2 + i + 3, k2 + j + 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
            graphics.fillGradient(j2 - 4, k2 - 3, j2 - 3, k2 + j + 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
            graphics.fillGradient(j2 + i + 3, k2 - 3, j2 + i + 4, k2 + j + 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
            graphics.fillGradient(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + j + 3 - 1, 400, colorEvent.getBorderStart(), colorEvent.getBorderEnd());
            graphics.fillGradient(j2 + i + 2, k2 - 3 + 1, j2 + i + 3, k2 + j + 3 - 1, 400, colorEvent.getBorderStart(), colorEvent.getBorderEnd());
            graphics.fillGradient(j2 - 3, k2 - 3, j2 + i + 3, k2 - 3 + 1, 400, colorEvent.getBorderStart(), colorEvent.getBorderStart());
            graphics.fillGradient(j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 3, 400, colorEvent.getBorderEnd(), colorEvent.getBorderEnd());
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            MultiBufferSource.BufferSource multibuffersource$buffersource = graphics.bufferSource();
            pPoseStack.translate(0.0, 0.0, 400.0);
            int l1 = k2;
            for (int i2 = 0; i2 < pClientTooltipComponents.size(); ++i2) {
                ClientTooltipComponent clienttooltipcomponent1 = pClientTooltipComponents.get(i2);
                clienttooltipcomponent1.renderText(preEvent.getFont(), j2, l1, matrix4f, multibuffersource$buffersource);
                l1 += clienttooltipcomponent1.getHeight() + (i2 == 0 ? 2 : 0);
            }
            l1 = k2;
            pPoseStack.translate(0.0f, 0.0f, 600.0f);
            for (int l2 = 0; l2 < pClientTooltipComponents.size(); ++l2) {
                ClientTooltipComponent clienttooltipcomponent2 = pClientTooltipComponents.get(l2);
                clienttooltipcomponent2.renderImage(preEvent.getFont(), j2, l1, graphics);
                l1 += clienttooltipcomponent2.getHeight() + (l2 == 0 ? 2 : 0);
            }
            pPoseStack.popPose();
        }
    }

    static enum Filter {
        ALL,
        TIER1,
        TIER2,
        TIER3;

    }
}

