/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.events;

import com.hollingsworth.arsnouveau.api.registry.DynamicTooltipRegistry;
import com.hollingsworth.arsnouveau.client.gui.PatchouliTooltipEvent;
import com.hollingsworth.arsnouveau.client.gui.SchoolTooltip;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.renderer.world.PantomimeRenderer;
import com.hollingsworth.arsnouveau.common.block.ArchwoodChest;
import com.hollingsworth.arsnouveau.common.block.tile.ArchwoodChestTile;
import com.hollingsworth.arsnouveau.common.block.tile.GhostWeaveTile;
import com.hollingsworth.arsnouveau.common.block.tile.SkyBlockTile;
import com.hollingsworth.arsnouveau.common.items.data.ReactiveCasterData;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau")
public class ClientEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderWorldLastEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            PantomimeRenderer.renderOutline(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public static void TooltipEvent(RenderTooltipEvent.Pre e) {
        try {
            PatchouliTooltipEvent.onTooltip(e.getGraphics().pose(), e.getItemStack(), e.getX(), e.getY());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void addComponents(RenderTooltipEvent.GatherComponents event) {
        ReactiveCasterData caster;
        if (!Screen.hasShiftDown() && event.getItemStack().isEnchanted() && event.getItemStack().has(DataComponentRegistry.REACTIVE_CASTER) && (caster = (ReactiveCasterData)event.getItemStack().get(DataComponentRegistry.REACTIVE_CASTER)) != null && caster.getSpell().isValid()) {
            event.getTooltipElements().add(Either.right((Object)new SpellTooltip(caster)));
        }
    }

    @SubscribeEvent
    public static void highlightBlockEvent(RenderHighlightEvent.Block e) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            GhostWeaveTile ghostTile;
            SkyBlockTile skyTile;
            BlockEntity be = level.getBlockEntity(e.getTarget().getBlockPos());
            if (be instanceof SkyBlockTile && !(skyTile = (SkyBlockTile)be).showFacade()) {
                e.setCanceled(true);
            }
            if (be instanceof GhostWeaveTile && (ghostTile = (GhostWeaveTile)be).isInvisible()) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiLayerEvent.Pre event) {
        if (Minecraft.getInstance().screen instanceof GuiRadialMenu && event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        DynamicTooltipRegistry.appendTooltips(stack, event.getContext(), event.getToolTip()::add, event.getFlags());
    }

    public static Component localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            Component component;
            ComponentContents componentContents;
            Object parameter = params[i];
            if (!(parameter instanceof Component) || !((componentContents = (component = (Component)parameter).getContents()) instanceof TranslatableContents)) continue;
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            params[i] = ClientEvents.localize(translatableContents.getKey(), translatableContents.getArgs());
        }
        return Component.translatable((String)key, (Object[])params);
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="ars_nouveau", bus=EventBusSubscriber.Bus.MOD)
    static class ClientModEvents {
        ClientModEvents() {
        }

        @SubscribeEvent
        public static void registerTooltipFactory(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(SpellTooltip.class, SpellTooltip.SpellTooltipRenderer::new);
            event.register(SchoolTooltip.class, SchoolTooltip.SchoolTooltipRenderer::new);
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerItem(new IClientItemExtensions(){

                @NotNull
                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    final Minecraft mc = Minecraft.getInstance();
                    return new BlockEntityWithoutLevelRenderer(this, mc.getBlockEntityRenderDispatcher(), mc.getEntityModels()){
                        private final BlockEntity tile;
                        {
                            super(arg0, arg1);
                            this.tile = new ArchwoodChestTile(BlockPos.ZERO, ((ArchwoodChest)((Object)BlockRegistry.ARCHWOOD_CHEST.get())).defaultBlockState());
                        }

                        public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext transformType, @NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int x, int y) {
                            mc.getBlockEntityRenderDispatcher().renderItem(this.tile, pose, buffer, x, y);
                        }
                    };
                }
            }, new Item[]{((ArchwoodChest)((Object)BlockRegistry.ARCHWOOD_CHEST.get())).asItem()});
        }
    }
}

