/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.emi;

import com.hollingsworth.arsnouveau.client.emi.EmiArsNouveauPlugin;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class EmiCrushRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final CrushRecipe recipe;

    public EmiCrushRecipe(ResourceLocation id, CrushRecipe recipe) {
        this.id = id;
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return EmiArsNouveauPlugin.CRUSH_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of((Ingredient)this.recipe.input()));
    }

    public List<EmiStack> getOutputs() {
        return this.recipe.outputs().stream().map(CrushRecipe.CrushOutput::stack).map(EmiStack::of).toList();
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 86;
    }

    public void addWidgets(WidgetHolder widgets) {
        CrushRecipe.CrushOutput output;
        int i;
        widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.input()), 4, this.getDisplayHeight() / 2 - 10);
        for (i = 0; i < this.recipe.outputs().size(); ++i) {
            output = this.recipe.outputs().get(i);
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)output.stack()), 53, 5 + 16 * i).recipeContext((EmiRecipe)this);
        }
        widgets.addFillingArrow(24, this.getDisplayHeight() / 2 - 10, 2000);
        for (i = 0; i < this.recipe.outputs().size(); ++i) {
            output = this.recipe.outputs().get(i);
            widgets.addText((Component)Component.literal((String)(Math.round(100.0f * output.chance() - 0.5f) + "%")), 97, 11 + 17 * i, 10, false);
            if (output.maxRange() <= 1) continue;
            widgets.addText((Component)Component.literal((String)("1-" + output.maxRange())), 75, 11 + 17 * i, 10, false);
        }
    }
}

