/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.emi;

import com.hollingsworth.arsnouveau.api.registry.AlakarkinosConversionRegistry;
import com.hollingsworth.arsnouveau.client.emi.EmiArsNouveauPlugin;
import com.hollingsworth.arsnouveau.common.crafting.recipes.AlakarkinosRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class EmiAlakarkinosRecipe
implements EmiRecipe {
    public static float ITEMS_PER_ROW = 7.0f;
    private final ResourceLocation id;
    private final AlakarkinosRecipe recipe;

    public EmiAlakarkinosRecipe(ResourceLocation id, AlakarkinosRecipe recipe) {
        this.id = id;
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return EmiArsNouveauPlugin.ALAKARKINOS_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((ItemLike)this.recipe.input()));
    }

    public List<EmiStack> getOutputs() {
        if (this.recipe.drops().isPresent()) {
            ArrayList<EmiStack> out = new ArrayList<EmiStack>();
            for (AlakarkinosConversionRegistry.LootDrop drop : this.recipe.drops().get().list()) {
                out.add(EmiStack.of((ItemStack)drop.item()));
            }
            return out;
        }
        return List.of();
    }

    public int getDisplayWidth() {
        return 126;
    }

    public int getDisplayHeight() {
        return ((int)Math.floor((float)this.getOutputs().size() / ITEMS_PER_ROW) + 1) * 18 + 9 + 22;
    }

    public void addWidgets(WidgetHolder widgets) {
        String prepared = this.recipe.table().location().getPath().replace("archaeology/", "").replaceAll("_[0-9]", "").replaceAll("_", " ").toLowerCase(Locale.ROOT);
        String name = WordUtils.capitalizeFully((String)prepared);
        widgets.addText((Component)Component.literal((String)name), 22, 4, -16777216, false);
        DecimalFormat df = new DecimalFormat("##.##%");
        Optional<AlakarkinosConversionRegistry.LootDrops> lootDrops = this.recipe.drops();
        if (lootDrops.isEmpty()) {
            return;
        }
        AlakarkinosConversionRegistry.LootDrops drops = lootDrops.get();
        String recipeChance = df.format((float)this.recipe.weight() / (float)drops.weight());
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)this.recipe.input()), 0, 0).appendTooltip((Component)Component.translatable((String)"ars_nouveau.alakarkinos_recipe.chance", (Object[])new Object[]{recipeChance}));
        int yOffset = 9;
        int i = (int)ITEMS_PER_ROW;
        for (AlakarkinosConversionRegistry.LootDrop drop : drops.list()) {
            int row = (int)Math.floor((float)i / ITEMS_PER_ROW);
            int x = (int)(((float)i - (float)row * ITEMS_PER_ROW) * 18.0f);
            int y = row * 18 + yOffset;
            String chance = df.format(drop.chance());
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)drop.item()), x, y).appendTooltip((Component)Component.translatable((String)"ars_nouveau.alakarkinos_recipe.chance", (Object[])new Object[]{chance})).recipeContext((EmiRecipe)this);
            ++i;
        }
    }
}

