/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.container;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.client.container.IAutoFillTerminal;
import com.hollingsworth.arsnouveau.client.container.StorageTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.common.block.tile.CraftingLecternTile;
import com.hollingsworth.arsnouveau.common.block.tile.StorageLecternTile;
import com.hollingsworth.arsnouveau.setup.registry.MenuRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class CraftingTerminalMenu
extends StorageTerminalMenu
implements IAutoFillTerminal {
    protected List<SlotCrafting> craftSlotList = new ArrayList<SlotCrafting>();
    private final CraftingContainer craftMatrix;
    private final ResultContainer craftResult;
    private ActiveResultSlot craftingResultSlot;
    private final List<ContainerListener> listeners = Lists.newArrayList();

    public void addSlotListener(ContainerListener listener) {
        super.addSlotListener(listener);
        this.listeners.add(listener);
    }

    public void removeSlotListener(ContainerListener listener) {
        super.removeSlotListener(listener);
        this.listeners.remove(listener);
    }

    public CraftingTerminalMenu(int id, Inventory inv, CraftingLecternTile te) {
        super((MenuType)MenuRegistry.STORAGE.get(), id, inv, te);
        this.craftMatrix = te.getCraftingInv(inv.player);
        this.craftResult = te.getCraftResult(inv.player);
        this.init();
        this.addPlayerSlots(inv, 13, 157);
        te.registerCrafting(this);
    }

    public CraftingTerminalMenu(int id, Inventory inv) {
        super((MenuType)MenuRegistry.STORAGE.get(), id, inv);
        this.craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
        this.craftResult = new ResultContainer();
        this.init();
        this.addPlayerSlots(inv, 13, 157);
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        StorageLecternTile storageLecternTile = this.te;
        if (storageLecternTile instanceof CraftingLecternTile) {
            CraftingLecternTile craftingLecternTile = (CraftingLecternTile)storageLecternTile;
            craftingLecternTile.unregisterCrafting(this);
        }
    }

    private void init() {
        int x = -4;
        int y = 70;
        this.craftingResultSlot = new ActiveResultSlot(this.pinv.player, this.craftMatrix, (Container)this.craftResult, 0, x + 130, y + 37){

            public void onTake(Player thePlayer, ItemStack stack) {
                if (thePlayer.level.isClientSide) {
                    return;
                }
                this.checkTakeAchievements(stack);
                if (!CraftingTerminalMenu.this.pinv.player.getCommandSenderWorld().isClientSide) {
                    ((CraftingLecternTile)CraftingTerminalMenu.this.te).craft(thePlayer, (String)CraftingTerminalMenu.this.tabs.get(thePlayer.getUUID()));
                }
            }
        };
        this.addSlot((Slot)this.craftingResultSlot);
        if (this.craftMatrix != null) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    SlotCrafting slot = new SlotCrafting((Container)this.craftMatrix, j + i * 3, x + 36 + j * 18, 89 + i * 18);
                    this.addSlot(slot);
                    this.craftSlotList.add(slot);
                }
            }
        }
    }

    @Override
    public void addStorageSlots(boolean expanded) {
        super.addStorageSlots(expanded);
        if (this.craftSlotList != null) {
            for (SlotCrafting slot : this.craftSlotList) {
                slot.active = !expanded;
            }
            this.craftingResultSlot.active = !expanded;
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.craftResult && super.canTakeItemForPickAll(stack, slotIn);
    }

    @Override
    public ItemStack shiftClickItems(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                if (this.te == null) {
                    return ItemStack.EMPTY;
                }
                ((CraftingLecternTile)this.te).craftShift(playerIn, (String)this.tabs.get(playerIn.getUUID()));
                if (!playerIn.level.isClientSide) {
                    this.broadcastChanges();
                }
                return ItemStack.EMPTY;
            }
            if (index > 0 && index < 10) {
                if (this.te == null) {
                    return ItemStack.EMPTY;
                }
                ItemStack stack = this.te.pushStack(itemstack, (String)this.tabs.get(playerIn.getUUID()));
                slot.set(stack);
                if (!playerIn.level.isClientSide) {
                    this.broadcastChanges();
                }
            }
            slot.onTake(playerIn, itemstack1);
        }
        return ItemStack.EMPTY;
    }

    public void onCraftMatrixChanged() {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (!(slot instanceof SlotCrafting) && slot != this.craftingResultSlot) continue;
            for (ContainerListener listener : this.listeners) {
                if (!(listener instanceof ServerPlayer)) continue;
                ((ServerPlayer)listener).connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), i, slot.getItem()));
            }
        }
    }

    public boolean clickMenuButton(Player playerIn, int id) {
        if (this.te != null && id == 0) {
            ((CraftingLecternTile)this.te).clear(playerIn, (String)this.tabs.get(playerIn.getUUID()));
        } else {
            super.clickMenuButton(playerIn, id);
        }
        return false;
    }

    @Override
    public void fillCraftSlotsStackedContents(StackedContents itemHelperIn) {
        this.craftMatrix.fillStackedContents(itemHelperIn);
    }

    @Override
    public void clearCraftingContent() {
        this.craftMatrix.clearContent();
        this.craftResult.clearContent();
    }

    @Override
    public boolean recipeMatches(RecipeHolder pRecipe) {
        return pRecipe.value().matches((RecipeInput)this.craftMatrix.asCraftInput(), this.pinv.player.level);
    }

    @Override
    public int getResultSlotIndex() {
        return 0;
    }

    @Override
    public int getGridWidth() {
        return this.craftMatrix.getWidth();
    }

    @Override
    public int getGridHeight() {
        return this.craftMatrix.getHeight();
    }

    @Override
    public int getSize() {
        return 10;
    }

    public List<RecipeBookCategories> getRecipeBookCategories() {
        return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.CRAFTING_SEARCH, RecipeBookCategories.CRAFTING_EQUIPMENT, RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, RecipeBookCategories.CRAFTING_MISC, RecipeBookCategories.CRAFTING_REDSTONE});
    }

    public void handlePlacement(boolean pPlaceAll, RecipeHolder<?> pRecipe, ServerPlayer pPlayer) {
    }

    @Override
    public void receive(ServerPlayer sender, HolderLookup.Provider reg, CompoundTag message) {
        super.receive(sender, reg, message);
        if (message.contains("i")) {
            ItemStack[][] stacks = new ItemStack[9][];
            ListTag list = message.getList("i", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbttagcompound = list.getCompound(i);
                byte slot = nbttagcompound.getByte("s");
                int l = nbttagcompound.getByte("l");
                stacks[slot] = new ItemStack[l];
                for (int j = 0; j < l; ++j) {
                    CompoundTag tag = nbttagcompound.getCompound("i" + j);
                    stacks[slot][j] = ItemStack.parseOptional((HolderLookup.Provider)reg, (CompoundTag)tag);
                }
            }
            ((CraftingLecternTile)this.te).transferToGrid(this.pinv.player, stacks, (String)this.tabs.get(sender.getUUID()));
        }
    }

    @Override
    public List<StoredItemStack> getStoredItems() {
        return this.itemList;
    }

    public static class ActiveResultSlot
    extends ResultSlot {
        public boolean active = true;

        public ActiveResultSlot(Player pPlayer, CraftingContainer pCraftSlots, Container pContainer, int pSlot, int pXPosition, int pYPosition) {
            super(pPlayer, pCraftSlots, pContainer, pSlot, pXPosition, pYPosition);
        }

        public boolean isActive() {
            return this.active;
        }
    }

    public static class SlotCrafting
    extends Slot {
        public boolean active = true;

        public SlotCrafting(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean isActive() {
            return super.isActive() && this.active;
        }
    }

    public class TerminalRecipeItemHelper
    extends StackedContents {
        public void clear() {
            super.clear();
            CraftingTerminalMenu.this.itemList.forEach(e -> this.accountSimpleStack(e.getActualStack()));
        }
    }
}

