/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class PortalFrameTester {
    protected Predicate<BlockState> VALID_FRAME = null;
    protected int foundPortalBlocks;
    public BlockPos lowerCorner;
    protected Level world;

    public abstract PortalFrameTester init(Level var1, BlockPos var2, Direction.Axis var3, Predicate<BlockState> var4);

    public abstract Optional<PortalFrameTester> getOrEmpty(Level var1, BlockPos var2, Predicate<PortalFrameTester> var3, Direction.Axis var4, Predicate<BlockState> var5);

    public abstract boolean isValidFrame();

    public abstract void lightPortal(Block var1);

    protected BlockPos getLowerCorner(BlockPos blockPos, Direction.Axis axis1, Direction.Axis axis2) {
        if (!PortalFrameTester.validStateInsidePortal(this.world.getBlockState(blockPos))) {
            return null;
        }
        int offsetX = 1;
        while (PortalFrameTester.validStateInsidePortal(this.world.getBlockState(blockPos.relative(axis1, -offsetX)))) {
            if (++offsetX <= 20) continue;
            return null;
        }
        blockPos = blockPos.relative(axis1, -(offsetX - 1));
        int offsetY = 1;
        while (PortalFrameTester.validStateInsidePortal(this.world.getBlockState(blockPos.relative(axis2, -offsetY)))) {
            if (++offsetY <= 20) continue;
            return null;
        }
        return blockPos.relative(axis2, -(offsetY - 1));
    }

    protected int getSize(Direction.Axis axis, int minSize, int maxSize) {
        for (int i = 1; i <= maxSize; ++i) {
            BlockState blockState = this.world.getBlockState(this.lowerCorner.relative(axis, i));
            if (PortalFrameTester.validStateInsidePortal(blockState)) continue;
            if (!this.VALID_FRAME.test(blockState)) break;
            return i >= minSize ? i : 0;
        }
        return 0;
    }

    protected boolean checkForValidFrame(Direction.Axis axis1, Direction.Axis axis2, int size1, int size2) {
        int i;
        BlockPos.MutableBlockPos checkPos = this.lowerCorner.mutable();
        for (i = 0; i < size1; ++i) {
            if (!this.VALID_FRAME.test(this.world.getBlockState(checkPos.relative(axis2, -1))) || !this.VALID_FRAME.test(this.world.getBlockState(checkPos.relative(axis2, size2)))) {
                return false;
            }
            checkPos = checkPos.relative(axis1, 1);
        }
        checkPos = this.lowerCorner.mutable();
        for (i = 0; i < size2; ++i) {
            if (!this.VALID_FRAME.test(this.world.getBlockState(checkPos.relative(axis1, -1))) || !this.VALID_FRAME.test(this.world.getBlockState(checkPos.relative(axis1, size1)))) {
                return false;
            }
            checkPos = checkPos.relative(axis2, 1);
        }
        return true;
    }

    protected void countExistingPortalBlocks(Direction.Axis axis1, Direction.Axis axis2, int size1, int size2) {
        for (int i = 0; i < size1; ++i) {
            for (int j = 0; j < size2; ++j) {
                if (!(this.world.getBlockState(this.lowerCorner.relative(axis1, i).relative(axis2, j)).getBlock() instanceof PortalBlock)) continue;
                ++this.foundPortalBlocks;
            }
        }
    }

    public static boolean validStateInsidePortal(BlockState blockState) {
        return blockState.isAir() || blockState.canBeReplaced() || blockState.getBlock() instanceof PortalBlock;
    }
}

