/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item;

import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IWandable {
    default public void onFinishedConnectionFirst(@Nullable GlobalPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        ResourceKey<Level> dim = this.getStoredDimension(storedPos, storedEntity);
        if (dim == null) {
            return;
        }
        if (playerEntity.level.dimension().equals(dim)) {
            this.onFinishedConnectionFirst(storedPos != null ? storedPos.pos() : null, storedEntity, playerEntity);
        }
    }

    default public void onFinishedConnectionLast(@Nullable GlobalPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        ResourceKey<Level> dim = this.getStoredDimension(storedPos, storedEntity);
        if (dim == null) {
            return;
        }
        if (playerEntity.level.dimension().equals(dim)) {
            this.onFinishedConnectionLast(storedPos != null ? storedPos.pos() : null, storedEntity, playerEntity);
        }
    }

    @Deprecated
    default public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
    }

    @Deprecated
    default public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
    }

    default public void onFinishedConnectionFirst(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        ResourceKey<Level> dim = this.getStoredDimension(storedPos, storedEntity);
        if (dim == null) {
            return;
        }
        if (playerEntity.level.dimension().equals(dim)) {
            this.onFinishedConnectionFirst(storedPos != null ? storedPos.pos() : null, face, storedEntity, playerEntity);
        }
    }

    default public void onFinishedConnectionLast(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        ResourceKey<Level> dim = this.getStoredDimension(storedPos, storedEntity);
        if (dim == null) {
            return;
        }
        if (playerEntity.level.dimension().equals(dim)) {
            this.onFinishedConnectionLast(storedPos != null ? storedPos.pos() : null, face, storedEntity, playerEntity);
        }
    }

    @Deprecated
    default public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        this.onFinishedConnectionFirst(storedPos, storedEntity, playerEntity);
    }

    @Deprecated
    default public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        this.onFinishedConnectionLast(storedPos, storedEntity, playerEntity);
    }

    default public void onWanded(Player playerEntity) {
    }

    default public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        return list;
    }

    private ResourceKey<Level> getStoredDimension(@Nullable GlobalPos storedPos, @Nullable LivingEntity storedEntity) {
        if (storedPos != null) {
            return storedPos.dimension();
        }
        if (storedEntity != null) {
            return storedEntity.level.dimension();
        }
        return null;
    }
}

