/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.builder;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.documentation.DocCategory;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.TextEntry;
import com.hollingsworth.arsnouveau.api.documentation.search.ConnectedSearch;
import com.hollingsworth.arsnouveau.api.documentation.search.Search;
import com.hollingsworth.arsnouveau.setup.registry.Documentation;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DocEntryBuilder {
    public List<SinglePageCtor> pages = new ArrayList<SinglePageCtor>();
    public int textCounter;
    public String textKey;
    public int sortNum = 100;
    public DocCategory category;
    public ItemStack displayItem;
    public String titleKey;
    public ResourceLocation entryId;
    public Component title;
    public List<ConnectedSearch> connectedSearches = new ArrayList<ConnectedSearch>();

    public DocEntryBuilder(DocCategory category, String name) {
        this(category, name, ArsNouveau.prefix(name));
    }

    public DocEntryBuilder(DocCategory category, String name, ResourceLocation entryId) {
        this.titleKey = name.contains(".") ? name : "ars_nouveau.page." + name;
        this.textKey = name;
        this.title = Component.translatable((String)this.titleKey);
        this.category = category;
        this.displayItem = ItemStack.EMPTY;
        this.entryId = entryId;
    }

    public DocEntryBuilder(DocCategory category, ItemLike itemLike) {
        this.category = category;
        this.titleKey = itemLike.asItem().getDescriptionId();
        this.textKey = RegistryHelper.getRegistryName(itemLike.asItem()).getPath();
        this.displayItem = itemLike.asItem().getDefaultInstance();
        this.entryId = RegistryHelper.getRegistryName(itemLike.asItem());
        this.title = Component.translatable((String)this.titleKey);
    }

    public DocEntryBuilder withName(String path) {
        this.textKey = path;
        this.titleKey = path;
        this.title = Component.translatable((String)this.titleKey);
        return this;
    }

    public DocEntryBuilder withSortNum(int num) {
        this.sortNum = num;
        return this;
    }

    public DocEntryBuilder withPage(SinglePageCtor page) {
        this.pages.add(page);
        return this;
    }

    public DocEntryBuilder withPage(List<SinglePageCtor> page) {
        this.pages.addAll(page);
        return this;
    }

    public DocEntryBuilder withIcon(ItemLike item) {
        this.displayItem = item.asItem().getDefaultInstance();
        return this;
    }

    public DocEntryBuilder withCategory(DocCategory path) {
        this.category = path;
        return this;
    }

    public DocEntryBuilder withIntroPage() {
        return this.withIntroPage(this.textKey);
    }

    public DocEntryBuilder withIntroPage(String id) {
        ++this.textCounter;
        this.pages.add(TextEntry.create((Component)Component.translatable((String)("ars_nouveau.page" + this.textCounter + "." + id)), (Component)Component.translatable((String)this.titleKey), this.displayItem));
        return this;
    }

    public DocEntryBuilder withTextPage(String contents) {
        this.pages.add(TextEntry.create((Component)Component.translatable((String)contents)));
        return this;
    }

    public DocEntryBuilder withLocalizedText(String id) {
        ++this.textCounter;
        return this.withTextPage("ars_nouveau.page" + this.textCounter + "." + id);
    }

    public DocEntryBuilder withLocalizedText() {
        return this.withLocalizedText(this.textKey);
    }

    public DocEntryBuilder withLocalizedText(ItemLike itemLike) {
        ++this.textCounter;
        this.pages.add(TextEntry.create((Component)Component.translatable((String)("ars_nouveau.page" + this.textCounter + "." + this.textKey)), itemLike.asItem().getDescription(), itemLike.asItem().getDefaultInstance()));
        return this;
    }

    public DocEntryBuilder withCraftingPages(String resourceLocation, ItemLike outputStack) {
        return this.withCraftingPages(ResourceLocation.tryParse((String)resourceLocation), outputStack);
    }

    public DocEntryBuilder withCraftingPages(ResourceLocation resourceLocation, @Nullable ItemLike outputStack) {
        List<SinglePageCtor> craftingPages = Documentation.getRecipePages(resourceLocation);
        this.withPage(Documentation.getRecipePages(resourceLocation));
        if (!craftingPages.isEmpty() && outputStack != null && !this.displayItem.is(outputStack.asItem())) {
            this.addConnectedSearch(outputStack.asItem().getDefaultInstance());
        }
        return this;
    }

    public DocEntryBuilder withCraftingPages(ItemLike itemLike) {
        List<SinglePageCtor> craftingPages = Documentation.getRecipePages(RegistryHelper.getRegistryName(itemLike.asItem()));
        this.withPage(craftingPages);
        if (!craftingPages.isEmpty() && !this.displayItem.is(itemLike.asItem())) {
            ItemStack stack = itemLike.asItem().getDefaultInstance();
            this.addConnectedSearch(stack);
        }
        return this;
    }

    public DocEntryBuilder withCraftingPages(ItemLike itemLike, ItemLike itemLike2) {
        ItemStack stack;
        List<SinglePageCtor> craftingPages = Documentation.getRecipePages(itemLike, itemLike2);
        this.withPage(craftingPages);
        if (!craftingPages.isEmpty() && !this.displayItem.is(itemLike.asItem())) {
            stack = itemLike.asItem().getDefaultInstance();
            this.addConnectedSearch(stack);
        }
        if (!craftingPages.isEmpty() && !this.displayItem.is(itemLike2.asItem())) {
            stack = itemLike2.asItem().getDefaultInstance();
            this.addConnectedSearch(stack);
        }
        return this;
    }

    public DocEntryBuilder addConnectedSearch(ItemStack connectedItem) {
        if (this.connectedSearches.stream().anyMatch(cs -> cs.icon().is(connectedItem.getItem()))) {
            return this;
        }
        this.connectedSearches.add(new ConnectedSearch(this.entryId, connectedItem.getHoverName(), connectedItem));
        return this;
    }

    public DocEntryBuilder addConnectedSearch(ItemLike itemLike) {
        return this.addConnectedSearch(itemLike.asItem().getDefaultInstance());
    }

    public DocEntryBuilder withCraftingPages() {
        List<SinglePageCtor> pages = Documentation.getRecipePages(RegistryHelper.getRegistryName(this.displayItem.getItem()));
        this.withPage(pages);
        return this;
    }

    public DocEntry build() {
        DocEntry docEntry = new DocEntry(this.entryId, this.displayItem, this.title, this.sortNum).addPages(this.pages);
        for (ConnectedSearch connectedSearch : this.connectedSearches) {
            Search.addConnectedSearch(connectedSearch);
        }
        return docEntry;
    }
}

