/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocPlayerData;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.GuiUtils;
import com.hollingsworth.arsnouveau.client.gui.documentation.IndexScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.PageHolderScreen;
import com.hollingsworth.nuggets.client.gui.GuiHelpers;
import com.hollingsworth.nuggets.client.gui.NuggetMultilLineLabel;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class DocClientUtils {
    public static void openBook() {
        if (DocPlayerData.previousScreen != null) {
            Minecraft.getInstance().setScreen((Screen)DocPlayerData.previousScreen);
            return;
        }
        IndexScreen.open();
    }

    public static void openToEntry(ResourceLocation resourceLocation, int pageIndex) {
        DocEntry entry = DocumentationRegistry.getEntry(resourceLocation);
        if (entry != null) {
            PageHolderScreen pageHolderScreen = new PageHolderScreen(entry);
            pageHolderScreen.arrowIndex = pageIndex < entry.pages().size() ? pageIndex : 0;
            Minecraft.getInstance().setScreen((Screen)pageHolderScreen);
            return;
        }
        IndexScreen.open();
    }

    public static void drawStringScaled(GuiGraphics graphics, Component component, int x, int y, int color, float scale, boolean shadow) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)(x + 3), (float)y, 0.0f);
        graphics.drawString(Minecraft.getInstance().font, (Component)component.copy().withStyle(component.getStyle().withFont(Minecraft.UNIFORM_FONT)), 0, 0, color, shadow);
        poseStack.popPose();
    }

    public static void drawHeader(NuggetMultilLineLabel title, GuiGraphics graphics, int x, int y) {
        title.renderCenteredNoShadow(graphics, x, y + (title.getLineCount() > 1 ? 3 : 7), 8, 0);
    }

    public static void blit(GuiGraphics graphics, DocAssets.BlitInfo info, int x, int y) {
        graphics.blit(info.location(), x, y, (float)info.u(), (float)info.v(), info.width(), info.height(), info.width(), info.height());
    }

    public static ItemStack renderIngredientAtAngle(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float angle, Ingredient ingredient) {
        if (ingredient.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int radius = 41;
        double xPos = (double)x + DocClientUtils.nextXAngle(angle -= 90.0f, radius);
        double yPos = (double)y + DocClientUtils.nextYAngle(angle, radius);
        PoseStack ms = graphics.pose();
        ms.pushPose();
        ms.translate(xPos - (double)((int)xPos), yPos - (double)((int)yPos), 0.0);
        ItemStack hovered = DocClientUtils.renderIngredient(graphics, (int)xPos, (int)yPos, mouseX, mouseY, ingredient);
        ms.popPose();
        return hovered;
    }

    public static double nextXAngle(double angle, int radius) {
        return Math.cos(angle * Math.PI / 180.0) * (double)radius + 32.0;
    }

    public static double nextYAngle(double angle, int radius) {
        return Math.sin(angle * Math.PI / 180.0) * (double)radius + 32.0;
    }

    public static ItemStack renderIngredient(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, Ingredient ingr) {
        ItemStack[] stacks = ingr.getItems();
        if (stacks.length > 0) {
            return DocClientUtils.renderItemStack(graphics, x, y, mouseX, mouseY, stacks[ClientInfo.ticksInGame / 20 % stacks.length]);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack renderItemStack(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Font font = Minecraft.getInstance().font;
        graphics.renderItem(stack, x, y);
        graphics.renderItemDecorations(font, stack, x, y);
        if (GuiUtils.isMouseInRelativeRange(mouseX, mouseY, x, y, 16, 16)) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static void drawHeader(@Nullable Component title, GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY, float partialTick) {
        DocClientUtils.blit(guiGraphics, DocAssets.UNDERLINE, x, y + 9);
        if (title != null) {
            GuiHelpers.drawCenteredStringNoShadow((Font)Minecraft.getInstance().font, (GuiGraphics)guiGraphics, (Component)title, (int)(x + width / 2), (int)y, (int)0);
        }
    }

    public static void drawHeaderNoUnderline(@Nullable Component title, GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY, float partialTick) {
        if (title != null) {
            GuiHelpers.drawCenteredStringNoShadow((Font)Minecraft.getInstance().font, (GuiGraphics)guiGraphics, (Component)title, (int)(x + width / 2), (int)y, (int)0);
        }
    }

    public static void drawParagraph(Component text, GuiGraphics guiGraphics, int x, int y, int width, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float scale = 1.0f;
        poseStack.translate((float)(x + 1), (float)y, 0.0f);
        NuggetMultilLineLabel label = NuggetMultilLineLabel.create((Font)Minecraft.getInstance().font, (Component)text.copy().withStyle(Style.EMPTY.withFont(Minecraft.UNIFORM_FONT)), (int)width);
        int lineHeight = 9;
        label.renderLeftAlignedNoShadow(guiGraphics, 0, 0, lineHeight, 0);
        poseStack.popPose();
    }
}

