/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api;

import com.hollingsworth.arsnouveau.api.recipe.PotionIngredient;
import com.hollingsworth.arsnouveau.api.scrying.IScryer;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.spell.validation.StandardSpellValidator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;

public class ArsNouveauAPI {
    public static boolean ENABLE_DEBUG_NUMBERS = !FMLEnvironment.production;
    private ConcurrentHashMap<ResourceLocation, IScryer> scryerMap = new ConcurrentHashMap();
    private Set<RecipeType<? extends IEnchantingRecipe>> enchantingRecipeTypes = ConcurrentHashMap.newKeySet();
    private ISpellValidator craftingSpellValidator;
    private ISpellValidator castingSpellValidator;
    private List<RecipeHolder<? extends IEnchantingRecipe>> enchantingApparatusRecipes = new ArrayList<RecipeHolder<? extends IEnchantingRecipe>>();
    private List<BrewingRecipe> brewingRecipes = new ArrayList<BrewingRecipe>();
    private static final ArsNouveauAPI INSTANCE = new ArsNouveauAPI();

    public Set<RecipeType<? extends IEnchantingRecipe>> getEnchantingRecipeTypes() {
        return this.enchantingRecipeTypes;
    }

    public List<RecipeHolder<? extends IEnchantingRecipe>> getEnchantingApparatusRecipes(Level world) {
        ArrayList<RecipeHolder<? extends IEnchantingRecipe>> recipes = new ArrayList<RecipeHolder<? extends IEnchantingRecipe>>(this.enchantingApparatusRecipes);
        RecipeManager manager = world.getRecipeManager();
        ArrayList recipesByType = new ArrayList();
        for (RecipeType<? extends IEnchantingRecipe> type : this.enchantingRecipeTypes) {
            recipesByType.addAll(manager.getAllRecipesFor(type));
        }
        recipes.addAll(recipesByType);
        return recipes;
    }

    public List<BrewingRecipe> getAllPotionRecipes(Level world) {
        if (this.brewingRecipes.isEmpty()) {
            world.potionBrewing().getRecipes().forEach(ib -> {
                if (ib instanceof BrewingRecipe) {
                    BrewingRecipe brewingRecipe = (BrewingRecipe)ib;
                    this.brewingRecipes.add(brewingRecipe);
                }
            });
            for (PotionBrewing.Mix mix : world.potionBrewing().potionMixes) {
                this.brewingRecipes.add(new BrewingRecipe(PotionIngredient.fromPotion((Holder<Potion>)mix.from()), mix.ingredient(), PotionIngredient.fromPotion((Holder<Potion>)mix.to()).getItems()[0]));
            }
        }
        return this.brewingRecipes;
    }

    public ISpellValidator getSpellCraftingSpellValidator() {
        if (this.craftingSpellValidator == null) {
            this.craftingSpellValidator = new StandardSpellValidator(false);
        }
        return this.craftingSpellValidator;
    }

    public ISpellValidator getSpellCastingSpellValidator() {
        if (this.castingSpellValidator == null) {
            this.castingSpellValidator = new StandardSpellValidator(true);
        }
        return this.castingSpellValidator;
    }

    @Nullable
    public IScryer getScryer(ResourceLocation id) {
        return this.scryerMap.get(id);
    }

    public boolean registerScryer(IScryer scryer) {
        this.scryerMap.put(scryer.getRegistryName(), scryer);
        return true;
    }

    public void onResourceReload() {
        this.brewingRecipes = new ArrayList<BrewingRecipe>();
    }

    private ArsNouveauAPI() {
    }

    public static ArsNouveauAPI getInstance() {
        return INSTANCE;
    }

    static {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("ars_nouveau"));
    }
}

