/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AttachedStemBlock
extends BushBlock {
    public static final MapCodec<AttachedStemBlock> CODEC = RecordCodecBuilder.mapCodec(p_308799_ -> p_308799_.group((App)ResourceKey.codec(Registries.BLOCK).fieldOf("fruit").forGetter(p_304711_ -> p_304711_.fruit), (App)ResourceKey.codec(Registries.BLOCK).fieldOf("stem").forGetter(p_304975_ -> p_304975_.stem), (App)ResourceKey.codec(Registries.ITEM).fieldOf("seed").forGetter(p_304775_ -> p_304775_.seed), AttachedStemBlock.propertiesCodec()).apply((Applicative)p_308799_, AttachedStemBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    protected static final float AABB_OFFSET = 2.0f;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)Block.box(6.0, 0.0, 6.0, 10.0, 10.0, 16.0), (Object)Direction.WEST, (Object)Block.box(0.0, 0.0, 6.0, 10.0, 10.0, 10.0), (Object)Direction.NORTH, (Object)Block.box(6.0, 0.0, 0.0, 10.0, 10.0, 10.0), (Object)Direction.EAST, (Object)Block.box(6.0, 0.0, 6.0, 16.0, 10.0, 10.0)));
    private final ResourceKey<Block> fruit;
    private final ResourceKey<Block> stem;
    private final ResourceKey<Item> seed;

    public MapCodec<AttachedStemBlock> codec() {
        return CODEC;
    }

    public AttachedStemBlock(ResourceKey<Block> p_304582_, ResourceKey<Block> p_304450_, ResourceKey<Item> p_304828_, BlockBehaviour.Properties p_152062_) {
        super(p_152062_);
        this.registerDefaultState((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)));
        this.stem = p_304582_;
        this.fruit = p_304450_;
        this.seed = p_304828_;
    }

    @Override
    protected VoxelShape getShape(BlockState p_48858_, BlockGetter p_48859_, BlockPos p_48860_, CollisionContext p_48861_) {
        return AABBS.get(p_48858_.getValue((Property)FACING));
    }

    @Override
    protected BlockState updateShape(BlockState p_48848_, Direction p_48849_, BlockState p_48850_, LevelAccessor p_48851_, BlockPos p_48852_, BlockPos p_48853_) {
        Optional<Block> optional;
        if (!p_48850_.is(this.fruit) && p_48849_ == p_48848_.getValue((Property)FACING) && (optional = p_48851_.registryAccess().registryOrThrow(Registries.BLOCK).getOptional(this.stem)).isPresent()) {
            return (BlockState)((Object)optional.get().defaultBlockState().trySetValue((Property)StemBlock.AGE, Integer.valueOf(7)));
        }
        return super.updateShape(p_48848_, p_48849_, p_48850_, p_48851_, p_48852_, p_48853_);
    }

    @Override
    protected boolean mayPlaceOn(BlockState p_48863_, BlockGetter p_48864_, BlockPos p_48865_) {
        return p_48863_.getBlock() instanceof FarmBlock;
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader p_304950_, BlockPos p_48839_, BlockState p_48840_) {
        return new ItemStack((ItemLike)DataFixUtils.orElse(p_304950_.registryAccess().registryOrThrow(Registries.ITEM).getOptional(this.seed), (Object)this));
    }

    @Override
    protected BlockState rotate(BlockState p_48845_, Rotation p_48846_) {
        return (BlockState)((Object)p_48845_.setValue((Property)FACING, (Comparable)p_48846_.rotate((Direction)p_48845_.getValue((Property)FACING))));
    }

    @Override
    protected BlockState mirror(BlockState p_48842_, Mirror p_48843_) {
        return p_48842_.rotate(p_48843_.getRotation((Direction)p_48842_.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_48855_) {
        p_48855_.add(new Property[]{FACING});
    }
}

