/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.PotentialCalculator;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.slf4j.Logger;

public final class NaturalSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MIN_SPAWN_DISTANCE = 24;
    public static final int SPAWN_DISTANCE_CHUNK = 8;
    public static final int SPAWN_DISTANCE_BLOCK = 128;
    static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    private static final MobCategory[] SPAWNING_CATEGORIES = (MobCategory[])Stream.of(MobCategory.values()).filter(p_47037_ -> p_47037_ != MobCategory.MISC).toArray(MobCategory[]::new);

    private NaturalSpawner() {
    }

    public static SpawnState createState(int p_186525_, Iterable<Entity> p_186526_, ChunkGetter p_186527_, LocalMobCapCalculator p_186528_) {
        PotentialCalculator potentialcalculator = new PotentialCalculator();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        for (Entity entity : p_186526_) {
            MobCategory mobcategory;
            Mob mob;
            if (entity instanceof Mob && ((mob = (Mob)entity).isPersistenceRequired() || mob.requiresCustomPersistence()) || (mobcategory = entity.getClassification(true)) == MobCategory.MISC) continue;
            BlockPos blockpos = entity.blockPosition();
            p_186527_.query(ChunkPos.asLong((BlockPos)blockpos), p_275163_ -> {
                MobSpawnSettings.MobSpawnCost mobspawnsettings$mobspawncost = NaturalSpawner.getRoughBiome(blockpos, p_275163_).getMobSettings().getMobSpawnCost(entity.getType());
                if (mobspawnsettings$mobspawncost != null) {
                    potentialcalculator.addCharge(entity.blockPosition(), mobspawnsettings$mobspawncost.charge());
                }
                if (entity instanceof Mob) {
                    p_186528_.addMob(p_275163_.getPos(), mobcategory);
                }
                object2intopenhashmap.addTo((Object)mobcategory, 1);
            });
        }
        return new SpawnState(p_186525_, (Object2IntOpenHashMap<MobCategory>)object2intopenhashmap, potentialcalculator, p_186528_);
    }

    static Biome getRoughBiome(BlockPos p_47096_, ChunkAccess p_47097_) {
        return p_47097_.getNoiseBiome(QuartPos.fromBlock((int)p_47096_.getX()), QuartPos.fromBlock((int)p_47096_.getY()), QuartPos.fromBlock((int)p_47096_.getZ())).value();
    }

    public static void spawnForChunk(ServerLevel p_47030_, LevelChunk p_47031_, SpawnState p_47032_, boolean p_47033_, boolean p_47034_, boolean p_47035_) {
        p_47030_.getProfiler().push("spawner");
        for (MobCategory mobcategory : SPAWNING_CATEGORIES) {
            if (!p_47033_ && mobcategory.isFriendly() || !p_47034_ && !mobcategory.isFriendly() || !p_47035_ && mobcategory.isPersistent() || !p_47032_.canSpawnForCategory(mobcategory, p_47031_.getPos())) continue;
            NaturalSpawner.spawnCategoryForChunk(mobcategory, p_47030_, p_47031_, p_47032_::canSpawn, p_47032_::afterSpawn);
        }
        p_47030_.getProfiler().pop();
    }

    public static void spawnCategoryForChunk(MobCategory p_47046_, ServerLevel p_47047_, LevelChunk p_47048_, SpawnPredicate p_47049_, AfterSpawnCallback p_47050_) {
        BlockPos blockpos = NaturalSpawner.getRandomPosWithin(p_47047_, p_47048_);
        if (blockpos.getY() >= p_47047_.getMinBuildHeight() + 1) {
            NaturalSpawner.spawnCategoryForPosition(p_47046_, p_47047_, p_47048_, blockpos, p_47049_, p_47050_);
        }
    }

    @VisibleForDebug
    public static void spawnCategoryForPosition(MobCategory p_151613_, ServerLevel p_151614_, BlockPos p_151615_) {
        NaturalSpawner.spawnCategoryForPosition(p_151613_, p_151614_, p_151614_.getChunk(p_151615_), p_151615_, (p_151606_, p_151607_, p_151608_) -> true, (p_151610_, p_151611_) -> {});
    }

    public static void spawnCategoryForPosition(MobCategory p_47039_, ServerLevel p_47040_, ChunkAccess p_47041_, BlockPos p_47042_, SpawnPredicate p_47043_, AfterSpawnCallback p_47044_) {
        StructureManager structuremanager = p_47040_.structureManager();
        ChunkGenerator chunkgenerator = p_47040_.getChunkSource().getGenerator();
        int i = p_47042_.getY();
        BlockState blockstate = p_47041_.getBlockState(p_47042_);
        if (!blockstate.isRedstoneConductor(p_47041_, p_47042_)) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int j = 0;
            block0: for (int k = 0; k < 3; ++k) {
                int l = p_47042_.getX();
                int i1 = p_47042_.getZ();
                int j1 = 6;
                MobSpawnSettings.SpawnerData mobspawnsettings$spawnerdata = null;
                SpawnGroupData spawngroupdata = null;
                int k1 = Mth.ceil((float)(p_47040_.random.nextFloat() * 4.0f));
                int l1 = 0;
                for (int i2 = 0; i2 < k1; ++i2) {
                    double d2;
                    blockpos$mutableblockpos.set(l += p_47040_.random.nextInt(6) - p_47040_.random.nextInt(6), i, i1 += p_47040_.random.nextInt(6) - p_47040_.random.nextInt(6));
                    double d0 = (double)l + 0.5;
                    double d1 = (double)i1 + 0.5;
                    Player player = p_47040_.getNearestPlayer(d0, i, d1, -1.0, false);
                    if (player == null || !NaturalSpawner.isRightDistanceToPlayerAndSpawnPoint(p_47040_, p_47041_, blockpos$mutableblockpos, d2 = player.distanceToSqr(d0, i, d1))) continue;
                    if (mobspawnsettings$spawnerdata == null) {
                        Optional<MobSpawnSettings.SpawnerData> optional = NaturalSpawner.getRandomSpawnMobAt(p_47040_, structuremanager, chunkgenerator, p_47039_, p_47040_.random, (BlockPos)blockpos$mutableblockpos);
                        if (optional.isEmpty()) continue block0;
                        mobspawnsettings$spawnerdata = optional.get();
                        k1 = mobspawnsettings$spawnerdata.minCount + p_47040_.random.nextInt(1 + mobspawnsettings$spawnerdata.maxCount - mobspawnsettings$spawnerdata.minCount);
                    }
                    if (!NaturalSpawner.isValidSpawnPostitionForType(p_47040_, p_47039_, structuremanager, chunkgenerator, mobspawnsettings$spawnerdata, blockpos$mutableblockpos, d2) || !p_47043_.test(mobspawnsettings$spawnerdata.type, (BlockPos)blockpos$mutableblockpos, p_47041_)) continue;
                    Mob mob = NaturalSpawner.getMobForSpawn(p_47040_, mobspawnsettings$spawnerdata.type);
                    if (mob == null) {
                        return;
                    }
                    mob.moveTo(d0, i, d1, p_47040_.random.nextFloat() * 360.0f, 0.0f);
                    if (!NaturalSpawner.isValidPositionForMob(p_47040_, mob, d2)) continue;
                    spawngroupdata = mob.finalizeSpawn((ServerLevelAccessor)p_47040_, p_47040_.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.NATURAL, spawngroupdata);
                    ++l1;
                    p_47040_.addFreshEntityWithPassengers(mob);
                    p_47044_.run(mob, p_47041_);
                    if (++j >= EventHooks.getMaxSpawnClusterSize((Mob)mob)) {
                        return;
                    }
                    if (mob.isMaxGroupSizeReached(l1)) continue block0;
                }
            }
        }
    }

    private static boolean isRightDistanceToPlayerAndSpawnPoint(ServerLevel p_47025_, ChunkAccess p_47026_, BlockPos.MutableBlockPos p_47027_, double p_47028_) {
        if (p_47028_ <= 576.0) {
            return false;
        }
        return p_47025_.getSharedSpawnPos().closerToCenterThan((Position)new Vec3((double)p_47027_.getX() + 0.5, (double)p_47027_.getY(), (double)p_47027_.getZ() + 0.5), 24.0) ? false : Objects.equals(new ChunkPos((BlockPos)p_47027_), p_47026_.getPos()) || p_47025_.isNaturalSpawningAllowed((BlockPos)p_47027_);
    }

    private static boolean isValidSpawnPostitionForType(ServerLevel p_220422_, MobCategory p_220423_, StructureManager p_220424_, ChunkGenerator p_220425_, MobSpawnSettings.SpawnerData p_220426_, BlockPos.MutableBlockPos p_220427_, double p_220428_) {
        EntityType<?> entitytype = p_220426_.type;
        if (entitytype.getCategory() == MobCategory.MISC) {
            return false;
        }
        if (!entitytype.canSpawnFarFromPlayer() && p_220428_ > (double)(entitytype.getCategory().getDespawnDistance() * entitytype.getCategory().getDespawnDistance())) {
            return false;
        }
        if (!entitytype.canSummon() || !NaturalSpawner.canSpawnMobAt(p_220422_, p_220424_, p_220425_, p_220423_, p_220426_, (BlockPos)p_220427_)) {
            return false;
        }
        if (!SpawnPlacements.isSpawnPositionOk(entitytype, (LevelReader)((Object)p_220422_), (BlockPos)p_220427_)) {
            return false;
        }
        return !SpawnPlacements.checkSpawnRules(entitytype, (ServerLevelAccessor)p_220422_, MobSpawnType.NATURAL, (BlockPos)p_220427_, p_220422_.random) ? false : p_220422_.noCollision(entitytype.getSpawnAABB((double)p_220427_.getX() + 0.5, p_220427_.getY(), (double)p_220427_.getZ() + 0.5));
    }

    @Nullable
    private static Mob getMobForSpawn(ServerLevel p_46989_, EntityType<?> p_46990_) {
        try {
            Object entity = p_46990_.create(p_46989_);
            if (entity instanceof Mob) {
                return (Mob)((Object)entity);
            }
            LOGGER.warn("Can't spawn entity of type: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(p_46990_));
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to create mob", (Throwable)exception);
        }
        return null;
    }

    private static boolean isValidPositionForMob(ServerLevel p_46992_, Mob p_46993_, double p_46994_) {
        return p_46994_ > (double)(p_46993_.getType().getCategory().getDespawnDistance() * p_46993_.getType().getCategory().getDespawnDistance()) && p_46993_.removeWhenFarAway(p_46994_) ? false : EventHooks.checkSpawnPosition((Mob)p_46993_, (ServerLevelAccessor)p_46992_, (MobSpawnType)MobSpawnType.NATURAL);
    }

    private static Optional<MobSpawnSettings.SpawnerData> getRandomSpawnMobAt(ServerLevel p_220430_, StructureManager p_220431_, ChunkGenerator p_220432_, MobCategory p_220433_, RandomSource p_220434_, BlockPos p_220435_) {
        Holder holder = p_220430_.getBiome(p_220435_);
        return p_220433_ == MobCategory.WATER_AMBIENT && holder.is(BiomeTags.REDUCED_WATER_AMBIENT_SPAWNS) && p_220434_.nextFloat() < 0.98f ? Optional.empty() : NaturalSpawner.mobsAt(p_220430_, p_220431_, p_220432_, p_220433_, p_220435_, holder).getRandom(p_220434_);
    }

    private static boolean canSpawnMobAt(ServerLevel p_220437_, StructureManager p_220438_, ChunkGenerator p_220439_, MobCategory p_220440_, MobSpawnSettings.SpawnerData p_220441_, BlockPos p_220442_) {
        return NaturalSpawner.mobsAt(p_220437_, p_220438_, p_220439_, p_220440_, p_220442_, null).unwrap().contains((Object)p_220441_);
    }

    private static WeightedRandomList<MobSpawnSettings.SpawnerData> mobsAt(ServerLevel p_220444_, StructureManager p_220445_, ChunkGenerator p_220446_, MobCategory p_220447_, BlockPos p_220448_, @Nullable Holder<Biome> p_220449_) {
        StructureSpawnOverride monsterSpawns;
        if (NaturalSpawner.isInNetherFortressBounds(p_220448_, p_220444_, p_220447_, p_220445_) && (monsterSpawns = ((Structure)p_220445_.registryAccess().registryOrThrow(Registries.STRUCTURE).getOrThrow(BuiltinStructures.FORTRESS)).spawnOverrides().get((Object)MobCategory.MONSTER)) != null) {
            return EventHooks.getPotentialSpawns((LevelAccessor)p_220444_, (MobCategory)p_220447_, (BlockPos)p_220448_, (WeightedRandomList)monsterSpawns.spawns());
        }
        return EventHooks.getPotentialSpawns((LevelAccessor)p_220444_, (MobCategory)p_220447_, (BlockPos)p_220448_, p_220446_.getMobsAt(p_220449_ != null ? p_220449_ : p_220444_.getBiome(p_220448_), p_220445_, p_220447_, p_220448_));
    }

    public static boolean isInNetherFortressBounds(BlockPos p_220456_, ServerLevel p_220457_, MobCategory p_220458_, StructureManager p_220459_) {
        if (p_220458_ == MobCategory.MONSTER && p_220457_.getBlockState(p_220456_.below()).is(Blocks.NETHER_BRICKS)) {
            Structure structure = (Structure)p_220459_.registryAccess().registryOrThrow(Registries.STRUCTURE).get(BuiltinStructures.FORTRESS);
            return structure == null ? false : p_220459_.getStructureAt(p_220456_, structure).isValid();
        }
        return false;
    }

    private static BlockPos getRandomPosWithin(Level p_47063_, LevelChunk p_47064_) {
        ChunkPos chunkpos = p_47064_.getPos();
        int i = chunkpos.getMinBlockX() + p_47063_.random.nextInt(16);
        int j = chunkpos.getMinBlockZ() + p_47063_.random.nextInt(16);
        int k = p_47064_.getHeight(Heightmap.Types.WORLD_SURFACE, i, j) + 1;
        int l = Mth.randomBetweenInclusive((RandomSource)p_47063_.random, (int)p_47063_.getMinBuildHeight(), (int)k);
        return new BlockPos(i, l, j);
    }

    public static boolean isValidEmptySpawnBlock(BlockGetter p_47057_, BlockPos p_47058_, BlockState p_47059_, FluidState p_47060_, EntityType<?> p_47061_) {
        if (p_47059_.isCollisionShapeFullBlock(p_47057_, p_47058_)) {
            return false;
        }
        if (p_47059_.isSignalSource()) {
            return false;
        }
        if (!p_47060_.isEmpty()) {
            return false;
        }
        return p_47059_.is(BlockTags.PREVENT_MOB_SPAWNING_INSIDE) ? false : !p_47061_.isBlockDangerous(p_47059_);
    }

    public static void spawnMobsForChunkGeneration(ServerLevelAccessor p_220451_, Holder<Biome> p_220452_, ChunkPos p_220453_, RandomSource p_220454_) {
        MobSpawnSettings mobspawnsettings = p_220452_.value().getMobSettings();
        WeightedRandomList<MobSpawnSettings.SpawnerData> weightedrandomlist = mobspawnsettings.getMobs(MobCategory.CREATURE);
        if (!weightedrandomlist.isEmpty()) {
            int i = p_220453_.getMinBlockX();
            int j = p_220453_.getMinBlockZ();
            while (p_220454_.nextFloat() < mobspawnsettings.getCreatureProbability()) {
                Optional optional = weightedrandomlist.getRandom(p_220454_);
                if (optional.isEmpty()) continue;
                MobSpawnSettings.SpawnerData mobspawnsettings$spawnerdata = (MobSpawnSettings.SpawnerData)((Object)optional.get());
                int k = mobspawnsettings$spawnerdata.minCount + p_220454_.nextInt(1 + mobspawnsettings$spawnerdata.maxCount - mobspawnsettings$spawnerdata.minCount);
                SpawnGroupData spawngroupdata = null;
                int l = i + p_220454_.nextInt(16);
                int i1 = j + p_220454_.nextInt(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockpos = NaturalSpawner.getTopNonCollidingPos((LevelReader)p_220451_, mobspawnsettings$spawnerdata.type, l, i1);
                        if (mobspawnsettings$spawnerdata.type.canSummon() && SpawnPlacements.isSpawnPositionOk(mobspawnsettings$spawnerdata.type, (LevelReader)p_220451_, blockpos)) {
                            Mob mob;
                            Object entity;
                            float f = mobspawnsettings$spawnerdata.type.getWidth();
                            double d0 = Mth.clamp((double)l, (double)((double)i + (double)f), (double)((double)i + 16.0 - (double)f));
                            double d1 = Mth.clamp((double)i1, (double)((double)j + (double)f), (double)((double)j + 16.0 - (double)f));
                            if (!p_220451_.noCollision(mobspawnsettings$spawnerdata.type.getSpawnAABB(d0, blockpos.getY(), d1)) || !SpawnPlacements.checkSpawnRules(mobspawnsettings$spawnerdata.type, p_220451_, MobSpawnType.CHUNK_GENERATION, BlockPos.containing((double)d0, (double)blockpos.getY(), (double)d1), p_220451_.getRandom())) continue;
                            try {
                                entity = mobspawnsettings$spawnerdata.type.create(p_220451_.getLevel());
                            }
                            catch (Exception exception) {
                                LOGGER.warn("Failed to create mob", (Throwable)exception);
                                continue;
                            }
                            if (entity == null) continue;
                            ((Entity)((Object)entity)).moveTo(d0, blockpos.getY(), d1, p_220454_.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof Mob && EventHooks.checkSpawnPosition((Mob)(mob = (Mob)((Object)entity)), (ServerLevelAccessor)p_220451_, (MobSpawnType)MobSpawnType.CHUNK_GENERATION)) {
                                spawngroupdata = mob.finalizeSpawn(p_220451_, p_220451_.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.CHUNK_GENERATION, spawngroupdata);
                                p_220451_.addFreshEntityWithPassengers((Entity)mob);
                                flag = true;
                            }
                        }
                        l += p_220454_.nextInt(5) - p_220454_.nextInt(5);
                        i1 += p_220454_.nextInt(5) - p_220454_.nextInt(5);
                        while (l < i || l >= i + 16 || i1 < j || i1 >= j + 16) {
                            l = j1 + p_220454_.nextInt(5) - p_220454_.nextInt(5);
                            i1 = k1 + p_220454_.nextInt(5) - p_220454_.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPos getTopNonCollidingPos(LevelReader p_47066_, EntityType<?> p_47067_, int p_47068_, int p_47069_) {
        int i = p_47066_.getHeight(SpawnPlacements.getHeightmapType(p_47067_), p_47068_, p_47069_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_47068_, i, p_47069_);
        if (p_47066_.dimensionType().hasCeiling()) {
            do {
                blockpos$mutableblockpos.move(Direction.DOWN);
            } while (!p_47066_.getBlockState((BlockPos)blockpos$mutableblockpos).isAir());
            do {
                blockpos$mutableblockpos.move(Direction.DOWN);
            } while (p_47066_.getBlockState((BlockPos)blockpos$mutableblockpos).isAir() && blockpos$mutableblockpos.getY() > p_47066_.getMinBuildHeight());
        }
        return SpawnPlacements.getPlacementType(p_47067_).adjustSpawnPosition(p_47066_, blockpos$mutableblockpos.immutable());
    }

    @FunctionalInterface
    public static interface ChunkGetter {
        public void query(long var1, Consumer<LevelChunk> var3);
    }

    public static class SpawnState {
        private final int spawnableChunkCount;
        private final Object2IntOpenHashMap<MobCategory> mobCategoryCounts;
        private final PotentialCalculator spawnPotential;
        private final Object2IntMap<MobCategory> unmodifiableMobCategoryCounts;
        private final LocalMobCapCalculator localMobCapCalculator;
        @Nullable
        private BlockPos lastCheckedPos;
        @Nullable
        private EntityType<?> lastCheckedType;
        private double lastCharge;

        SpawnState(int p_186544_, Object2IntOpenHashMap<MobCategory> p_186545_, PotentialCalculator p_186546_, LocalMobCapCalculator p_186547_) {
            this.spawnableChunkCount = p_186544_;
            this.mobCategoryCounts = p_186545_;
            this.spawnPotential = p_186546_;
            this.localMobCapCalculator = p_186547_;
            this.unmodifiableMobCategoryCounts = Object2IntMaps.unmodifiable(p_186545_);
        }

        private boolean canSpawn(EntityType<?> p_47128_, BlockPos p_47129_, ChunkAccess p_47130_) {
            double d0;
            this.lastCheckedPos = p_47129_;
            this.lastCheckedType = p_47128_;
            MobSpawnSettings.MobSpawnCost mobspawnsettings$mobspawncost = NaturalSpawner.getRoughBiome(p_47129_, p_47130_).getMobSettings().getMobSpawnCost(p_47128_);
            if (mobspawnsettings$mobspawncost == null) {
                this.lastCharge = 0.0;
                return true;
            }
            this.lastCharge = d0 = mobspawnsettings$mobspawncost.charge();
            double d1 = this.spawnPotential.getPotentialEnergyChange(p_47129_, d0);
            return d1 <= mobspawnsettings$mobspawncost.energyBudget();
        }

        private void afterSpawn(Mob p_47132_, ChunkAccess p_47133_) {
            MobSpawnSettings.MobSpawnCost mobspawnsettings$mobspawncost;
            EntityType<?> entitytype = p_47132_.getType();
            BlockPos blockpos = p_47132_.blockPosition();
            double d0 = blockpos.equals((Object)this.lastCheckedPos) && entitytype == this.lastCheckedType ? this.lastCharge : ((mobspawnsettings$mobspawncost = NaturalSpawner.getRoughBiome(blockpos, p_47133_).getMobSettings().getMobSpawnCost(entitytype)) != null ? mobspawnsettings$mobspawncost.charge() : 0.0);
            this.spawnPotential.addCharge(blockpos, d0);
            MobCategory mobcategory = entitytype.getCategory();
            this.mobCategoryCounts.addTo((Object)mobcategory, 1);
            this.localMobCapCalculator.addMob(new ChunkPos(blockpos), mobcategory);
        }

        public int getSpawnableChunkCount() {
            return this.spawnableChunkCount;
        }

        public Object2IntMap<MobCategory> getMobCategoryCounts() {
            return this.unmodifiableMobCategoryCounts;
        }

        boolean canSpawnForCategory(MobCategory p_186549_, ChunkPos p_186550_) {
            int i = p_186549_.getMaxInstancesPerChunk() * this.spawnableChunkCount / MAGIC_NUMBER;
            return this.mobCategoryCounts.getInt((Object)p_186549_) >= i ? false : this.localMobCapCalculator.canSpawn(p_186549_, p_186550_);
        }
    }

    @FunctionalInterface
    public static interface SpawnPredicate {
        public boolean test(EntityType<?> var1, BlockPos var2, ChunkAccess var3);
    }

    @FunctionalInterface
    public static interface AfterSpawnCallback {
        public void run(Mob var1, ChunkAccess var2);
    }
}

