/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;

public class BoneMealItem
extends Item {
    public static final int GRASS_SPREAD_WIDTH = 3;
    public static final int GRASS_SPREAD_HEIGHT = 1;
    public static final int GRASS_COUNT_MULTIPLIER = 3;

    public BoneMealItem(Item.Properties p_40626_) {
        super(p_40626_);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_40637_) {
        Level level = p_40637_.getLevel();
        BlockPos blockpos = p_40637_.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(p_40637_.getClickedFace());
        if (BoneMealItem.applyBonemeal(p_40637_.getItemInHand(), level, blockpos, p_40637_.getPlayer())) {
            if (!level.isClientSide) {
                p_40637_.getPlayer().gameEvent(GameEvent.ITEM_INTERACT_FINISH);
                level.levelEvent(1505, blockpos, 15);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockState blockstate = level.getBlockState(blockpos);
        boolean flag = blockstate.isFaceSturdy((BlockGetter)((Object)level), blockpos, p_40637_.getClickedFace());
        if (flag && BoneMealItem.growWaterPlant(p_40637_.getItemInHand(), level, blockpos1, p_40637_.getClickedFace())) {
            if (!level.isClientSide) {
                p_40637_.getPlayer().gameEvent(GameEvent.ITEM_INTERACT_FINISH);
                level.levelEvent(1505, blockpos1, 15);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Deprecated
    public static boolean growCrop(ItemStack p_40628_, Level p_40629_, BlockPos p_40630_) {
        if (p_40629_ instanceof ServerLevel) {
            return BoneMealItem.applyBonemeal(p_40628_, p_40629_, p_40630_, null);
        }
        return false;
    }

    public static boolean applyBonemeal(ItemStack p_40628_, Level p_40629_, BlockPos p_40630_, @Nullable Player player) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = p_40629_.getBlockState(p_40630_);
        BonemealEvent event = EventHooks.fireBonemealEvent((Player)player, (Level)p_40629_, (BlockPos)p_40630_, (BlockState)blockstate, (ItemStack)p_40628_);
        if (event.isCanceled()) {
            return event.isSuccessful();
        }
        Block block = blockstate.getBlock();
        if (block instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)((Object)p_40629_), p_40630_, blockstate)) {
            if (p_40629_ instanceof ServerLevel) {
                if (bonemealableblock.isBonemealSuccess(p_40629_, p_40629_.random, p_40630_, blockstate)) {
                    bonemealableblock.performBonemeal((ServerLevel)p_40629_, p_40629_.random, p_40630_, blockstate);
                }
                p_40628_.shrink(1);
            }
            return true;
        }
        return false;
    }

    public static boolean growWaterPlant(ItemStack p_40632_, Level p_40633_, BlockPos p_40634_, @Nullable Direction p_40635_) {
        if (p_40633_.getBlockState(p_40634_).is(Blocks.WATER) && p_40633_.getFluidState(p_40634_).getAmount() == 8) {
            if (!(p_40633_ instanceof ServerLevel)) {
                return true;
            }
            RandomSource randomsource = p_40633_.getRandom();
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = p_40634_;
                BlockState blockstate = Blocks.SEAGRASS.defaultBlockState();
                for (int j = 0; j < i / 16; ++j) {
                    if (p_40633_.getBlockState(blockpos = blockpos.offset(randomsource.nextInt(3) - 1, (randomsource.nextInt(3) - 1) * randomsource.nextInt(3) / 2, randomsource.nextInt(3) - 1)).isCollisionShapeFullBlock((BlockGetter)((Object)p_40633_), blockpos)) continue block0;
                }
                Holder holder = p_40633_.getBiome(blockpos);
                if (holder.is(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL)) {
                    if (i == 0 && p_40635_ != null && p_40635_.getAxis().isHorizontal()) {
                        blockstate = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.WALL_CORALS, p_40633_.random).map(p_204100_ -> ((Block)p_204100_.value()).defaultBlockState()).orElse(blockstate);
                        if (blockstate.hasProperty((Property)BaseCoralWallFanBlock.FACING)) {
                            blockstate = (BlockState)((Object)blockstate.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)p_40635_));
                        }
                    } else if (randomsource.nextInt(4) == 0) {
                        blockstate = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.UNDERWATER_BONEMEALS, p_40633_.random).map(p_204095_ -> ((Block)p_204095_.value()).defaultBlockState()).orElse(blockstate);
                    }
                }
                if (blockstate.is(BlockTags.WALL_CORALS, p_204093_ -> p_204093_.hasProperty((Property)BaseCoralWallFanBlock.FACING))) {
                    for (int k = 0; !blockstate.canSurvive((LevelReader)((Object)p_40633_), blockpos) && k < 4; ++k) {
                        blockstate = (BlockState)((Object)blockstate.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(randomsource)));
                    }
                }
                if (!blockstate.canSurvive((LevelReader)((Object)p_40633_), blockpos)) continue;
                BlockState blockstate1 = p_40633_.getBlockState(blockpos);
                if (blockstate1.is(Blocks.WATER) && p_40633_.getFluidState(blockpos).getAmount() == 8) {
                    p_40633_.setBlock(blockpos, blockstate, 3);
                    continue;
                }
                if (!blockstate1.is(Blocks.SEAGRASS) || randomsource.nextInt(10) != 0) continue;
                ((BonemealableBlock)Blocks.SEAGRASS).performBonemeal((ServerLevel)p_40633_, randomsource, blockpos, blockstate1);
            }
            p_40632_.shrink(1);
            return true;
        }
        return false;
    }

    public static void addGrowthParticles(LevelAccessor p_40639_, BlockPos p_40640_, int p_40641_) {
        BlockState blockstate = p_40639_.getBlockState(p_40640_);
        Block block = blockstate.getBlock();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock bonemealableblock = (BonemealableBlock)block;
            BlockPos blockpos = bonemealableblock.getParticlePos(p_40640_);
            switch (bonemealableblock.getType()) {
                case NEIGHBOR_SPREADER: {
                    ParticleUtils.spawnParticles((LevelAccessor)p_40639_, (BlockPos)blockpos, (int)(p_40641_ * 3), (double)3.0, (double)1.0, (boolean)false, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                    break;
                }
                case GROWER: {
                    ParticleUtils.spawnParticleInBlock((LevelAccessor)p_40639_, (BlockPos)blockpos, (int)p_40641_, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                }
            }
        } else if (blockstate.is(Blocks.WATER)) {
            ParticleUtils.spawnParticles((LevelAccessor)p_40639_, (BlockPos)p_40640_, (int)(p_40641_ * 3), (double)3.0, (double)1.0, (boolean)false, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
        }
    }
}

